/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.text.Strings;

public class AddDeploySensorsInitializer
implements EntityInitializer {
    public static final String DEPLOYMENT_METADATA = "deployment.metadata";

    public void apply(EntityLocal entity) {
        if (entity.getParent() != null) {
            return;
        }
        EntitlementContext entitlementContext = Entitlements.getEntitlementContext();
        AttributeSensor<DeploymentMetadata> sensor = Sensors.newSensor(DeploymentMetadata.class, DEPLOYMENT_METADATA, "A map of metadata information about this particular deployment. Contains at least who triggered it and when.");
        ((EntityInternal)entity).getMutableEntityType().addSensor((Sensor<?>)sensor);
        DeploymentMetadata result = new DeploymentMetadata();
        result.read(entity.config().get(ConfigKeys.newConfigKey(Object.class, DEPLOYMENT_METADATA)), false);
        result.read(BrooklynTags.findSingleKeyMapValue(DEPLOYMENT_METADATA, Object.class, (Iterable<Object>)entity.tags().getTags()), false);
        result.read(ImmutableMap.of((Object)"user", (Object)(entitlementContext != null ? entitlementContext.user() : "Unknown"), (Object)"created", (Object)Instant.now()), false);
        entity.sensors().set(sensor, (Object)result);
    }

    public static class DeploymentMetadata {
        String user;
        Instant created;

        public void read(Object inputO, boolean overwrite) {
            Object value;
            Map input;
            if (inputO == null) {
                return;
            }
            if (inputO instanceof DeploymentMetadata) {
                input = MutableMap.of((Object)"user", (Object)((DeploymentMetadata)inputO).user, (Object)"created", (Object)((DeploymentMetadata)inputO).created);
            } else {
                if (!(inputO instanceof Map)) {
                    return;
                }
                input = (Map)inputO;
            }
            if ((overwrite || Strings.isBlank((CharSequence)this.user)) && Strings.isNonBlank((CharSequence)(value = Strings.toString(input.get("user"))))) {
                this.user = value;
            }
            if ((overwrite || this.created == null) && (value = (Instant)TypeCoercions.tryCoerce(input.get("created"), Instant.class).orNull()) != null) {
                this.created = value;
            }
        }
    }
}

