/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskQueueingContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicSequentialTask;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class EffectorTasks {
    private static final Logger log = LoggerFactory.getLogger(EffectorTasks.class);

    public static <T> ConfigKey<T> asConfigKey(ParameterType<T> t) {
        return ConfigKeys.newConfigKey(t.getParameterType(), t.getName());
    }

    public static <T> ParameterTask<T> parameter(ParameterType<T> t) {
        return new ParameterTask<T>(EffectorTasks.asConfigKey(t)).name("parameter " + t);
    }

    public static <T> ParameterTask<T> parameter(Class<T> type, String name) {
        return new ParameterTask<T>(ConfigKeys.newConfigKey(type, name)).name("parameter " + name + " (" + type + ")");
    }

    public static <T> ParameterTask<T> parameter(ConfigKey<T> p) {
        return new ParameterTask<T>(p);
    }

    public static <T> EffectorTaskFactory<T> of(final Task<T> task) {
        return new EffectorTaskFactory<T>(){

            @Override
            public Task<T> newTask(Entity entity, Effector<T> effector, ConfigBag parameters) {
                return task;
            }
        };
    }

    public static Entity findEntity() {
        return (Entity)Preconditions.checkNotNull((Object)BrooklynTaskTags.getTargetOrContextEntity(Tasks.current()), (Object)"This must be executed in a task whose execution context has a target or context entity (i.e. it must be run from within an effector)");
    }

    public static <T extends Entity> T findEntity(Class<T> type) {
        Entity t = EffectorTasks.findEntity();
        return (T)((Entity)Reflections.cast((Object)t, type));
    }

    public static <T extends MachineLocation> T findMachine(Class<T> clazz) {
        return EffectorTasks.getMachine(EffectorTasks.findEntity(), clazz);
    }

    public static <T extends MachineLocation> T getMachine(Entity entity, Class<T> clazz) {
        try {
            return (T)((MachineLocation)Machines.findUniqueMachineLocation(entity.getLocations(), clazz).get());
        }
        catch (Exception e) {
            throw new IllegalStateException("Entity " + entity + " (in " + Tasks.current() + ") requires a single " + clazz.getName() + ", but has " + entity.getLocations(), e);
        }
    }

    public static SshMachineLocation findSshMachine() {
        return EffectorTasks.getSshMachine(EffectorTasks.findEntity());
    }

    public static SshMachineLocation getSshMachine(Entity entity) {
        return EffectorTasks.getMachine(entity, SshMachineLocation.class);
    }

    public static class ParameterTask<T>
    implements EffectorTaskFactory<T> {
        final ConfigKey<T> p;
        private TaskBuilder<T> builder;

        public ParameterTask(ConfigKey<T> p) {
            this.p = p;
            this.builder = Tasks.builder().displayName("parameter " + p);
        }

        public ParameterTask<T> name(String taskName) {
            this.builder.displayName(taskName);
            return this;
        }

        @Override
        public Task<T> newTask(Entity entity, Effector<T> effector, final ConfigBag parameters) {
            return this.builder.body(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return parameters.get(p);
                }
            }).build();
        }
    }

    static class EffectorMarkingTaskFactory<T>
    implements EffectorTaskFactory<T> {
        private final EffectorTaskFactory<T> effectorTaskFactory;

        public EffectorMarkingTaskFactory(EffectorTaskFactory<T> effectorTaskFactory) {
            this.effectorTaskFactory = effectorTaskFactory;
        }

        @Override
        public Task<T> newTask(final Entity entity, final Effector<T> effector, ConfigBag parameters) {
            if (this.effectorTaskFactory instanceof EffectorBodyTaskFactory) {
                return this.effectorTaskFactory.newTask(entity, effector, parameters).asTask();
            }
            if (BrooklynTaskTags.isInEffectorTask(Tasks.current(), entity, effector, false)) {
                return this.effectorTaskFactory.newTask(entity, effector, parameters).asTask();
            }
            return new EffectorBodyTaskFactory<T>(new EffectorBody<T>(){

                @Override
                public T call(ConfigBag parameters) {
                    TaskAdaptable t = DynamicTasks.queue(effectorTaskFactory.newTask(entity, effector, parameters));
                    return t.asTask().getUnchecked();
                }
            }).newTask(entity, effector, parameters);
        }
    }

    public static class EffectorBodyTaskFactory<T>
    implements EffectorTaskFactory<T> {
        private final EffectorBody<T> effectorBody;

        public EffectorBodyTaskFactory(EffectorBody<T> effectorBody) {
            this.effectorBody = effectorBody;
        }

        @Override
        public Task<T> newTask(final Entity entity, final Effector<T> effector, final ConfigBag parameters) {
            final AtomicReference<2> dst = new AtomicReference<2>();
            dst.set(new DynamicSequentialTask<T>(this.getFlagsForTaskInvocationAt(entity, effector, parameters), new Callable<T>(){

                @Override
                public T call() throws Exception {
                    try {
                        DynamicTasks.setTaskQueueingContext((TaskQueueingContext)dst.get());
                        Object t = effectorBody.call(parameters);
                        return t;
                    }
                    finally {
                        DynamicTasks.removeTaskQueueingContext();
                    }
                }
            }){

                @Override
                public void handleException(Throwable throwable) throws Exception {
                    throw EffectorUtils.handleEffectorException(entity, effector, throwable);
                }
            });
            return (Task)dst.get();
        }

        protected Map<String, Object> getFlagsForTaskInvocationAt(Entity entity, Effector<?> effector, ConfigBag parameters) {
            return EffectorUtils.getTaskFlagsForEffectorInvocation(entity, effector, parameters);
        }
    }

    public static interface EffectorTaskFactory<T> {
        public TaskAdaptable<T> newTask(Entity var1, Effector<T> var2, ConfigBag var3);
    }
}

