/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;

public class Dumper {
    public static void dumpInfo(Iterable<? extends Entity> entities) {
        for (Entity entity : entities) {
            Dumper.dumpInfo(entity);
        }
    }

    public static void dumpInfo(Entity e) {
        try {
            Dumper.dumpInfo(e, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Entity e, Writer out) throws IOException {
        Dumper.dumpInfo(e, out, "", "  ");
    }

    static void dumpInfo(Entity e, String currentIndentation, String tab) throws IOException {
        Dumper.dumpInfo(e, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    /*
     * WARNING - void declaration
     */
    static void dumpInfo(Entity e, Writer out, String currentIndentation, String tab) throws IOException {
        List searchPath;
        out.append(currentIndentation + e.toString() + " " + e.getId() + "\n");
        out.append(currentIndentation + tab + tab + "displayName = " + e.getDisplayName() + "\n");
        if (Strings.isNonBlank((CharSequence)e.getCatalogItemId())) {
            out.append(currentIndentation + tab + tab + "catalogItemId = " + e.getCatalogItemId() + "\n");
        }
        if (!(searchPath = e.getCatalogItemIdSearchPath()).isEmpty()) {
            out.append(currentIndentation + tab + tab + "searchPath = [");
            for (int i = 0; i < searchPath.size(); ++i) {
                out.append(i > 0 ? ",\n" : "\n");
                out.append(currentIndentation + tab + tab + tab + (String)searchPath.get(i));
            }
            out.append("\n" + currentIndentation + tab + tab + "]\n");
        }
        out.append(currentIndentation + tab + tab + "locations = " + e.getLocations() + "\n");
        LinkedHashSet keys = Sets.newLinkedHashSet(((EntityInternal)e).config().getLocalBag().getAllConfigAsConfigKeyMap().keySet());
        for (ConfigKey<?> configKey : Dumper.sortConfigKeys(keys)) {
            void var7_8;
            Maybe<Object> mv;
            ConfigKey realKey = e.getEntityType().getConfigKey(configKey.getName());
            if (realKey != null) {
                ConfigKey configKey2 = realKey;
            }
            if (Entities.isTrivial(mv = ((EntityInternal)e).config().getLocalRaw((ConfigKey<?>)var7_8))) continue;
            Object v = mv.get();
            out.append(currentIndentation + tab + tab + var7_8.getName());
            out.append(" = ");
            if (Dumper.isSecret(var7_8.getName())) {
                out.append("xxxxxxxx");
            } else if (v instanceof Task && ((Task)v).isDone()) {
                if (((Task)v).isError()) {
                    out.append("ERROR in " + v);
                } else {
                    try {
                        out.append(((Task)v).get() + " (from " + v + ")");
                    }
                    catch (ExecutionException ee) {
                        throw new IllegalStateException("task " + v + " done and !isError, but threw exception on get", ee);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            } else {
                out.append("" + v);
            }
            out.append("\n");
        }
        for (Sensor sensor : Dumper.sortSensors(e.getEntityType().getSensors())) {
            Object v;
            if (!(sensor instanceof AttributeSensor) || Entities.isTrivial(v = e.getAttribute((AttributeSensor)sensor))) continue;
            out.append(currentIndentation + tab + tab + sensor.getName());
            out.append(": ");
            if (Dumper.isSecret(sensor.getName())) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + v);
            }
            out.append("\n");
        }
        if (e instanceof Group) {
            StringBuilder members = new StringBuilder();
            for (Entity it : ((Group)e).getMembers()) {
                if (members.length() > 0) {
                    members.append(", ");
                }
                members.append(it.getId());
            }
            out.append(currentIndentation + tab + tab + "Members: " + members.toString() + "\n");
        }
        if (!e.policies().isEmpty()) {
            out.append(currentIndentation + tab + tab + "Policies:\n");
            for (Policy policy : e.policies()) {
                Dumper.dumpInfo(policy, out, currentIndentation + tab + tab + tab, tab);
            }
        }
        if (!e.enrichers().isEmpty()) {
            out.append(currentIndentation + tab + tab + "Enrichers:\n");
            for (Enricher enricher : e.enrichers()) {
                Dumper.dumpInfo(enricher, out, currentIndentation + tab + tab + tab, tab);
            }
        }
        if (!((EntityInternal)e).feeds().getFeeds().isEmpty()) {
            out.append(currentIndentation + tab + tab + "Feeds:\n");
            for (Feed feed : ((EntityInternal)e).feeds().getFeeds()) {
                Dumper.dumpInfo(feed, out, currentIndentation + tab + tab + tab, tab);
            }
        }
        for (Entity entity : e.getChildren()) {
            Dumper.dumpInfo(entity, out, currentIndentation + tab, tab);
        }
        out.flush();
    }

    public static void dumpInfo(Location loc) {
        try {
            Dumper.dumpInfo(loc, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Location loc, Writer out) throws IOException {
        Dumper.dumpInfo(loc, out, "", "  ");
    }

    static void dumpInfo(Location loc, String currentIndentation, String tab) throws IOException {
        Dumper.dumpInfo(loc, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    static void dumpInfo(Location loc, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + loc.toString() + "\n");
        for (Map.Entry<String, Object> entry : ((LocationInternal)loc).config().getBag().getAllConfig().entrySet()) {
            String key;
            Map.Entry<String, Object> entry2 = entry;
            String keyO = entry2.getKey();
            String string = keyO instanceof ConfigKey.HasConfigKey ? ((ConfigKey.HasConfigKey)keyO).getConfigKey().getName() : (keyO instanceof ConfigKey ? ((ConfigKey)keyO).getName() : (key = keyO == null ? null : keyO.toString()));
            Object val = entry2.getValue();
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Dumper.isSecret(key)) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val);
            }
            out.append("\n");
        }
        for (Map.Entry<String, Object> entry : Dumper.sortMap(FlagUtils.getFieldsWithFlags(loc)).entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Dumper.isSecret(key)) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val);
            }
            out.append("\n");
        }
        for (Location location : loc.getChildren()) {
            Dumper.dumpInfo(location, out, currentIndentation + tab, tab);
        }
        out.flush();
    }

    public static void dumpInfo(Enricher enr) {
        try {
            Dumper.dumpInfo(enr, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Enricher enr, Writer out) throws IOException {
        Dumper.dumpInfo(enr, out, "", "  ");
    }

    static void dumpInfo(Enricher enr, String currentIndentation, String tab) throws IOException {
        Dumper.dumpInfo(enr, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    static void dumpInfo(Enricher enr, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + enr.toString() + "\n");
        for (ConfigKey<?> key : Dumper.sortConfigKeys(enr.getEnricherType().getConfigKeys())) {
            Maybe<Object> val = ((BrooklynObjectInternal)enr).config().getRaw(key);
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Dumper.isSecret(key.getName())) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val.get());
            }
            out.append("\n");
        }
        out.flush();
    }

    static void dumpInfo(Feed feed, String currentIndentation, String tab) throws IOException {
        Dumper.dumpInfo(feed, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    static void dumpInfo(Feed feed, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + feed.toString() + "\n");
        for (ConfigKey<?> key : Dumper.sortConfigKeys(((BrooklynObjectInternal)feed).config().getBag().getAllConfigAsConfigKeyMap().keySet())) {
            Maybe<Object> val = ((BrooklynObjectInternal)feed).config().getRaw(key);
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Dumper.isSecret(key.getName())) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val.get());
            }
            out.append("\n");
        }
        out.flush();
    }

    public static void dumpInfo(Policy pol) {
        try {
            Dumper.dumpInfo(pol, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Policy pol, Writer out) throws IOException {
        Dumper.dumpInfo(pol, out, "", "  ");
    }

    static void dumpInfo(Policy pol, String currentIndentation, String tab) throws IOException {
        Dumper.dumpInfo(pol, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    static void dumpInfo(Policy pol, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + pol.toString() + "\n");
        for (ConfigKey<?> key : Dumper.sortConfigKeys(pol.getPolicyType().getConfigKeys())) {
            Maybe<Object> val = ((BrooklynObjectInternal)pol).config().getRaw(key);
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Dumper.isSecret(key.getName())) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val.get());
            }
            out.append("\n");
        }
        out.flush();
    }

    public static void dumpInfo(Task<?> t) {
        try {
            Dumper.dumpInfo(t, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Task<?> t, Writer out) throws IOException {
        Dumper.dumpInfo(t, out, "", "  ");
    }

    static void dumpInfo(Task<?> t, String currentIndentation, String tab) throws IOException {
        Dumper.dumpInfo(t, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    static void dumpInfo(Task<?> t, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + t + ": " + t.getStatusDetail(false) + "\n");
        if (t instanceof HasTaskChildren) {
            for (Task child : ((HasTaskChildren)t).getChildren()) {
                Dumper.dumpInfo(child, out, currentIndentation + tab, tab);
            }
        }
        out.flush();
    }

    static List<Sensor<?>> sortSensors(Set<Sensor<?>> sensors) {
        ArrayList result = new ArrayList(sensors);
        Collections.sort(result, new Comparator<Sensor>(){

            @Override
            public int compare(Sensor arg0, Sensor arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return result;
    }

    static List<ConfigKey<?>> sortConfigKeys(Set<ConfigKey<?>> configs) {
        ArrayList result = new ArrayList(configs);
        Collections.sort(result, new Comparator<ConfigKey>(){

            @Override
            public int compare(ConfigKey arg0, ConfigKey arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return result;
    }

    static <T> Map<String, T> sortMap(Map<String, T> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        ArrayList order = Lists.newArrayList(map.keySet());
        Collections.sort(order, String.CASE_INSENSITIVE_ORDER);
        for (String key : order) {
            result.put(key, map.get(key));
        }
        return result;
    }

    private static boolean isSecret(String name) {
        return Sanitizer.IS_SECRET_PREDICATE.apply((Object)name);
    }
}

