/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensorInitializer;
import org.apache.brooklyn.core.effector.AddSensorInitializerAbstractProto;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.sensor.AbstractAddTriggerableSensor;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.workflow.WorkflowCommonConfig;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowPolicy;
import org.apache.brooklyn.core.workflow.steps.appmodel.EntityValueToSet;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class WorkflowSensor<T>
extends AbstractAddTriggerableSensor<T>
implements WorkflowCommonConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowSensor.class);
    public static final ConfigKey<String> SENSOR_TYPE = ConfigKeys.newConfigKeyWithDefault(AddSensorInitializer.SENSOR_TYPE, Object.class.getName());
    public static final ConfigKey<EntityValueToSet> SENSOR = ConfigKeys.newConfigKey(EntityValueToSet.class, "sensor");
    public static final ConfigKey<String> UNIQUE_TAG_CAMEL = ConfigKeys.newStringConfigKey("uniqueTag");
    public static final ConfigKey<String> UNIQUE_TAG_UNDERSCORE = ConfigKeys.newStringConfigKey("unique_tag");
    public static final ConfigKey<String> UNIQUE_TAG_DASH = ConfigKeys.newStringConfigKey("unique-tag");

    static String getUniqueTag(ConfigBag bag, String defaultValue) {
        String result = bag.get(UNIQUE_TAG_CAMEL);
        if (result == null) {
            result = bag.get(UNIQUE_TAG_UNDERSCORE);
        }
        if (result == null) {
            result = bag.get(UNIQUE_TAG_DASH);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public WorkflowSensor() {
    }

    public WorkflowSensor(ConfigBag params) {
        super(params);
    }

    @Override
    public void apply(EntityLocal entity) {
        ConfigBag params = this.initParams();
        this.apply(entity, params);
    }

    private void apply(EntityLocal entity, ConfigBag params) {
        AttributeSensor sensor = this.addSensor(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding workflow sensor {} to {}", (Object)sensor.getName(), (Object)entity);
        }
        WorkflowPollCallable wc = new WorkflowPollCallable(WorkflowExecutionContext.WorkflowContextType.SENSOR, "Workflow for sensor " + sensor.getName(), params, null);
        FunctionPollConfig pollConfig = (FunctionPollConfig)new FunctionPollConfig(sensor).callable(wc).onSuccess(TypeCoercions.function(sensor.getTypeToken().getRawType()));
        this.standardPollConfig((Entity)entity, this.initParams(), pollConfig);
        FunctionFeed.Builder feedBuilder = FunctionFeed.builder().name("Sensor Workflow Feed: " + sensor.getName()).entity((Entity)entity).onlyIfServiceUp((Boolean)Maybe.ofDisallowingNull(EntityInitializers.resolve(params, ONLY_IF_SERVICE_UP)).or((Object)false)).uniqueTag(WorkflowSensor.getUniqueTag(params, "workflow_sensor_feed:" + sensor.getName())).poll(pollConfig);
        wc.init(feedBuilder.build(true));
    }

    @Override
    protected AttributeSensor<T> sensor(Entity entity) {
        EntityValueToSet s = this.lookupSensorReference(entity);
        TypeToken<T> clazz = s.type == null ? TypeToken.of(Object.class) : WorkflowSensor.getType(entity, s.type, s.name);
        return Sensors.newSensor(clazz, s.name);
    }

    @Override
    protected TypeToken<T> getType(Entity entity, String className) {
        return WorkflowSensor.getType(entity, className, this.lookupSensorReference((Entity)entity).name);
    }

    static <T> TypeToken<T> getType(Entity entity, String className, String sensorName) {
        return AddSensorInitializerAbstractProto.getType(entity, className, sensorName);
    }

    protected EntityValueToSet lookupSensorReference(Entity entity) {
        EntityValueToSet s = this.initParam(SENSOR);
        if (s == null) {
            s = new EntityValueToSet();
        }
        if (s.entity != null && !s.entity.equals(entity)) {
            throw new IllegalArgumentException("Not permitted to specify different entity (" + s.entity + ") for workflow-sensor on " + entity);
        }
        String t2 = this.initParam(SENSOR_TYPE);
        if (Object.class.getName().equals(t2)) {
            t2 = null;
        }
        if (s.type != null && t2 != null && !t2.equals(s.type)) {
            throw new IllegalArgumentException("Incompatible types " + s.type + " and " + t2);
        }
        if (t2 != null) {
            s.type = t2;
        }
        String n2 = (String)this.initParam(SENSOR_NAME);
        if (s.name != null && n2 != null && !n2.equals(s.name)) {
            throw new IllegalArgumentException("Incompatible names " + s.name + " and " + n2);
        }
        if (n2 != null) {
            s.name = n2;
        }
        return s;
    }

    public static class WorkflowPollCallable
    implements Callable<Object> {
        private final String workflowCallableName;
        private BrooklynObject entityOrAdjunct;
        private final Map<String, Object> params;
        private final WorkflowExecutionContext.WorkflowContextType wcType;

        protected WorkflowPollCallable(WorkflowExecutionContext.WorkflowContextType wcType, String workflowCallableName, ConfigBag params, BrooklynObject entityOrAdjunct) {
            this.wcType = wcType;
            this.workflowCallableName = workflowCallableName;
            this.params = params.getAllConfigRaw();
            this.entityOrAdjunct = entityOrAdjunct;
        }

        public void init(BrooklynObject entityOrAdjunct) {
            this.entityOrAdjunct = entityOrAdjunct;
        }

        @Override
        public Object call() throws Exception {
            BrooklynObject entityOrAdjunct = this.entityOrAdjunct;
            if (entityOrAdjunct == null) {
                entityOrAdjunct = BrooklynTaskTags.getContextEntityAdjunct(Tasks.current(), false);
            }
            if (entityOrAdjunct == null) {
                entityOrAdjunct = BrooklynTaskTags.getContextEntity(Tasks.current());
            }
            if (entityOrAdjunct == null) {
                throw new IllegalStateException("No entity adjunct or entity available for " + this);
            }
            WorkflowExecutionContext wc = WorkflowExecutionContext.newInstancePersisted(entityOrAdjunct, this.wcType, this.workflowCallableName, ConfigBag.newInstance(this.params), null, null, null);
            Task wt = (Task)wc.getTask(false).get();
            if (entityOrAdjunct instanceof EntityAdjunct) {
                BrooklynTaskTags.addTagDynamically(wt, BrooklynTaskTags.tagForContextAdjunct((EntityAdjunct)entityOrAdjunct));
            }
            if (entityOrAdjunct instanceof WorkflowPolicy) {
                ((WorkflowPolicy)entityOrAdjunct).highlightAction("Workflow running", wt);
            }
            try {
                Object result = DynamicTasks.queue(wt).getUnchecked();
                if (entityOrAdjunct instanceof WorkflowPolicy) {
                    ((WorkflowPolicy)entityOrAdjunct).highlightAction("Workflow run (success)", wt);
                }
                return result;
            }
            catch (Exception e) {
                if (entityOrAdjunct instanceof WorkflowPolicy) {
                    ((WorkflowPolicy)entityOrAdjunct).highlightAction("Workflow run, with error: " + Exceptions.collapseText((Throwable)e), wt);
                }
                throw e;
            }
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public String toString() {
            return "WorkflowPollCallable{workflowCallableName='" + this.workflowCallableName + '\'' + ", context=" + this.entityOrAdjunct + ", params=" + this.params + '}';
        }
    }
}

