/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMembershipTrackingPolicy
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMembershipTrackingPolicy.class);
    public static final ConfigKey<Set<Sensor<?>>> SENSORS_TO_TRACK = ConfigKeys.newConfigKey(new TypeToken<Set<Sensor<?>>>(){}, "sensorsToTrack", "Sensors of members to be monitored (implicitly adds service-up to this list, but that behaviour may be deleted in a subsequent release!)", ImmutableSet.of());
    public static final ConfigKey<Boolean> NOTIFY_ON_DUPLICATES = ConfigKeys.newBooleanConfigKey("notifyOnDuplicates", "Whether to notify listeners when a sensor is published with the same value as last time", false);
    public static final ConfigKey<Group> GROUP = ConfigKeys.newConfigKey(Group.class, "group");
    private ConcurrentMap<String, Map<Sensor<Object>, Object>> entitySensorCache = new ConcurrentHashMap<String, Map<Sensor<Object>, Object>>();

    protected Set<Sensor<?>> getSensorsToTrack() {
        return ImmutableSet.builder().addAll((Iterable)this.getRequiredConfig(SENSORS_TO_TRACK)).add(Attributes.SERVICE_UP).build();
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        Group group = this.getGroup();
        if (group != null) {
            if (this.uniqueTag == null) {
                this.uniqueTag = JavaClassNames.simpleClassName((Object)this) + ":" + group;
            }
            this.subscribeToGroup(group);
        } else {
            LOG.warn("Deprecated use of " + AbstractMembershipTrackingPolicy.class.getSimpleName() + "; group should be set as config");
        }
    }

    @Override
    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        if (GROUP.getName().equals(key.getName())) {
            Preconditions.checkNotNull(val, (String)"%s value must not be null", (Object)GROUP.getName());
            Preconditions.checkNotNull(val, (String)"%s value must be a group, but was %s (of type %s)", (Object)GROUP.getName(), val, val.getClass());
            if (val.equals(this.getConfig(GROUP))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No-op for reconfigure group of " + AbstractMembershipTrackingPolicy.class.getSimpleName() + "; group is still " + val);
                }
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Membership tracker " + AbstractMembershipTrackingPolicy.class + ", resubscribing to group " + val + ", previously was " + this.getGroup());
                }
                this.unsubscribeFromGroup();
                this.subscribeToGroup((Group)val);
            }
        } else {
            throw new UnsupportedOperationException("reconfiguring " + key + " unsupported for " + this);
        }
    }

    @Override
    public void suspend() {
        this.unsubscribeFromGroup();
        super.suspend();
    }

    @Override
    public void resume() {
        boolean wasSuspended = this.isSuspended();
        super.resume();
        Group group = this.getGroup();
        if (wasSuspended && group != null) {
            this.subscribeToGroup(group);
        }
    }

    protected Group getGroup() {
        return this.getConfig(GROUP);
    }

    protected void subscribeToGroup(Group group) {
        Preconditions.checkNotNull((Object)group, (Object)"The group must not be null");
        BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly((Entity)group), "Subscribing to group " + group + ", for memberAdded, memberRemoved, and {}", this.getSensorsToTrack());
        this.subscriptions().subscribe((Entity)group, DynamicGroup.MEMBER_ADDED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                AbstractMembershipTrackingPolicy.this.onEntityEvent(EventType.ENTITY_ADDED, (Entity)event.getValue());
            }
        });
        this.subscriptions().subscribe((Entity)group, DynamicGroup.MEMBER_REMOVED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                AbstractMembershipTrackingPolicy.this.entitySensorCache.remove(event.getSource().getId());
                AbstractMembershipTrackingPolicy.this.onEntityEvent(EventType.ENTITY_REMOVED, (Entity)event.getValue());
            }
        });
        for (Sensor<?> sensor : this.getSensorsToTrack()) {
            this.subscriptions().subscribeToMembers(group, sensor, new SensorEventListener<Object>(){

                public void onEvent(SensorEvent<Object> event) {
                    boolean notifyOnDuplicates = (Boolean)AbstractMembershipTrackingPolicy.this.getRequiredConfig(NOTIFY_ON_DUPLICATES);
                    String entityId = event.getSource().getId();
                    if (!notifyOnDuplicates) {
                        MutableMap newMap = MutableMap.of();
                        Map sensorCache = (Map)AbstractMembershipTrackingPolicy.this.entitySensorCache.putIfAbsent(entityId, newMap);
                        if (sensorCache == null) {
                            sensorCache = newMap;
                        }
                        boolean oldExists = sensorCache.containsKey(event.getSensor());
                        Object oldVal = sensorCache.put(event.getSensor(), event.getValue());
                        if (oldExists && Objects.equal((Object)event.getValue(), (Object)oldVal)) {
                            return;
                        }
                    }
                    AbstractMembershipTrackingPolicy.this.onEntityEvent(EventType.ENTITY_CHANGE, event.getSource());
                }
            });
        }
        this.highlightTriggers(this.getSensorsToTrack(), (Object)"group members");
        if (!this.isRebinding()) {
            for (Entity it : group.getMembers()) {
                this.onEntityEvent(EventType.ENTITY_ADDED, it);
            }
        }
    }

    protected void unsubscribeFromGroup() {
        Group group = this.getGroup();
        if (group != null) {
            this.subscriptions().unsubscribe((Entity)group);
        }
    }

    protected void defaultHighlightAction(EventType type, Entity entity) {
        this.defaultHighlightAction(type, entity, "Update on %s %s");
    }

    protected void defaultHighlightAction(EventType type, Entity entity, String formattedMessage) {
        this.highlightAction(String.format(formattedMessage, entity, Strings.removeFromStart((String)type.toString().toLowerCase(), (String)"entity_")), null);
    }

    protected void onEntityEvent(EventType type, Entity entity) {
        this.defaultHighlightAction(type, entity);
        switch (type) {
            case ENTITY_CHANGE: {
                this.onEntityChange(entity);
                break;
            }
            case ENTITY_ADDED: {
                this.onEntityAdded(entity);
                break;
            }
            case ENTITY_REMOVED: {
                this.onEntityRemoved(entity);
            }
        }
    }

    protected void onEntityChange(Entity member) {
    }

    protected void onEntityAdded(Entity member) {
    }

    protected void onEntityRemoved(Entity member) {
    }

    public static enum EventType {
        ENTITY_CHANGE,
        ENTITY_ADDED,
        ENTITY_REMOVED;

    }
}

