/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.predicates;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;
import org.apache.brooklyn.core.resolve.jackson.JsonSymbolDependentDeserializer;
import org.apache.brooklyn.core.resolve.jackson.WrappedValue;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.predicates.ResolutionFailureTreatedAsAbsent;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ValueResolver;
import org.apache.brooklyn.util.core.units.Range;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.SerializablePredicate;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.javalang.coerce.TryCoercer;
import org.apache.brooklyn.util.math.NumberMath;
import org.apache.brooklyn.util.text.NaturalOrderComparator;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.WildcardGlobs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslPredicates {
    private static final Logger LOG = LoggerFactory.getLogger(DslPredicates.class);
    static AtomicBoolean initialized = new AtomicBoolean(false);
    private static final ThreadLocal<Map<Object, Object>> PREDICATE_EVALUATION_CONTEXT;

    public static void init() {
        if (initialized.getAndSet(true)) {
            return;
        }
        TypeCoercions.registerAdapter(java.util.function.Predicate.class, DslEntityPredicate.class, DslEntityPredicateAdapter::new);
        TypeCoercions.registerAdapter(java.util.function.Predicate.class, DslPredicate.class, DslPredicateAdapter::new);
        TypeCoercions.registerAdapter(String.class, DslPredicate.class, DslPredicates::implicitlyEqualTo);
        TypeCoercions.registerAdapter("60-expression-to-predicate", new TryCoercer(){

            public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> type) {
                if (!(input instanceof DeferredSupplier)) {
                    return null;
                }
                if (!DslPredicate.class.isAssignableFrom(type.getRawType())) {
                    return null;
                }
                return Maybe.of(type.getRawType().cast(DslPredicates.implicitlyEqualTo(input)));
            }
        });
    }

    static <T> T unwrapped(WrappedValue<T> t) {
        return WrappedValue.get(t);
    }

    static Object unwrappedObject(Object t) {
        if (t instanceof WrappedValue) {
            return ((WrappedValue)t).get();
        }
        return t;
    }

    static Object undeferred(Object t) {
        if (t instanceof DeferredSupplier) {
            return ((DeferredSupplier)t).get();
        }
        return t;
    }

    public static final boolean coercedEqual(Object a, Object b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        if (a.equals(b) || b.equals(a)) {
            return true;
        }
        if (a instanceof DeferredSupplier || b instanceof DeferredSupplier) {
            return DslPredicates.coercedEqual(DslPredicates.undeferred(a), DslPredicates.undeferred(b));
        }
        if (a.getClass().isAssignableFrom(b.getClass())) {
            return false;
        }
        if (b.getClass().isAssignableFrom(a.getClass())) {
            return false;
        }
        BiFunction<Object, Object, Maybe> maybeCoercedEquals = (ma, mb) -> {
            if (ma instanceof String && mb instanceof Class) {
                if (ma.equals(((Class)mb).getName()) || ma.equals(((Class)mb).getSimpleName())) {
                    return Maybe.of((Object)true);
                }
            } else {
                if (DslPredicates.isJson(ma) && !DslPredicates.isJson(mb) || ma instanceof String && Boxing.isPrimitiveOrBoxedClass(mb.getClass())) {
                    Class clazz = mb instanceof Number ? Number.class : mb.getClass();
                    Maybe<Number> mma = TypeCoercions.tryCoerce(ma, clazz);
                    if (mma.isPresent()) {
                        return Maybe.of((Object)DslPredicates.coercedEqual(mma.get(), mb));
                    }
                    return Maybe.absent((String)("coercion not supported in equality check, to " + mb.getClass()));
                }
                if (a instanceof Number && b instanceof Number) {
                    return Maybe.of((Object)new NumberMath((Number)a).withinTolerance((Number)b));
                }
            }
            return Maybe.absent((String)"coercion not permitted for equality check with these argument types");
        };
        return (Boolean)maybeCoercedEquals.apply(a, b).orMaybe(() -> (Maybe)maybeCoercedEquals.apply(b, a)).or((Object)false);
    }

    @Beta
    public static final Integer coercedCompare(Object a, Object b) {
        if (a == null || b == null) {
            return 0;
        }
        if (a.equals(b) || b.equals(a)) {
            return 0;
        }
        if (a instanceof Number || b instanceof Number) {
            try {
                if (a instanceof String) {
                    a = new BigDecimal((String)a);
                }
                if (b instanceof String) {
                    b = new BigDecimal((String)b);
                }
                if (a instanceof Number && b instanceof Number) {
                    if (a.getClass().equals(b.getClass())) {
                        if (a instanceof BigDecimal) {
                            return ((BigDecimal)a).compareTo((BigDecimal)b);
                        }
                        if (a instanceof BigInteger) {
                            return ((BigInteger)a).compareTo((BigInteger)b);
                        }
                        if (a instanceof Long) {
                            return ((Long)a).compareTo((Long)b);
                        }
                        if (a instanceof Integer) {
                            return ((Integer)a).compareTo((Integer)b);
                        }
                        return Double.valueOf(((Number)a).doubleValue()).compareTo(((Number)b).doubleValue());
                    }
                    if (a instanceof Integer || a instanceof Long || a instanceof Byte) {
                        a = BigDecimal.valueOf(((Number)a).longValue());
                    }
                    if (b instanceof Integer || b instanceof Long || a instanceof Byte) {
                        b = BigDecimal.valueOf(((Number)b).longValue());
                    }
                    if (a instanceof Double || a instanceof Float) {
                        a = BigDecimal.valueOf(((Number)a).doubleValue());
                    }
                    if (b instanceof Double || b instanceof Float) {
                        b = BigDecimal.valueOf(((Number)b).doubleValue());
                    }
                    if (a instanceof BigDecimal && b instanceof BigDecimal) {
                        return ((BigDecimal)a).compareTo((BigDecimal)b);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DslPredicates.isStringOrPrimitiveOrNumber(a) && DslPredicates.isStringOrPrimitiveOrNumber(b)) {
            return NaturalOrderComparator.INSTANCE.compare(DslPredicates.toStringForPrimitives(a), DslPredicates.toStringForPrimitives(b));
        }
        if (a instanceof DeferredSupplier || b instanceof DeferredSupplier) {
            return DslPredicates.coercedCompare(DslPredicates.undeferred(a), DslPredicates.undeferred(b));
        }
        if (a.getClass().isAssignableFrom(b.getClass()) && b instanceof Comparable) {
            return -((Comparable)b).compareTo(a);
        }
        if (b.getClass().isAssignableFrom(a.getClass()) && a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        BiFunction<Maybe, Maybe, Integer> maybeCoercedCompare = (ma, mb) -> {
            if (ma.isPresent() && mb.isPresent()) {
                return DslPredicates.coercedCompare(ma.get(), mb.get());
            }
            return null;
        };
        if (DslPredicates.isJson(a) && !DslPredicates.isJson(b)) {
            return maybeCoercedCompare.apply(TypeCoercions.tryCoerce(a, b.getClass()), Maybe.of((Object)b));
        }
        if (DslPredicates.isJson(b) && !DslPredicates.isJson(a)) {
            return maybeCoercedCompare.apply(Maybe.of((Object)a), TypeCoercions.tryCoerce(b, a.getClass()));
        }
        return null;
    }

    public static final boolean coercedCompare(Object a, Object b, Function<Integer, Boolean> postProcess) {
        Integer result = DslPredicates.coercedCompare(a, b);
        if (result == null) {
            return false;
        }
        return postProcess.apply(result);
    }

    private static boolean isStringOrPrimitive(Object a) {
        return a != null && (a instanceof String || Boxing.isPrimitiveOrBoxedClass(a.getClass()));
    }

    private static boolean isStringOrPrimitiveOrNumber(Object a) {
        return DslPredicates.isStringOrPrimitive(a) || a != null && a instanceof Number;
    }

    private static boolean isJson(Object a) {
        return DslPredicates.isStringOrPrimitive(a) || a instanceof Map || a instanceof Collection;
    }

    static String toStringForPrimitives(Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof Number) {
            if (a instanceof BigDecimal) {
                return ((BigDecimal)a).toPlainString();
            }
            if (a instanceof Double) {
                return DslPredicates.toStringForPrimitives(new BigDecimal((Double)a));
            }
            if (a instanceof Float) {
                return DslPredicates.toStringForPrimitives(new BigDecimal(((Float)a).floatValue()));
            }
        }
        return a.toString();
    }

    static boolean asStringTestOrFalse(Object value, java.util.function.Predicate<String> test) {
        return DslPredicates.isStringOrPrimitiveOrNumber(value) || value instanceof Throwable ? test.test(DslPredicates.toStringForPrimitives(value)) : (value instanceof Class ? test.test(((Class)value).getName()) : false);
    }

    public static Object getFromPredicateEvaluationContext(Object key) {
        Map<Object, Object> map = PREDICATE_EVALUATION_CONTEXT.get();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean evaluateDslPredicateWithContext(DslPredicate<T> predicate, T target, Map<Object, Object> context) {
        if (PREDICATE_EVALUATION_CONTEXT.get() != null) {
            throw new IllegalStateException("Nested predicate evaluation with context not supported");
        }
        try {
            PREDICATE_EVALUATION_CONTEXT.set(context);
            boolean bl = predicate.apply(target);
            return bl;
        }
        finally {
            PREDICATE_EVALUATION_CONTEXT.remove();
        }
    }

    public static <T> boolean evaluateDslPredicateWithBrooklynObjectContext(DslPredicate<T> predicate, T target, BrooklynObject bo) {
        return DslPredicates.evaluateDslPredicateWithContext(predicate, target, (Map<Object, Object>)MutableMap.of(Configurable.class, (Object)bo, BrooklynObject.class, (Object)bo, Entity.class, (Object)EntityAdjuncts.getEntity(bo, true).orNull()));
    }

    public static DslPredicate alwaysFalse() {
        DslEntityPredicateDefault result = new DslEntityPredicateDefault();
        result.when = WhenPresencePredicate.NEVER;
        return result;
    }

    public static DslPredicate alwaysTrue() {
        DslEntityPredicateDefault result = new DslEntityPredicateDefault();
        result.when = WhenPresencePredicate.ALWAYS;
        return result;
    }

    public static DslPredicate equalTo(Object x) {
        DslEntityPredicateDefault result = new DslEntityPredicateDefault();
        result.equals = WrappedValue.of(x);
        return result;
    }

    public static DslPredicate implicitlyEqualTo(Object x) {
        DslEntityPredicateDefault result = new DslEntityPredicateDefault();
        result.implicitEquals = WrappedValue.of(x);
        return result;
    }

    public static DslPredicate instanceOf(Object x) {
        DslEntityPredicateDefault result = new DslEntityPredicateDefault();
        result.javaInstanceOf = x instanceof DslPredicate ? (DslPredicate)x : DslPredicates.implicitlyEqualTo(x);
        return result;
    }

    static {
        DslPredicates.init();
        PREDICATE_EVALUATION_CONTEXT = new ThreadLocal();
    }

    public static class PredicateAssertionFailedException
    extends UserFacingException {
        public PredicateAssertionFailedException(String msg) {
            super(msg);
        }

        public PredicateAssertionFailedException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    static class RetargettedPredicateEvaluation<T>
    extends DslPredicateDefault<T> {
        RetargettedPredicateEvaluation() {
        }
    }

    public static class DslEntityPredicateAdapter
    implements DslEntityPredicate {
        java.util.function.Predicate predicate;

        public DslEntityPredicateAdapter(java.util.function.Predicate predicate) {
            this.predicate = predicate;
        }

        public boolean apply(@Nullable Entity t) {
            return this.predicate.test(t);
        }

        public static DslEntityPredicate of(java.util.function.Predicate<? super Entity> p) {
            if (p instanceof DslEntityPredicate) {
                return (DslEntityPredicate)((Object)p);
            }
            return new DslEntityPredicateAdapter(p);
        }
    }

    public static class DslPredicateAdapter
    implements DslPredicate {
        java.util.function.Predicate predicate;

        public DslPredicateAdapter(java.util.function.Predicate predicate) {
            this.predicate = predicate;
        }

        public boolean apply(@Nullable Object t) {
            return this.predicate.test(t);
        }

        public static DslPredicate of(java.util.function.Predicate<?> p) {
            if (p instanceof DslPredicate) {
                return (DslPredicate)((Object)p);
            }
            return new DslPredicateAdapter(p);
        }
    }

    @Beta
    public static class DslPredicateJsonDeserializer
    extends JsonSymbolDependentDeserializer {
        public static final Set<Class> DSL_REGISTERED_CLASSES = ImmutableSet.of(java.util.function.Predicate.class, com.google.common.base.Predicate.class, DslPredicate.class, DslEntityPredicate.class);
        public static final Set<Class> DSL_RESTRICTED_CLASSES = ImmutableSet.of(java.util.function.Predicate.class, com.google.common.base.Predicate.class);

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            return super.createContextual(ctxt, property);
        }

        @Override
        protected boolean isTypeReplaceableByDefault() {
            if (this.type != null && DSL_RESTRICTED_CLASSES.contains(this.type.getRawClass())) {
                return false;
            }
            return super.isTypeReplaceableByDefault();
        }

        @Override
        public JavaType getDefaultType() {
            return this.ctxt.constructType(DslPredicateDefault.class);
        }

        @Override
        protected Object deserializeObject(JsonParser p0) throws IOException {
            MutableList errors = MutableList.of();
            TokenBuffer pb = BrooklynJacksonSerializationUtils.createBufferForParserCurrentObject(p0, this.ctxt);
            try {
                JsonDeserializer deser;
                Object raw = null;
                if (DSL_REGISTERED_CLASSES.contains(this.type.getRawClass())) {
                    deser = this.ctxt.findRootValueDeserializer(this.ctxt.constructType(Object.class));
                    raw = deser.deserialize(pb.asParserOnFirstToken(), this.ctxt);
                }
                if (raw instanceof Map) {
                    if (((Map)raw).containsKey("type")) {
                        raw = null;
                    } else {
                        deser = this.ctxt.findRootValueDeserializer(this.ctxt.constructType(DslEntityPredicateDefault.class));
                        raw = deser.deserialize(pb.asParserOnFirstToken(), this.ctxt);
                    }
                }
                if (this.type.getRawClass().isInstance(raw)) {
                    return raw;
                }
                if (raw instanceof java.util.function.Predicate || raw instanceof java.util.function.Predicate) {
                    return TypeCoercions.coerce(raw, this.type.getRawClass());
                }
                if (raw != null) {
                    errors.add((Object)new IllegalArgumentException("Cannot parse '" + raw + "' as a " + this.type));
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                errors.add((Object)e);
            }
            try {
                return super.deserializeObject(BrooklynJacksonSerializationUtils.createParserFromTokenBufferAndParser(pb, p0));
            }
            catch (Exception e) {
                errors.add((Object)e);
                throw Exceptions.propagate((String)("Unable to read " + DslPredicate.class), (Iterable)errors);
            }
        }
    }

    @Beta
    public static class DslEntityPredicateDefault
    extends DslPredicateDefault<Entity>
    implements DslEntityPredicate {
        public DslEntityPredicateDefault() {
        }

        public DslEntityPredicateDefault(String implicitEquals) {
            super(implicitEquals);
        }
    }

    @Beta
    public static class DslPredicateDefault<T2>
    extends DslPredicateBase<T2>
    implements DslPredicate<T2>,
    Cloneable {
        public Object metadata;
        public Object target;
        public String config;
        public String sensor;
        public DslPredicate tag;

        public DslPredicateDefault() {
        }

        public DslPredicateDefault(String implicitEquals) {
            this.implicitEquals = WrappedValue.of(implicitEquals);
        }

        public DslPredicateDefault(Integer implicitEquals) {
            this.implicitEquals = WrappedValue.of(implicitEquals);
        }

        public DslPredicateDefault(Double implicitEquals) {
            this.implicitEquals = WrappedValue.of(implicitEquals);
        }

        public DslPredicateDefault(Long implicitEquals) {
            this.implicitEquals = WrappedValue.of(implicitEquals);
        }

        public DslPredicateDefault(Number implicitEquals) {
            this.implicitEquals = WrappedValue.of(implicitEquals);
        }

        protected DslPredicateDefault<T2> clone() {
            try {
                return (DslPredicateDefault)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        protected <T> T getTypeFromValueOrContext(Class<?> type, Object value) {
            if (type == null || value == null) {
                return (T)value;
            }
            if (Entity.class.isAssignableFrom(type) && value instanceof BrooklynObject) {
                value = EntityAdjuncts.getEntity((BrooklynObject)value, true).orNull();
            }
            if (type.isInstance(value)) {
                return (T)value;
            }
            Object v2 = DslPredicates.getFromPredicateEvaluationContext(Entity.class);
            if (type.isInstance(v2)) {
                return (T)v2;
            }
            if (v2 != null) {
                throw new IllegalStateException("DSL predicate context for " + type + " is incompatible " + v2 + " (" + v2.getClass() + ")");
            }
            return null;
        }

        @Override
        protected void collectApplicableSpecialFieldTargetResolvers(Map<String, Function<Object, Maybe<Object>>> resolvers) {
            super.collectApplicableSpecialFieldTargetResolvers(resolvers);
            if (this.config != null) {
                resolvers.put("config", value -> {
                    Configurable cv = value instanceof Configurable ? (Configurable)value : (Configurable)DslPredicates.getFromPredicateEvaluationContext(Configurable.class);
                    if (cv != null) {
                        Maybe<Object> result;
                        if (cv.config().findKeysDeclared(k -> this.config.equals(k.getName())).isEmpty()) {
                            return Maybe.absent((String)("No config '" + this.config + "' on " + cv));
                        }
                        ValueResolver<Object> resolver = Tasks.resolving(() -> cv.config().get(ConfigKeys.newConfigKey(Object.class, this.config))).as(Object.class).allowDeepResolution(true).immediately(true);
                        Entity entity = (Entity)this.getTypeFromValueOrContext(Entity.class, value);
                        if (entity != null) {
                            resolver.context(entity);
                        }
                        if ((result = resolver.getMaybe()).isAbsent() && entity == null && BrooklynTaskTags.getContextEntity(Tasks.current()) == null) {
                            throw new IllegalStateException("Unable to resolve config '" + this.config + "' on " + value + ", likely because outside of an entity task unless entity target or context explicitly supplied");
                        }
                        return result;
                    }
                    return Maybe.absent((String)("Config not supported on " + value + " and no applicable DslPredicate context (testing config '" + this.config + "')"));
                });
            }
            if (this.sensor != null) {
                resolvers.put("sensor", value -> {
                    Entity entity = (Entity)this.getTypeFromValueOrContext(Entity.class, value);
                    if (entity != null) {
                        if (!entity.sensors().getAll().keySet().stream().anyMatch(s -> this.sensor.equals(s.getName()))) {
                            return Maybe.absent((String)("No sensor '" + this.sensor + "' on " + entity));
                        }
                        ValueResolver<Object> resolver = Tasks.resolving(() -> entity.sensors().get(Sensors.newSensor(Object.class, this.sensor))).as(Object.class).allowDeepResolution(true).immediately(true).context(entity);
                        return resolver.getMaybe();
                    }
                    return Maybe.absent((String)("Sensors not supported on " + value + " and no applicable DslPredicate context (testing sensor '" + this.sensor + "')"));
                });
            }
        }

        @Override
        protected Maybe<Object> resolveTargetAgainstInput(Object input) {
            Maybe result;
            Object target = this.target;
            if (target instanceof String) {
                result = Maybe.of((Object)this.resolveTargetStringAgainstInput((String)target, input).get());
                if (result.isPresent() && result.get() instanceof RetargettedPredicateEvaluation) {
                    return result;
                }
            } else {
                if (target == null) {
                    target = input;
                }
                ValueResolver<Object> resolver = Tasks.resolving(target).as(Object.class).allowDeepResolution(true).immediately(true);
                Entity entity = (Entity)this.getTypeFromValueOrContext(Entity.class, input);
                if (entity != null) {
                    resolver = resolver.context(entity);
                }
                try {
                    result = resolver.getMaybe();
                }
                catch (Throwable t) {
                    if (Exceptions.getCausalChain((Throwable)t).stream().anyMatch(ti -> ti instanceof ResolutionFailureTreatedAsAbsent)) {
                        result = Maybe.absent((Throwable)t);
                    }
                    throw Exceptions.propagate((Throwable)t);
                }
            }
            result = result.isPresent() ? super.resolveTargetAgainstInput(result.get()) : result;
            return result;
        }

        protected Maybe<Object> resolveTargetStringAgainstInput(String target, Object input) {
            Maybe<Object> candidate = this.resolvePluralNormallyOrSingularAsHasElementRetargettedPredicate(target, input, "locations", Entity.class, x -> Maybe.of(Locations.getLocationsCheckingAncestors(null, (Entity)x)), "location", x -> x instanceof Location);
            if (candidate != null) {
                return candidate;
            }
            candidate = this.resolvePluralNormallyOrSingularAsHasElementRetargettedPredicate(target, input, "tags", BrooklynObject.class, x -> Maybe.of((Object)((BrooklynObject)x).tags().getTags()), "tag", x -> false);
            if (candidate != null) {
                return candidate;
            }
            candidate = this.resolvePluralNormallyOrSingularAsHasElementRetargettedPredicate(target, input, "children", Entity.class, x -> Maybe.of((Object)((Entity)x).getChildren()), "child", x -> false);
            if (candidate != null) {
                return candidate;
            }
            return Maybe.absent((String)("Unsupported target '" + target + "' on input " + input));
        }

        protected <T> Maybe<Object> resolveAsHasElementRetargettedPredicate(String target, Object inputValue, java.util.function.Predicate<Object> checkPredicateRetargettingNotNeeded, Class<T> suitableTargetType, Function<Object, Maybe<Object>> retargetValue) {
            if (inputValue == null || checkPredicateRetargettingNotNeeded.test(inputValue)) {
                return Maybe.of((Object)inputValue);
            }
            if (this.hasElement != null) {
                return retargetValue.apply(inputValue);
            }
            T retargettableTarget = this.getTypeFromValueOrContext(suitableTargetType, inputValue);
            if (retargettableTarget == null) {
                return Maybe.absent((String)("Target " + target + " not applicable to " + inputValue));
            }
            RetargettedPredicateEvaluation retargetPredicate = new RetargettedPredicateEvaluation();
            retargetPredicate.target = target;
            retargetPredicate.hasElement = this.clone();
            ((DslPredicateDefault)retargetPredicate.hasElement).target = null;
            return Maybe.of(retargetPredicate);
        }

        protected <T> Maybe<Object> resolvePluralNormallyOrSingularAsHasElementRetargettedPredicate(String target, Object inputValue, String plural, Class<T> suitableTargetType, Function<Object, Maybe<Object>> retargetValue, String singular, java.util.function.Predicate<Object> checkSingularTargetPredicateRetargettingNotNeeded) {
            if (plural.equals(target)) {
                T retargettableTarget = this.getTypeFromValueOrContext(suitableTargetType, inputValue);
                if (retargettableTarget == null) {
                    return Maybe.absent((String)("Target " + target + " not applicable to " + inputValue));
                }
                return retargetValue.apply(retargettableTarget);
            }
            if (singular.equals(target)) {
                return this.resolveAsHasElementRetargettedPredicate(target, inputValue, checkSingularTargetPredicateRetargettingNotNeeded, suitableTargetType, retargetValue);
            }
            return null;
        }

        @Override
        public void applyToResolved(Maybe<Object> result, DslPredicateBase.CheckCounts checker) {
            super.applyToResolved(result, checker);
            checker.check(this.tag, result, this::checkTag);
        }

        @Override
        protected void handleNoChecks(Maybe<Object> result, DslPredicateBase.CheckCounts checker) {
            if (this.target != null || this.config != null || this.sensor != null) {
                this.checkWhen(WhenPresencePredicate.PRESENT_NON_NULL, result, checker);
                return;
            }
            super.handleNoChecks(result, checker);
        }

        public boolean checkTag(DslPredicate tagCheck, Object value) {
            if (value instanceof BrooklynObject) {
                return ((BrooklynObject)value).tags().getTags().stream().anyMatch(this.tag);
            }
            return false;
        }
    }

    @JsonDeserialize(using=DslPredicateJsonDeserializer.class)
    public static interface DslEntityPredicate
    extends DslPredicate<Entity> {
        default public boolean applyInEntityScope(Entity entity) {
            return (Boolean)((EntityInternal)entity).getExecutionContext().get(Tasks.create("Evaluating predicate " + this, () -> this.apply(entity)));
        }
    }

    @JsonDeserialize(using=DslPredicateJsonDeserializer.class)
    public static interface DslPredicate<T4>
    extends SerializablePredicate<T4> {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DslPredicateBase<T> {
        public WrappedValue<Object> implicitEquals;
        public WrappedValue<Object> equals;
        public WrappedValue<String> regex;
        public WrappedValue<String> glob;
        public WrappedValue<DslPredicate> check;
        public WrappedValue<DslPredicate> not;
        public List<WrappedValue<DslPredicate>> any;
        public List<WrappedValue<DslPredicate>> all;
        @JsonProperty(value="assert")
        public DslPredicate assertCondition;
        @JsonProperty(value="has-element")
        public DslPredicate hasElement;
        public DslPredicate size;
        public DslPredicate filter;
        public Object key;
        public Integer index;
        public String jsonpath;
        public WhenPresencePredicate when;
        @JsonProperty(value="in-range")
        public Range inRange;
        @JsonProperty(value="less-than")
        public Object lessThan;
        @JsonProperty(value="greater-than")
        public Object greaterThan;
        @JsonProperty(value="less-than-or-equal-to")
        public Object lessThanOrEqualTo;
        @JsonProperty(value="greater-than-or-equal-to")
        public Object greaterThanOrEqualTo;
        @JsonProperty(value="java-instance-of")
        public DslPredicate javaInstanceOf;
        @JsonProperty(value="error-cause")
        public DslPredicate errorCause;
        @JsonProperty(value="error-field")
        public String errorField;

        public Object implicitEqualsUnwrapped() {
            return DslPredicates.unwrapped(this.implicitEquals);
        }

        public boolean apply(T input) {
            Maybe<Object> result = this.resolveTargetAgainstInput(input);
            if (result.isPresent() && result.get() instanceof RetargettedPredicateEvaluation) {
                return ((RetargettedPredicateEvaluation)result.get()).apply(input);
            }
            return this.applyToResolved(result);
        }

        protected void collectApplicableSpecialFieldTargetResolvers(Map<String, Function<Object, Maybe<Object>>> resolvers) {
            if (this.key != null) {
                resolvers.put("key", value -> {
                    if (value instanceof Map) {
                        if (((Map)value).containsKey(this.key)) {
                            return Maybe.ofAllowingNull(((Map)value).get(this.key));
                        }
                        return Maybe.absent((String)("Cannot find indicated key '" + this.key + "' in map"));
                    }
                    return Maybe.absent((String)("Cannot evaluate key on non-map target " + this.classOf(value)));
                });
            }
            if (this.index != null) {
                resolvers.put("index", value -> {
                    Integer i = this.index;
                    Set v0 = value;
                    if (value instanceof Map) {
                        value = ((Map)((Object)value)).entrySet();
                    }
                    if (value instanceof Iterable) {
                        int size = Iterables.size((Iterable)value);
                        if (i < 0) {
                            i = size + i;
                        }
                        if (i < 0 || i >= size) {
                            return Maybe.absent((String)("No element at index " + i + " (" + this.classOf(v0) + " size " + size + ")"));
                        }
                        return Maybe.of((Object)Iterables.get((Iterable)value, (int)i));
                    }
                    return Maybe.absent((String)("Cannot evaluate index on non-list target " + this.classOf(v0)));
                });
            }
            if (this.filter != null) {
                resolvers.put("filter", value -> {
                    if (value instanceof Map) {
                        value = ((Map)((Object)value)).entrySet();
                    }
                    if (value instanceof Iterable) {
                        return Maybe.of((Object)Iterables.filter((Iterable)value, (com.google.common.base.Predicate)this.filter));
                    }
                    return Maybe.absent((String)("Cannot evaluate filter on non-list target " + this.classOf(value)));
                });
            }
            if (this.jsonpath != null) {
                resolvers.put("jsonpath", value -> {
                    Object result;
                    String json;
                    Entity entity = BrooklynTaskTags.getContextEntity(Tasks.current());
                    try {
                        json = BeanWithTypeUtils.newMapper(entity != null ? ((EntityInternal)entity).getManagementContext() : null, false, null, false).writeValueAsString(value);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Unable to consider jsonpath for non-serializable '" + value + "' due to: " + e, (Throwable)e);
                        }
                        return Maybe.absent((String)("Cannot serialize object as JSON: " + e));
                    }
                    String jsonpathTidied = this.jsonpath;
                    if (jsonpathTidied != null && !jsonpathTidied.startsWith("$")) {
                        jsonpathTidied = jsonpathTidied.startsWith("@") || jsonpathTidied.startsWith(".") || jsonpathTidied.startsWith("[") ? '$' + jsonpathTidied : "$." + jsonpathTidied;
                    }
                    try {
                        result = JsonPath.read((String)json, (String)jsonpathTidied, (Predicate[])new Predicate[0]);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Unable to evaluate jsonpath '" + jsonpathTidied + "' for '" + value + "' due to: " + e, (Throwable)e);
                        }
                        return Maybe.absent((String)"No jsonpath matches");
                    }
                    return Maybe.ofAllowingNull((Object)result);
                });
            }
            if (this.errorField != null) {
                resolvers.put("error-field", value -> {
                    if (!(value instanceof Throwable)) {
                        return Maybe.absent((String)("Unable to apply error-field to non-throwable " + value));
                    }
                    Throwable t = (Throwable)value;
                    Maybe m = Reflections.getMethodFromArgs((Object)value, (String)("get" + Strings.toInitialCapOnly((String)this.errorField)), (List)MutableList.of());
                    if (m.isPresent()) {
                        return m.map(mm -> {
                            try {
                                return mm.invoke((Object)t, new Object[0]);
                            }
                            catch (Exception e) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                        });
                    }
                    Maybe v = Reflections.getFieldValueMaybe((Object)value, (String)this.errorField);
                    if (v.isPresent()) {
                        return v;
                    }
                    return Maybe.absent((String)("No such field or getter for '" + this.errorField + "'"));
                });
            }
            if (this.errorCause != null) {
                resolvers.put("error-cause", value -> {
                    if (!(value instanceof Throwable)) {
                        return Maybe.absent((String)("Unable to apply error-field to non-throwable " + value));
                    }
                    return Maybe.cast(this.findErrorCause(this.errorCause, value));
                });
            }
        }

        private String classOf(Object x) {
            if (x == null) {
                return "null";
            }
            return x.getClass().getName();
        }

        protected Maybe<Object> resolveTargetAgainstInput(Object input) {
            MutableMap specialResolvers = MutableMap.of();
            this.collectApplicableSpecialFieldTargetResolvers((Map<String, Function<Object, Maybe<Object>>>)specialResolvers);
            if (!specialResolvers.isEmpty()) {
                if (specialResolvers.size() > 1) {
                    throw new IllegalStateException("Predicate has multiple incompatible target specifiers: " + specialResolvers.keySet());
                }
                return (Maybe)((Function)specialResolvers.values().iterator().next()).apply(input);
            }
            return Maybe.ofAllowingNull((Object)input);
        }

        public boolean applyToResolved(Maybe<Object> result) {
            CheckCounts counts = new CheckCounts();
            this.applyToResolved(result, counts);
            if (counts.checksDefined == 0) {
                this.handleNoChecks(result, counts);
            }
            return counts.allPassed(true);
        }

        protected void handleNoChecks(Maybe<Object> result, CheckCounts checker) {
            if (this.errorCause != null) {
                this.checkWhen(WhenPresencePredicate.PRESENT_NON_NULL, result, checker);
                return;
            }
            if (checker.checksDefined == 0) {
                throw new IllegalStateException("Predicate does not define any checks; if always true or always false is desired, use 'when'");
            }
        }

        public void applyToResolved(Maybe<Object> result, CheckCounts checker) {
            if (this.assertCondition != null) {
                this.failOnAssertCondition(result, checker);
            }
            checker.check(this.implicitEquals, result, (implicitTestSpec, value) -> {
                Object test = DslPredicates.unwrapped(implicitTestSpec);
                if (test instanceof DslPredicate) {
                    return this.nestedPredicateCheck((DslPredicate)test, result);
                }
                if (!(test instanceof BrooklynObject) && value instanceof BrooklynObject || !(test instanceof Iterable) && value instanceof Iterable) {
                    throw new IllegalStateException("Implicit value used for equality check comparing " + test + " with " + value + ", which is probably not what was meant. Use explicit 'equals: ...' syntax for this case.");
                }
                return DslPredicates.coercedEqual(implicitTestSpec, value);
            });
            checker.check(this.equals, result, DslPredicates::coercedEqual);
            checker.check(this.regex, result, (test, value) -> DslPredicates.asStringTestOrFalse(value, v -> Pattern.compile((String)DslPredicates.unwrapped(test), 32).matcher((CharSequence)v).matches()));
            checker.check(this.glob, result, (test, value) -> DslPredicates.asStringTestOrFalse(value, v -> WildcardGlobs.isGlobMatched((String)((String)DslPredicates.unwrapped(test)), (String)v)));
            checker.check(this.inRange, result, (test, value) -> DslPredicates.asStringTestOrFalse(value, v -> NaturalOrderComparator.INSTANCE.compare("" + test.min(), v) <= 0 && NaturalOrderComparator.INSTANCE.compare("" + test.max(), v) >= 0));
            checker.check(this.lessThan, result, (test, value) -> DslPredicates.coercedCompare(value, test, x -> x < 0));
            checker.check(this.lessThanOrEqualTo, result, (test, value) -> DslPredicates.coercedCompare(value, test, x -> x <= 0));
            checker.check(this.greaterThan, result, (test, value) -> DslPredicates.coercedCompare(value, test, x -> x > 0));
            checker.check(this.greaterThanOrEqualTo, result, (test, value) -> DslPredicates.coercedCompare(value, test, x -> x >= 0));
            this.checkWhen(this.when, result, checker);
            checker.check(this.hasElement, result, (test, value) -> {
                if (value instanceof Map) {
                    value = ((Map)((Object)value)).entrySet();
                }
                if (value instanceof Iterable) {
                    for (Object v : (Iterable)value) {
                        if (!test.apply(v)) continue;
                        return true;
                    }
                }
                return false;
            });
            checker.check(this.size, result, (test, value) -> {
                Integer computedSize = null;
                if (value instanceof CharSequence) {
                    computedSize = ((CharSequence)value).length();
                } else if (value instanceof Map) {
                    computedSize = ((Map)value).size();
                } else if (value instanceof Iterable) {
                    computedSize = Iterables.size((Iterable)((Iterable)value));
                } else {
                    return this.nestedPredicateCheck((DslPredicate)test, (Maybe<Object>)Maybe.absent((String)"size not applicable"));
                }
                return this.nestedPredicateCheck((DslPredicate)test, (Maybe<Object>)Maybe.of((Object)computedSize));
            });
            checker.checkTest(this.not, test -> !this.nestedPredicateCheck((DslPredicate)DslPredicates.unwrapped(test), result));
            checker.checkTest(this.check, test -> this.nestedPredicateCheck((DslPredicate)DslPredicates.unwrapped(test), result));
            checker.checkTest(this.any, test -> test.stream().anyMatch(p -> this.nestedPredicateCheck((DslPredicate)DslPredicates.unwrapped(p), result)));
            checker.checkTest(this.all, test -> test.stream().allMatch(p -> this.nestedPredicateCheck((DslPredicate)DslPredicates.unwrapped(p), result)));
            checker.check(this.javaInstanceOf, result, this::checkJavaInstanceOf);
        }

        protected void failOnAssertCondition(Maybe<Object> result, CheckCounts callerChecker) {
            boolean assertionPassed;
            ++callerChecker.checksDefined;
            ++callerChecker.checksApplicable;
            if (this.assertCondition instanceof DslPredicateBase) {
                Object implicitWhen = ((DslPredicateBase)((Object)this.assertCondition)).implicitEqualsUnwrapped();
                if (implicitWhen != null) {
                    CheckCounts checker = new CheckCounts();
                    WhenPresencePredicate whenT = TypeCoercions.coerce(implicitWhen, WhenPresencePredicate.class);
                    this.checkWhen(whenT, result, checker);
                    assertionPassed = checker.allPassed(true);
                } else if (result.isAbsent()) {
                    assertionPassed = false;
                } else {
                    assertionPassed = ((DslPredicateBase)((Object)this.assertCondition)).apply(result.get());
                    if (!assertionPassed) {
                        result = ((DslPredicateBase)((Object)this.assertCondition)).resolveTargetAgainstInput(result.get());
                    }
                }
            } else {
                boolean bl = assertionPassed = result.isPresent() && this.assertCondition.apply(result.get());
            }
            if (!assertionPassed) {
                String msg = "Assertion in DSL predicate failed";
                if (result.isAbsent()) {
                    String msg2 = "value cannot be resolved";
                    RuntimeException e = Maybe.Absent.getException(result);
                    if (e == null) {
                        throw new PredicateAssertionFailedException(msg + ": " + msg2 + " (no further details)");
                    }
                    throw new PredicateAssertionFailedException(msg + ": " + msg2 + ": " + Exceptions.collapseText((Throwable)e), e);
                }
                throw new PredicateAssertionFailedException(msg + ": value '" + result.get() + "'");
            }
            ++callerChecker.checksPassed;
        }

        protected void checkWhen(WhenPresencePredicate when, Maybe<Object> result, CheckCounts checker) {
            checker.checkTest(when, test -> {
                switch (test) {
                    case PRESENT: {
                        return result.isPresent();
                    }
                    case PRESENT_NON_NULL: {
                        return result.isPresentAndNonNull();
                    }
                    case ABSENT: {
                        return result.isAbsent();
                    }
                    case ABSENT_OR_NULL: {
                        return result.isAbsentOrNull();
                    }
                    case ALWAYS: {
                        return true;
                    }
                    case NEVER: {
                        return false;
                    }
                    case FALSY: {
                        return result.isAbsent() || !JavaGroovyEquivalents.groovyTruth((Object)result.get());
                    }
                    case TRUTHY: {
                        return result.isPresentAndNonNull() && JavaGroovyEquivalents.groovyTruth((Object)result.get());
                    }
                }
                return false;
            });
        }

        protected boolean checkJavaInstanceOf(DslPredicate javaInstanceOf, Object value) {
            Object implicitRegisteredType;
            if (value == null) {
                return false;
            }
            if (javaInstanceOf instanceof DslPredicateBase && (implicitRegisteredType = ((DslPredicateBase)((Object)javaInstanceOf)).implicitEqualsUnwrapped()) instanceof String) {
                Maybe<TypeToken<?>> tm;
                Entity ent = null;
                if (value instanceof Entity) {
                    ent = (Entity)value;
                }
                if (ent == null) {
                    ent = BrooklynTaskTags.getContextEntity(Tasks.current());
                }
                if (ent != null && (tm = new BrooklynTypeNameResolution.BrooklynTypeNameResolver("predicate", CatalogUtils.getClassLoadingContext(ent), true, true).findTypeToken((String)implicitRegisteredType)).isPresent()) {
                    return ((TypeToken)tm.get()).getRawType().isInstance(value);
                }
            }
            MutableSet visited = MutableSet.of();
            MutableSet toVisit = MutableSet.of(value.getClass());
            while (!toVisit.isEmpty()) {
                MutableList visitingNow = MutableList.copyOf((Iterable)toVisit);
                toVisit.clear();
                for (Class v : visitingNow) {
                    if (v == null || !visited.add(v)) continue;
                    if (this.nestedPredicateCheck(javaInstanceOf, (Maybe<Object>)Maybe.of((Object)v))) {
                        return true;
                    }
                    toVisit.add(v.getSuperclass());
                    toVisit.addAll(Arrays.asList(v.getInterfaces()));
                }
            }
            return false;
        }

        protected Maybe<Throwable> findErrorCause(DslPredicate errorCause, Object value) {
            if (value == null || !(value instanceof Throwable)) {
                return Maybe.absent((String)("Cannot look for causes of non-throwable " + value));
            }
            MutableSet visited = MutableSet.of();
            MutableSet toVisit = MutableSet.of((Object)((Throwable)value));
            while (!toVisit.isEmpty()) {
                MutableList visitingNow = MutableList.copyOf((Iterable)toVisit);
                toVisit.clear();
                for (Throwable v : visitingNow) {
                    if (v == null || !visited.add(v)) continue;
                    if (this.nestedPredicateCheck(errorCause, (Maybe<Object>)Maybe.of((Object)v))) {
                        return Maybe.of((Object)v);
                    }
                    toVisit.add(v.getCause());
                }
            }
            return Maybe.absent((String)"Nothing in causal chain matches test");
        }

        protected boolean nestedPredicateCheck(DslPredicate p, Maybe<Object> result) {
            return result.isPresent() ? p.apply(result.get()) : (p instanceof DslPredicateBase ? ((DslPredicateBase)((Object)p)).applyToResolved(result) : false);
        }

        public static class CheckCounts {
            int checksDefined = 0;
            int checksApplicable = 0;
            int checksPassed = 0;

            public <T> void checkTest(T testFieldValue, java.util.function.Predicate<T> predicateForTest) {
                if (testFieldValue != null) {
                    ++this.checksDefined;
                    ++this.checksApplicable;
                    if (predicateForTest.test(testFieldValue)) {
                        ++this.checksPassed;
                    }
                }
            }

            public <T> void check(T testFieldValue, Maybe<Object> value, BiPredicate<T, Object> check) {
                if (value.isPresent()) {
                    this.checkTest(testFieldValue, t -> check.test(t, value.get()));
                } else if (testFieldValue != null) {
                    ++this.checksDefined;
                }
            }

            @Deprecated
            public boolean allPassed() {
                return this.checksPassed == this.checksDefined;
            }

            public boolean allPassed(boolean requireAtLeastOne) {
                if (this.checksDefined == 0 && requireAtLeastOne) {
                    return false;
                }
                return this.checksPassed == this.checksDefined;
            }

            public void add(CheckCounts other) {
                this.checksPassed += other.checksPassed;
                this.checksDefined += other.checksDefined;
            }
        }
    }

    public static enum WhenPresencePredicate {
        ABSENT,
        ABSENT_OR_NULL,
        PRESENT,
        PRESENT_NON_NULL,
        TRUTHY,
        FALSY,
        ALWAYS,
        NEVER;

    }
}

