/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsPropertiesFromBrooklynProperties;
import org.apache.brooklyn.location.jclouds.JcloudsProviderAndApiLoader;
import org.apache.brooklyn.location.jclouds.JcloudsTypeCoercions;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsLocationResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(JcloudsLocationResolver.class);
    public static final String JCLOUDS = "jclouds";
    public static final Collection<String> AWS_REGIONS = Arrays.asList("eu-west-1", "us-east-1", "us-west-1", "us-west-2", "ap-southeast-1", "ap-northeast-1", "sa-east-1");
    private ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public boolean isEnabled() {
        return LocationConfigUtils.isResolverPrefixEnabled((ManagementContext)this.managementContext, (String)this.getPrefix());
    }

    public LocationSpec<? extends Location> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        Map globalProperties = registry.getProperties();
        JcloudsSpecParser details = new JcloudsSpecParser().parse(spec, false);
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        boolean isProvider = details.isProvider();
        String providerOrApi = details.providerOrApi;
        boolean bl = isProvider = isProvider || "google-compute-engine".equals(providerOrApi);
        if (Strings.isEmpty((CharSequence)providerOrApi)) {
            throw new IllegalArgumentException("Cloud provider/API type not specified in spec \"" + spec + "\"");
        }
        if (!isProvider && !details.isApi()) {
            throw new NoSuchElementException("Cloud provider/API type " + providerOrApi + " is not supported by jclouds");
        }
        Map<String, Object> allProperties = this.getAllProperties(registry, globalProperties);
        String regionOrEndpoint = details.parameter;
        if (regionOrEndpoint == null && isProvider) {
            regionOrEndpoint = (String)locationFlags.get(LocationConfigKeys.CLOUD_REGION_ID.getName());
        }
        MutableMap jcloudsProperties = MutableMap.copyOf(new JcloudsPropertiesFromBrooklynProperties().getJcloudsProperties(providerOrApi, regionOrEndpoint, namedLocation, allProperties));
        jcloudsProperties.putAll(locationFlags);
        if (regionOrEndpoint != null) {
            if (isProvider) {
                if (Strings.isBlank((CharSequence)Strings.toString(jcloudsProperties.get(JcloudsLocationConfig.CLOUD_REGION_ID.getName())))) {
                    jcloudsProperties.put(JcloudsLocationConfig.CLOUD_REGION_ID.getName(), regionOrEndpoint);
                }
            } else if (Strings.isBlank((CharSequence)Strings.toString(jcloudsProperties.get(JcloudsLocationConfig.CLOUD_ENDPOINT.getName())))) {
                jcloudsProperties.put(JcloudsLocationConfig.CLOUD_ENDPOINT.getName(), regionOrEndpoint);
            }
        }
        return (LocationSpec)((LocationSpec)LocationSpec.create(this.getLocationClass()).configure(LocationConfigUtils.finalAndOriginalSpecs((String)spec, (Object[])new Object[]{jcloudsProperties, globalProperties, namedLocation}))).configure((Map)jcloudsProperties);
    }

    private Map<String, Object> getAllProperties(LocationRegistry registry, Map properties) {
        MutableMap allProperties = MutableMap.of();
        if (registry != null) {
            allProperties.putAll(registry.getProperties());
        }
        allProperties.putAll(properties);
        return allProperties;
    }

    public String getPrefix() {
        return JCLOUDS;
    }

    protected Class<? extends JcloudsLocation> getLocationClass() {
        return JcloudsLocation.class;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        if (BasicLocationRegistry.isResolverPrefixForSpec((LocationResolver)this, (String)spec, (boolean)true)) {
            return true;
        }
        JcloudsSpecParser details = new JcloudsSpecParser().parse(spec, true);
        if (details == null) {
            return false;
        }
        return details.isProvider() || details.isApi();
    }

    static {
        JcloudsTypeCoercions.init();
    }

    protected class JcloudsSpecParser {
        String providerOrApi;
        String parameter;

        protected JcloudsSpecParser() {
        }

        public JcloudsSpecParser parse(String spec, boolean dryrun) {
            JcloudsSpecParser result = new JcloudsSpecParser();
            int split = spec.indexOf(58);
            if (split < 0) {
                if (spec.equalsIgnoreCase(JcloudsLocationResolver.this.getPrefix())) {
                    if (dryrun) {
                        return null;
                    }
                    throw new IllegalArgumentException("Cannot use '" + spec + "' as a location ID; it is insufficient. Try jclouds:aws-ec2 (for example).");
                }
                result.providerOrApi = spec;
                result.parameter = null;
            } else {
                result.providerOrApi = spec.substring(0, split);
                result.parameter = spec.substring(split + 1);
                int numJcloudsPrefixes = 0;
                while (result.providerOrApi.equalsIgnoreCase(JcloudsLocationResolver.this.getPrefix())) {
                    ++numJcloudsPrefixes;
                    result.providerOrApi = result.parameter;
                    result.parameter = null;
                    split = result.providerOrApi.indexOf(58);
                    if (split < 0) continue;
                    result.parameter = result.providerOrApi.substring(split + 1);
                    result.providerOrApi = result.providerOrApi.substring(0, split);
                }
                if (!dryrun && numJcloudsPrefixes > 1) {
                    log.warn("Use of deprecated location spec '" + spec + "'; in future use a single \"jclouds\" prefix");
                }
            }
            if (result.parameter == null && AWS_REGIONS.contains(result.providerOrApi)) {
                result.parameter = result.providerOrApi;
                result.providerOrApi = "aws-ec2";
                if (!dryrun) {
                    log.warn("Use of deprecated location '" + result.parameter + "'; in future refer to with explicit provider '" + result.providerOrApi + ":" + result.parameter + "'");
                }
            }
            return result;
        }

        public boolean isProvider() {
            return JcloudsProviderAndApiLoader.isProvider(this.providerOrApi);
        }

        public boolean isApi() {
            return JcloudsProviderAndApiLoader.isApi(this.providerOrApi);
        }

        public String getProviderOrApi() {
            return this.providerOrApi;
        }

        public String getParameter() {
            return this.parameter;
        }
    }
}

