/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class BashCommandsConfigurable {
    private boolean ignoreCerts = true;
    public final String INSTALL_TAR = this.installExecutable("tar");
    public final String INSTALL_CURL = this.installExecutable("curl");
    public final String INSTALL_WGET = this.installExecutable("wget");
    public final String INSTALL_ZIP = this.installExecutable("zip");
    public final String INSTALL_UNZIP = this.alternatives(this.installExecutable("unzip"), this.installExecutable("zip"));
    public final String INSTALL_SYSSTAT = this.installPackage((Map<?, ?>)ImmutableMap.of((Object)"onlyifmissing", (Object)"iostat"), "sysstat");

    public static BashCommandsConfigurable newInstance() {
        return new BashCommandsConfigurable();
    }

    public BashCommandsConfigurable withIgnoreCerts(Boolean ignoreCerts) {
        if (ignoreCerts != null) {
            this.ignoreCerts = ignoreCerts;
        }
        return this;
    }

    public boolean isIgnoreCerts() {
        return this.ignoreCerts;
    }

    public String installExecutable(Map<?, ?> flags, String executable) {
        return this.onlyIfExecutableMissing(executable, this.installPackage(flags, executable));
    }

    public String installExecutable(String executable) {
        return this.installExecutable(MutableMap.of(), executable);
    }

    public String quiet(String command) {
        return String.format("(%s > /dev/null 2>&1)", command);
    }

    public String ok(String command) {
        return String.format("(%s || true)", command);
    }

    public String sudo(String command) {
        if (command == null) {
            return null;
        }
        if (command.startsWith("( ") || command.endsWith(" &")) {
            return BashCommandsConfigurable.sudoNew(command);
        }
        return BashCommandsConfigurable.sudoOld(command);
    }

    public String authSudo(String command, String password) {
        Preconditions.checkNotNull((Object)password, (Object)"password must not be null");
        if (command == null) {
            return null;
        }
        if (command.startsWith("( ") || command.endsWith(" &")) {
            throw new UnsupportedOperationException("authSudo supports only simple commands, not those wrapped in parentheses or backgrounded: cmd=" + command);
        }
        return String.format("( if test \"$UID\" -eq 0; then ( %s ); else echo -e '%s\\n' | sudo -E -S -- %s; fi )", command, password, command);
    }

    private static String sudoOld(String command) {
        if (command == null) {
            return null;
        }
        return String.format("( if test \"$UID\" -eq 0; then ( %s ); else sudo -E -n -S -- %s; fi )", command, command);
    }

    private static String sudoNew(String command) {
        if (command == null) {
            return null;
        }
        return "( if test \"$UID\" -eq 0; then ( " + command + " ); else echo " + StringEscapes.BashStringEscapes.wrapBash(command) + " | sudo -E -n -S -s -- bash ; fi )";
    }

    @Deprecated
    @Beta
    public String sudoAsUser(String user, String command) {
        return BashCommandsConfigurable.sudoAsUserOld(user, command);
    }

    private static String sudoAsUserOld(String user, String command) {
        if (command == null) {
            return null;
        }
        return String.format("{ sudo -E -n -u %s -s -- %s ; }", user, command);
    }

    public String addSbinPathCommand() {
        return "export PATH=" + this.sbinPath();
    }

    public String sbinPath() {
        return "$PATH:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin";
    }

    public String executeCommandThenAsUserTeeOutputToFile(String commandWhoseOutputToWrite, String user, String file) {
        return String.format("{ %s | sudo -E -n -u %s -s -- tee -a %s ; }", commandWhoseOutputToWrite, user, file);
    }

    public String dontRequireTtyForSudo() {
        String sudoersFileName = "/etc/sudoers";
        String tmpSuffix = Identifiers.makeRandomLowercaseId(6);
        return this.ifFileExistsElse0(sudoersFileName, this.alternatives(this.sudo(String.format("grep brooklyn-removed-require-tty %s", sudoersFileName)), this.chainGroup(this.sudo(String.format("cp %1$s %1$s.%2$s", sudoersFileName, tmpSuffix)), this.sudo(String.format("sed -i.brooklyn.bak 's/.*requiretty.*/#brooklyn-removed-require-tty/' %1$s.%2$s", sudoersFileName, tmpSuffix)), this.sudo(String.format("visudo -c -f %1$s.%2$s", sudoersFileName, tmpSuffix)), this.sudo(String.format("mv %1$s.%2$s %1$s", sudoersFileName, tmpSuffix)))));
    }

    public String generateKeyInDotSshIdRsaIfNotThere() {
        return "[ -f ~/.ssh/id_rsa ] || ( mkdir -p ~/.ssh ; chmod 700 ~/.ssh ; ssh-keygen -t rsa -N '' -f ~/.ssh/id_rsa )";
    }

    public String ifFileExistsElse0(String path, String command) {
        return this.alternativesGroup(this.chainGroup(String.format("test ! -e %s", path), "true"), command);
    }

    public String ifFileExistsElse1(String path, String command) {
        return this.chainGroup(String.format("test -e %s", path), command);
    }

    public String ifExecutableElse0(String executable, String command) {
        return this.alternativesGroup(this.chainGroup(String.format("test -z `which %s`", executable), "true"), command);
    }

    public String ifExecutableElse1(String executable, String command) {
        return this.chainGroup(String.format("which %s", executable), command);
    }

    public String ifNotExecutable(String command, String statement) {
        return String.format("{ { test ! -z `which %s`; } || { %s; } }", command, statement);
    }

    public String onlyIfExecutableMissing(String executable, String command) {
        return this.alternativesGroup(String.format("which %s", executable), command);
    }

    @Deprecated
    public String ifExecutableElse(String command, String ifNotExist, String ifExist) {
        return this.ifExecutableDoesNotExistElse(command, ifNotExist, ifExist);
    }

    public String ifExecutableDoesNotExistElse(String command, String ifNotExist, String ifExist) {
        return Joiner.on((char)'\n').join(this.ifExecutableDoesNotExistElse(command, (List<String>)ImmutableList.of((Object)ifNotExist), (List<String>)ImmutableList.of((Object)ifExist)));
    }

    @Deprecated
    public ImmutableList<String> ifExecutableElse(String command, List<String> ifNotExist, List<String> ifExist) {
        return this.ifExecutableDoesNotExistElse(command, ifNotExist, ifExist);
    }

    public ImmutableList<String> ifExecutableDoesNotExistElse(String command, List<String> ifNotExist, List<String> ifExist) {
        return ImmutableList.builder().add((Object)String.format("if test -z `which %s`; then", command)).addAll(ifNotExist).add((Object)"else").addAll(ifExist).add((Object)"fi").build();
    }

    public String chain(Collection<String> commands) {
        return "( " + Strings.join(commands, " && ") + " )";
    }

    public String chain(String ... commands) {
        return "( " + Strings.join(commands, " && ") + " )";
    }

    public String chainGroup(Collection<String> commands) {
        return "{ " + Strings.join(commands, " && ") + " ; }";
    }

    public String chainGroup(String ... commands) {
        return "{ " + Strings.join(commands, " && ") + " ; }";
    }

    public String chainSubshell(Collection<String> commands) {
        return "( " + Strings.join(commands, " && ") + " )";
    }

    public String chainSubshell(String ... commands) {
        return "( " + Strings.join(commands, " && ") + "  )";
    }

    public String alternatives(Collection<String> commands) {
        return "( " + Strings.join(commands, " || ") + " )";
    }

    public String alternatives(String ... commands) {
        return "( " + Strings.join(commands, " || ") + " )";
    }

    public String alternativesGroup(Collection<String> commands) {
        return "{ " + Strings.join(commands, " || ") + " ; }";
    }

    public String alternativesGroup(String ... commands) {
        return "{ " + Strings.join(commands, " || ") + " ; }";
    }

    public String alternativesSubshell(Collection<String> commands) {
        return "( " + Strings.join(commands, " || ") + " )";
    }

    public String alternativesSubshell(String ... commands) {
        return "( " + Strings.join(commands, " || ") + "  )";
    }

    public String formatIfNotNull(String pattern, Object arg) {
        if (arg == null) {
            return null;
        }
        return String.format(pattern, arg);
    }

    public String installPackage(String packageDefaultName) {
        return this.installPackage(MutableMap.of(), packageDefaultName);
    }

    public String installPackage(Map<?, ?> flags, String packageDefaultName) {
        return this.installPackageOr(flags, packageDefaultName, null);
    }

    public String installPackageOrFail(Map<?, ?> flags, String packageDefaultName) {
        return this.installPackageOr(flags, packageDefaultName, "exit 9");
    }

    public String installPackageOr(Map<?, ?> flags, String packageDefaultName, String optionalCommandToRunIfNone) {
        String ifMissing = (String)flags.get("onlyifmissing");
        String zypperInstall = this.formatIfNotNull("zypper --non-interactive" + (this.isIgnoreCerts() ? " --no-gpg-checks" : "") + " install %s", this.getFlag(flags, "zypper", packageDefaultName));
        String aptInstall = this.formatIfNotNull("apt-get install -y --allow-unauthenticated %s", this.getFlag(flags, "apt", packageDefaultName));
        String yumInstall = this.formatIfNotNull("yum -y" + (this.isIgnoreCerts() ? " --nogpgcheck" : "") + " install %s", this.getFlag(flags, "yum", packageDefaultName));
        String brewInstall = this.formatIfNotNull("brew install %s", this.getFlag(flags, "brew", packageDefaultName));
        String portInstall = this.formatIfNotNull("port install %s", this.getFlag(flags, "port", packageDefaultName));
        LinkedList<String> commands = new LinkedList<String>();
        if (ifMissing != null) {
            commands.add(String.format("which %s", ifMissing));
        }
        if (zypperInstall != null) {
            commands.add(this.ifExecutableElse1("zypper", this.chainGroup("echo zypper exists, doing refresh", this.ok(this.sudo("zypper --non-interactive --no-gpg-checks refresh")), this.sudo(zypperInstall))));
        }
        if (aptInstall != null) {
            commands.add(this.ifExecutableElse1("apt-get", this.chainGroup("echo apt-get exists, doing update", "export DEBIAN_FRONTEND=noninteractive", this.ok(this.sudo("apt-get update")), this.sudo(aptInstall))));
        }
        if (yumInstall != null) {
            commands.add(this.ifExecutableElse1("yum", this.chainGroup("echo yum exists, doing update", this.ok(this.sudo("yum check-update")), this.ok(this.sudo("yum -y install epel-release")), this.ok(this.sudo("yum upgrade -y ca-certificates --disablerepo=epel")), this.sudo(yumInstall))));
        }
        if (brewInstall != null) {
            commands.add(this.ifExecutableElse1("brew", brewInstall));
        }
        if (portInstall != null) {
            commands.add(this.ifExecutableElse1("port", this.sudo(portInstall)));
        }
        String lastCommand = this.ok(this.warn("WARNING: no known/successful package manager to install " + (packageDefaultName != null ? packageDefaultName : flags.toString()) + ", may fail subsequently"));
        if (optionalCommandToRunIfNone != null) {
            lastCommand = this.chain(lastCommand, optionalCommandToRunIfNone);
        }
        commands.add(lastCommand);
        return this.alternatives(commands);
    }

    public String warn(String message) {
        return "( echo " + StringEscapes.BashStringEscapes.wrapBash(message) + " | tee /dev/stderr )";
    }

    public String fail(String message, int code) {
        return this.chainGroup(this.warn(message), "exit " + code);
    }

    public String require(String command, String failureMessage, int exitCode) {
        return this.alternativesGroup(command, this.fail(failureMessage, exitCode));
    }

    public String require(String command, String failureMessage) {
        return this.alternativesGroup(command, this.chainGroup("EXIT_CODE=$?", this.warn(failureMessage), "exit $EXIT_CODE"));
    }

    public String requireTest(String test, String failureMessage, int exitCode) {
        return this.require("test " + test, failureMessage, exitCode);
    }

    public String requireTest(String test, String failureMessage) {
        return this.require("test " + test, failureMessage);
    }

    public String requireFile(String file) {
        return this.requireTest("-f " + StringEscapes.BashStringEscapes.wrapBash(file), "The required file \"" + file + "\" does not exist");
    }

    public String requireExecutable(String command) {
        return this.require("which " + StringEscapes.BashStringEscapes.wrapBash(command), "The required executable \"" + command + "\" does not exist");
    }

    public String waitForFileContents(String file, String desiredContent, Duration timeout, boolean failOnTimeout) {
        long secs = Math.max(timeout.toSeconds(), 1L);
        ImmutableList commands = ImmutableList.of((Object)("for i in {1.." + secs + "}; do"), (Object)("    grep '" + desiredContent + "' " + file + " && result=0 || result=$?"), (Object)"    [ \"$result\" == 0 ] && break", (Object)"    sleep 1", (Object)"done", (Object)"if test \"$result\" -ne 0; then", (Object)("    ls -l " + file + " || true"), (Object)("    cat " + file + " || true"), (Object)("    " + (failOnTimeout ? "echo \"Couldn't find " + desiredContent + " in " + file + "; aborting\" && exit 1" : "echo \"Couldn't find " + desiredContent + " in " + file + "; continuing\"")), (Object)"fi");
        return Joiner.on((String)"\n").join((Iterable)commands);
    }

    public String waitForFileExists(String file, Duration timeout, boolean failOnTimeout) {
        long secs = Math.max(timeout.toSeconds(), 1L);
        ImmutableList commands = ImmutableList.of((Object)("for i in {1.." + secs + "}; do"), (Object)("    [[ -f " + file + " ]] && result=0 || result=$?"), (Object)"    [ \"$result\" == 0 ] && break", (Object)"    sleep 1", (Object)"done", (Object)"if test \"$result\" -ne 0; then", (Object)("    " + (failOnTimeout ? "echo \"Couldn't find file " + file + "; aborting\" && exit 1" : "echo \"Couldn't find file " + file + "; continuing\"")), (Object)"fi");
        return Joiner.on((String)"\n").join((Iterable)commands);
    }

    public String waitForPortFree(int port, Duration timeout, boolean failOnTimeout) {
        long secs = Math.max(timeout.toSeconds(), 1L);
        String netstatCommand = this.alternativesGroup("sudo netstat -antp --tcp", "sudo netstat -antp TCP");
        String grepCommand = "grep -E '(:|\\.)" + port + "($|\\s)' > /dev/null";
        ImmutableList commands = ImmutableList.of((Object)("for i in {1.." + secs + "}; do"), (Object)("    " + this.requireExecutable("netstat")), (Object)("    " + this.alternativesGroup(this.chainGroup("which awk", "AWK_EXEC=awk"), this.chainGroup("which gawk", "AWK_EXEC=gawk"), this.chainGroup("which /usr/bin/awk", "AWK_EXEC=/usr/bin/awk"), this.chainGroup("echo \"No awk to determine if Port " + port + " still in use; aborting\"", "exit 1"))), (Object)("    " + netstatCommand + " | $AWK_EXEC '{print $4}' | " + grepCommand + " && result=0 || result=$?"), (Object)"    [ \"$result\" != 0 ] && break", (Object)"    sleep 1", (Object)"done", (Object)"if test \"$result\" -eq 0; then", (Object)("    " + (failOnTimeout ? "echo \"Port " + port + " still in use (according to netstat); aborting\" && exit 1" : "echo \"Port " + port + " still in use (according to netstat); continuing\"")), (Object)"fi");
        return Joiner.on((String)"\n").join((Iterable)commands);
    }

    public String unzip(String file, String targetDir) {
        return "unzip " + file + (Strings.isNonBlank(targetDir) ? " -d " + targetDir : "");
    }

    public List<String> commandsToDownloadUrlsAs(List<String> urls, String saveAs) {
        return Arrays.asList(this.INSTALL_CURL, this.require(this.simpleDownloadUrlAs(urls, saveAs), "Could not retrieve " + saveAs + ". Tried: " + Joiner.on((String)", ").join(urls), 9));
    }

    public List<String> commandsToDownloadUrlsAsWithMinimumTlsVersion(List<String> urls, String saveAs, String tlsVersion) {
        return Arrays.asList(this.INSTALL_CURL, this.require(this.simpleDownloadUrlAs(urls, saveAs, tlsVersion), "Could not retrieve " + saveAs + ". Tried: " + Joiner.on((String)", ").join(urls), 9));
    }

    public String commandToDownloadUrlsAs(List<String> urls, String saveAs) {
        return this.chain(this.INSTALL_CURL, this.require(this.simpleDownloadUrlAs(urls, saveAs), "Could not retrieve " + saveAs + ". Tried: " + Joiner.on((String)", ").join(urls), 9));
    }

    public String commandToDownloadUrlAs(String url, String saveAs) {
        return this.chain(this.INSTALL_CURL, this.require(this.simpleDownloadUrlAs(Arrays.asList(url), saveAs), "Could not retrieve " + saveAs + " from " + url, 9));
    }

    public String downloadToStdout(List<String> urls) {
        return this.chain(this.INSTALL_CURL + " > /dev/null", this.require(this.simpleDownloadUrlAs(urls, null), "Could not retrieve file. Tried: " + Joiner.on((String)", ").join(urls), 9));
    }

    public String downloadToStdout(String ... urls) {
        return this.downloadToStdout(Arrays.asList(urls));
    }

    public String simpleDownloadUrlAs(List<String> urls, String saveAs) {
        return this.simpleDownloadUrlAs(urls, null, null, saveAs, null);
    }

    public String simpleDownloadUrlAs(List<String> urls, String saveAs, String tlsVersion) {
        return this.simpleDownloadUrlAs(urls, null, null, saveAs, tlsVersion);
    }

    public String simpleDownloadUrlAs(List<String> urls, String user, String password, String saveAs, String tlsVersion) {
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("No URLs supplied to download " + saveAs);
        }
        ArrayList<String> commands = new ArrayList<String>();
        for (String url : urls) {
            String command;
            String string = tlsVersion == null ? "curl -f -L" + (this.isIgnoreCerts() ? " -k" : "") + " --retry 10 --keepalive-time 30 --speed-time 30 " : (command = "curl --tlsv" + tlsVersion + " -f -L " + (this.isIgnoreCerts() ? " -k" : "") + " --retry 10 --keepalive-time 30 --speed-time 30 ");
            if (user != null && password != null) {
                command = command + String.format("-u %s:%s ", user, password);
            }
            command = command + String.format("\"%s\"", url);
            if (saveAs != null) {
                command = command + String.format(" -o %s", saveAs);
            }
            commands.add(command);
        }
        return this.alternatives(commands);
    }

    private Object getFlag(Map<?, ?> flags, String flagName, Object defaultValue) {
        Object found = flags.get(flagName);
        return found == null ? defaultValue : found;
    }

    public String installJava(int version) {
        Preconditions.checkArgument((version == 6 || version == 7 || version == 8 ? 1 : 0) != 0, (Object)"Supported Java versions are 6, 7, or 8");
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(this.ok(this.addOpenJDKPPK()));
        commands.add(this.installPackageOr(MutableMap.of("apt", "openjdk-" + version + "-jdk", "yum", "java-1." + version + ".0-openjdk-devel"), null, this.ifExecutableElse1("zypper", this.chainGroup(this.ok(this.sudo("zypper --non-interactive addrepo http://download.opensuse.org/repositories/Java:/openjdk6:/Factory/SLE_11_SP3 java_sles_11")), this.ok(this.sudo("zypper --non-interactive addrepo http://download.opensuse.org/repositories/Java:/openjdk6:/Factory/openSUSE_11.4 java_suse_11")), this.ok(this.sudo("zypper --non-interactive addrepo http://download.opensuse.org/repositories/Java:/openjdk6:/Factory/openSUSE_12.3 java_suse_12")), this.ok(this.sudo("zypper --non-interactive addrepo http://download.opensuse.org/repositories/Java:/openjdk6:/Factory/openSUSE_13.1 java_suse_13")), this.alternatives(this.installPackageOrFail(MutableMap.of("zypper", "java-1_" + version + "_0-openjdk-devel"), null), this.installPackageOrFail(MutableMap.of("zypper", "java-1_" + version + "_0-ibm"), null))))));
        commands.add(this.ok(this.upgradeNSS()));
        return this.chainGroup(commands);
    }

    public String installJava6() {
        return this.installJava(6);
    }

    public String installJava7() {
        return this.installJava(7);
    }

    public String installJava8() {
        return this.installJava(8);
    }

    public String installJava6IfPossible() {
        return this.ok(this.installJava6());
    }

    public String installJava7IfPossible() {
        return this.ok(this.installJava7());
    }

    public String installJava8IfPossible() {
        return this.ok(this.installJava8());
    }

    public String installJava6OrFail() {
        return this.alternatives(this.installJava6(), this.fail("java 6 install failed", 9));
    }

    public String installJava7OrFail() {
        return this.alternatives(this.installJava7(), this.fail("java 7 install failed", 9));
    }

    public String installJava7Or6OrFail() {
        return this.alternatives(this.installJava7(), this.installJava6(), this.fail("java install failed", 9));
    }

    public String installJavaLatestOrFail() {
        return this.alternatives(this.installJava8(), this.installJava7(), this.installJava6(), this.fail("java latest install failed", 9));
    }

    public String installJavaLatestOrWarn() {
        return this.alternatives(this.installJava8(), this.installJava7(), this.installJava6(), this.warn("java latest install failed, entity may subsequently fail"));
    }

    public String addOpenJDKPPK() {
        return this.chainGroup(this.sudo("sudo add-apt-repository -y ppa:openjdk-r/ppa"), this.sudo("sudo apt-get update"));
    }

    public String upgradeNSS() {
        return this.chainGroup("which yum", this.sudo("yum -y upgrade nss"));
    }

    public String pipeTextTo(String text, String command) {
        return "cat << EOL_BROOKLYN | " + command + "\n" + text + "\nEOL_BROOKLYN\n";
    }

    public String pipeTextToFile(String text, String filepath) {
        return "cat > \"" + filepath + "\" << EOF_BROOKLYN\n" + text + "\nEOF_BROOKLYN\n";
    }

    public String prependToEtcHosts(String ip, String ... hostnames) {
        String tempFileId = "bak" + Identifiers.makeRandomId(4);
        return this.sudo(String.format("sed -i." + tempFileId + " -e '1i\\\n%s %s' /etc/hosts", ip, Joiner.on((String)" ").join((Object[])hostnames)));
    }

    public String appendToEtcHosts(String ip, String ... hostnames) {
        String tempFileId = "bak" + Identifiers.makeRandomId(4);
        return this.sudo(String.format("sed -i." + tempFileId + " -e '$a\\\n%s %s' /etc/hosts", ip, Joiner.on((String)" ").join((Object[])hostnames)));
    }

    @Beta
    public List<String> setHostname(String newHostname) {
        if (newHostname.indexOf(".") > 0) {
            String hostPart = newHostname.substring(0, newHostname.indexOf("."));
            String domainPart = newHostname.substring(hostPart.length() + 1);
            return this.setHostname(hostPart, domainPart);
        }
        return this.setHostname(newHostname, null);
    }

    @Beta
    public List<String> setHostname(String hostPart, String domainPart) {
        Preconditions.checkNotNull((Object)hostPart, (Object)"hostPart");
        Preconditions.checkArgument((!hostPart.contains(".") ? 1 : 0) != 0, (String)"hostPart '%s' must not contain '.'", (Object)hostPart);
        String tempFileId = "bak" + Identifiers.makeRandomId(4);
        ArrayList allhostnames = Lists.newArrayList();
        String fqdn = hostPart;
        if (Strings.isNonBlank(domainPart)) {
            fqdn = hostPart + "." + domainPart;
            allhostnames.add(fqdn);
        }
        allhostnames.add(hostPart);
        allhostnames.add("localhost");
        return ImmutableList.of((Object)this.sudo("sed -i." + tempFileId + " -e 's/^127.0.0.1/# Replaced by Brooklyn\\\n#127.0.0.1/' /etc/hosts"), (Object)this.prependToEtcHosts("127.0.0.1", allhostnames.toArray(new String[allhostnames.size()])), (Object)this.ifFileExistsElse0("/etc/sysconfig/network", this.sudo("sed -i." + tempFileId + " -e 's/^HOSTNAME=.*$/HOSTNAME=" + hostPart + "/' /etc/sysconfig/network")), (Object)this.ifFileExistsElse0("/etc/hostname", this.sudo("sed -i." + tempFileId + " -e 's/^[a-zA-Z_0-9].*$/" + hostPart + "/' /etc/hostname")), (Object)this.sudo("hostname " + hostPart));
    }
}

