/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.DynamicGroupImpl;
import org.apache.brooklyn.entity.proxy.LoadBalancer;
import org.apache.brooklyn.entity.proxy.nginx.NginxController;
import org.apache.brooklyn.entity.webapp.ControlledDynamicWebAppCluster;
import org.apache.brooklyn.entity.webapp.DynamicWebAppCluster;
import org.apache.brooklyn.entity.webapp.DynamicWebAppClusterImpl;
import org.apache.brooklyn.entity.webapp.tomcat.TomcatServer;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledDynamicWebAppClusterImpl
extends DynamicGroupImpl
implements ControlledDynamicWebAppCluster {
    public static final Logger log = LoggerFactory.getLogger(ControlledDynamicWebAppClusterImpl.class);

    public void init() {
        Object controlledGroup;
        boolean hasMemberSpec;
        super.init();
        ConfigToAttributes.apply((Entity)this, (AttributeSensorAndConfigKey)MEMBER_SPEC);
        ConfigToAttributes.apply((Entity)this, (AttributeSensorAndConfigKey)CONTROLLER);
        ConfigToAttributes.apply((Entity)this, (AttributeSensorAndConfigKey)CONTROLLER_SPEC);
        ConfigToAttributes.apply((Entity)this, (AttributeSensorAndConfigKey)WEB_CLUSTER_SPEC);
        ConfigToAttributes.apply((Entity)this, (AttributeSensorAndConfigKey)CONTROLLED_GROUP);
        EntitySpec webServerSpec = (EntitySpec)this.getAttribute((AttributeSensor)MEMBER_SPEC);
        if (webServerSpec == null) {
            log.debug("creating default web server spec for {}", (Object)this);
            webServerSpec = EntitySpec.create(TomcatServer.class);
            this.sensors().set((AttributeSensor)MEMBER_SPEC, (Object)webServerSpec);
        }
        log.debug("creating cluster child for {}", (Object)this);
        EntitySpec webClusterSpec = (EntitySpec)this.getAttribute((AttributeSensor)WEB_CLUSTER_SPEC);
        MutableMap webClusterFlags = MutableMap.of((Object)"memberSpec", (Object)webServerSpec);
        if (webClusterSpec == null) {
            log.debug("creating default web cluster spec for {}", (Object)this);
            webClusterSpec = EntitySpec.create(DynamicWebAppCluster.class);
        }
        boolean bl = hasMemberSpec = webClusterSpec.getConfig().containsKey(DynamicWebAppCluster.MEMBER_SPEC) || webClusterSpec.getFlags().containsKey("memberSpec");
        if (!hasMemberSpec) {
            webClusterSpec.configure((Map)webClusterFlags);
        } else {
            log.warn("In {}, not setting cluster's {} because already set on webClusterSpec", new Object[]{this, webClusterFlags.keySet()});
        }
        this.sensors().set((AttributeSensor)WEB_CLUSTER_SPEC, (Object)webClusterSpec);
        DynamicWebAppCluster cluster = (DynamicWebAppCluster)this.addChild(webClusterSpec);
        this.sensors().set(CLUSTER, (Object)cluster);
        this.setEntityFilter(EntityPredicates.isMemberOf((Group)cluster));
        LoadBalancer controller = (LoadBalancer)this.getAttribute((AttributeSensor)CONTROLLER);
        if (controller == null) {
            EntitySpec controllerSpec = (EntitySpec)this.getAttribute((AttributeSensor)CONTROLLER_SPEC);
            if (controllerSpec == null) {
                log.debug("creating controller using default spec for {}", (Object)this);
                controllerSpec = EntitySpec.create(NginxController.class);
                this.sensors().set((AttributeSensor)CONTROLLER_SPEC, (Object)controllerSpec);
            } else {
                log.debug("creating controller using custom spec for {}", (Object)this);
            }
            controller = (LoadBalancer)this.addChild(controllerSpec);
            this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{LoadBalancer.PROXY_HTTP_PORT, LoadBalancer.PROXY_HTTPS_PORT}).from((Entity)controller)).build());
            this.sensors().set((AttributeSensor)CONTROLLER, (Object)controller);
        }
        if ((controlledGroup = (Group)this.getAttribute((AttributeSensor)CONTROLLED_GROUP)) == null) {
            log.debug("using cluster as controlledGroup for {}", (Object)this);
            controlledGroup = cluster;
            this.sensors().set((AttributeSensor)CONTROLLED_GROUP, (Object)cluster);
        } else {
            log.debug("using custom controlledGroup {} for {}", controlledGroup, (Object)this);
        }
        this.doBind();
    }

    protected void initEnrichers() {
        if (this.config().getLocalRaw(UP_QUORUM_CHECK).isAbsent()) {
            this.config().set(UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.newInstance((int)2, (double)1.0, (boolean)false));
        }
        super.initEnrichers();
        ServiceStateLogic.newEnricherFromChildrenUp().checkChildrenOnly().requireUpChildren((QuorumCheck)this.getConfig(UP_QUORUM_CHECK)).addTo((Entity)this);
    }

    public void rebind() {
        super.rebind();
        this.doBind();
    }

    protected void doBind() {
        DynamicWebAppCluster cluster = (DynamicWebAppCluster)this.getAttribute(CLUSTER);
        if (cluster != null) {
            this.subscriptions().subscribe((Entity)cluster, (Sensor)DynamicWebAppCluster.GROUP_MEMBERS, (SensorEventListener)new SensorEventListener<Object>(){

                public void onEvent(SensorEvent<Object> event) {
                    ControlledDynamicWebAppClusterImpl.this.rescanEntities();
                }
            });
        }
    }

    @Override
    public LoadBalancer getController() {
        return (LoadBalancer)this.getAttribute((AttributeSensor)CONTROLLER);
    }

    @Override
    public DynamicWebAppCluster getCluster() {
        return (DynamicWebAppCluster)this.getAttribute(CLUSTER);
    }

    @Override
    public Group getControlledGroup() {
        return (Group)this.getAttribute((AttributeSensor)CONTROLLED_GROUP);
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        try {
            if (this.isLegacyConstruction()) {
                this.init();
            }
            locations = Locations.getLocationsCheckingAncestors(locations, (Entity)this);
            this.addLocations(locations);
            LoadBalancer loadBalancer = this.getController();
            loadBalancer.bind((Map<?, ?>)MutableMap.of((Object)"serverPool", (Object)this.getControlledGroup()));
            MutableList childrenToStart = MutableList.of((Object)this.getCluster());
            if (this.getController().getParent() == null) {
                this.addChild(this.getController());
            }
            Task startControllerTask = null;
            if (this.equals(this.getController().getParent())) {
                if (this.getController().getLocations().size() == 0) {
                    childrenToStart.add(this.getController());
                } else {
                    startControllerTask = Entities.invokeEffectorList((Entity)this, (Iterable)MutableList.of((Object)this.getController()), (Effector)Startable.START, (Map)ImmutableMap.of((Object)"locations", (Object)this.getController().getLocations()));
                }
            }
            Entities.invokeEffectorList((Entity)this, (Iterable)childrenToStart, (Effector)Startable.START, (Map)ImmutableMap.of((Object)"locations", (Object)MutableList.of())).get();
            if (startControllerTask != null) {
                startControllerTask.get();
            }
            this.getController().update();
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.connectSensors();
        }
    }

    public void stop() {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
        try {
            ArrayList tostop = Lists.newArrayList();
            if (this.equals(this.getController().getParent())) {
                tostop.add(this.getController());
            }
            tostop.add(this.getCluster());
            StartableMethods.stopSequentially((Iterable)tostop);
            this.clearLocations();
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    void connectSensors() {
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagatingAllButUsualAnd(new Sensor[]{Attributes.MAIN_URI, ROOT_URL, GROUP_MEMBERS, GROUP_SIZE}).from((Entity)this.getCluster())).build());
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{LoadBalancer.HOSTNAME, Attributes.ADDRESS, Attributes.MAIN_URI, ROOT_URL}).from((Entity)this.getController())).build());
    }

    public Integer resize(Integer desiredSize) {
        return this.getCluster().resize(desiredSize);
    }

    public String replaceMember(String memberId) {
        return this.getCluster().replaceMember(memberId);
    }

    public Integer getCurrentSize() {
        return this.getCluster().getCurrentSize();
    }

    @Override
    public void deploy(String url, String targetName) {
        DynamicWebAppClusterImpl.addToWarsByContext(this, url, targetName);
        this.getCluster().deploy(url, targetName);
    }

    @Override
    public void undeploy(String targetName) {
        DynamicWebAppClusterImpl.removeFromWarsByContext(this, targetName);
        this.getCluster().undeploy(targetName);
    }

    @Override
    public void redeployAll() {
        this.getCluster().redeployAll();
    }
}

