/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.crypto;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteProcessor;
import javax.crypto.Mac;

@Beta
public class Macs {
    public static ByteProcessor<byte[]> asByteProcessor(final Mac mac) {
        Preconditions.checkNotNull((Object)mac, (Object)"mac");
        return new ByteProcessor<byte[]>(){

            public boolean processBytes(byte[] buf, int off, int len) {
                mac.update(buf, off, len);
                return true;
            }

            public byte[] getResult() {
                return mac.doFinal();
            }
        };
    }
}

