/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.features;

import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.domain.HostedZoneAndNameServers;
import org.jclouds.route53.domain.NewHostedZone;
import org.jclouds.route53.filters.RestAuthentication;
import org.jclouds.route53.functions.HostedZonesToPagedIterable;
import org.jclouds.route53.xml.ChangeHandler;
import org.jclouds.route53.xml.CreateHostedZoneResponseHandler;
import org.jclouds.route53.xml.GetHostedZoneResponseHandler;
import org.jclouds.route53.xml.ListHostedZonesResponseHandler;

@RequestFilters(value={RestAuthentication.class})
@VirtualHost
public interface HostedZoneApi {
    @Named(value="CreateHostedZone")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/hostedzone")
    @Payload(value="<CreateHostedZoneRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><Name>{name}</Name><CallerReference>{callerReference}</CallerReference></CreateHostedZoneRequest>")
    @XMLResponseParser(value=CreateHostedZoneResponseHandler.class)
    public NewHostedZone createWithReference(@PayloadParam(value="name") String var1, @PayloadParam(value="callerReference") String var2);

    @Named(value="CreateHostedZone")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/hostedzone")
    @Payload(value="<CreateHostedZoneRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><Name>{name}</Name><CallerReference>{callerReference}</CallerReference><HostedZoneConfig><Comment>{comment}</Comment></HostedZoneConfig></CreateHostedZoneRequest>")
    @XMLResponseParser(value=CreateHostedZoneResponseHandler.class)
    public NewHostedZone createWithReferenceAndComment(@PayloadParam(value="name") String var1, @PayloadParam(value="callerReference") String var2, @PayloadParam(value="comment") String var3);

    @Named(value="ListHostedZones")
    @GET
    @Path(value="/hostedzone")
    @XMLResponseParser(value=ListHostedZonesResponseHandler.class)
    @Transform(value=HostedZonesToPagedIterable.class)
    public PagedIterable<HostedZone> list();

    @Named(value="ListHostedZones")
    @GET
    @Path(value="/hostedzone")
    @XMLResponseParser(value=ListHostedZonesResponseHandler.class)
    public IterableWithMarker<HostedZone> listFirstPage();

    @Named(value="ListHostedZones")
    @GET
    @Path(value="/hostedzone")
    @XMLResponseParser(value=ListHostedZonesResponseHandler.class)
    public IterableWithMarker<HostedZone> listAt(@QueryParam(value="marker") String var1);

    @Named(value="GetHostedZone")
    @GET
    @Path(value="/hostedzone/{zoneId}")
    @XMLResponseParser(value=GetHostedZoneResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public HostedZoneAndNameServers get(@PathParam(value="zoneId") String var1);

    @Named(value="DeleteHostedZone")
    @DELETE
    @Path(value="/hostedzone/{zoneId}")
    @XMLResponseParser(value=ChangeHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Change delete(@PathParam(value="zoneId") String var1);
}

