/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.options;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;

public final class CopyBlobOptions {
    public static final CopyBlobOptions NONE = CopyBlobOptions.builder().build();
    private final Optional<Map<String, String>> userMetadata;
    private final Optional<Date> ifModifiedSince;
    private final Optional<Date> ifUnmodifiedSince;
    private final Optional<String> ifMatch;
    private final Optional<String> ifNoneMatch;

    private CopyBlobOptions(Map<String, String> userMetadata, Date ifModifiedSince, Date ifUnmodifiedSince, String ifMatch, String ifNoneMatch) {
        this.userMetadata = Optional.fromNullable(userMetadata);
        this.ifModifiedSince = Optional.fromNullable((Object)ifModifiedSince);
        this.ifUnmodifiedSince = Optional.fromNullable((Object)ifUnmodifiedSince);
        this.ifMatch = Optional.fromNullable((Object)ifMatch);
        this.ifNoneMatch = Optional.fromNullable((Object)ifNoneMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Map<String, String>> getUserMetadata() {
        return this.userMetadata;
    }

    public Optional<Date> getIfModifiedSince() {
        return Optional.fromNullable(this.ifModifiedSince.isPresent() ? (Date)((Date)this.ifModifiedSince.get()).clone() : null);
    }

    public Optional<Date> getIfUnmodifiedSince() {
        return Optional.fromNullable(this.ifUnmodifiedSince.isPresent() ? (Date)((Date)this.ifUnmodifiedSince.get()).clone() : null);
    }

    public Optional<String> getIfMatch() {
        return this.ifMatch;
    }

    public Optional<String> getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public static class Builder {
        private Map<String, String> userMetadata;
        private Date ifModifiedSince;
        private Date ifUnmodifiedSince;
        private String ifMatch;
        private String ifNoneMatch;

        Builder() {
        }

        public Builder overrideUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(userMetadata, (Object)"userMetadata")));
            return this;
        }

        public Builder ifModifiedSince(Date ifModifiedSince) {
            this.ifModifiedSince = (Date)((Date)Preconditions.checkNotNull((Object)ifModifiedSince, (Object)"ifModifiedSince")).clone();
            return this;
        }

        public Builder ifUnmodifiedSince(Date ifUnmodifiedSince) {
            this.ifUnmodifiedSince = (Date)((Date)Preconditions.checkNotNull((Object)ifUnmodifiedSince, (Object)"ifUnmodifiedSince")).clone();
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = (String)Preconditions.checkNotNull((Object)ifMatch, (Object)"ifMatch");
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = (String)Preconditions.checkNotNull((Object)ifNoneMatch, (Object)"ifNoneMatch");
            return this;
        }

        public CopyBlobOptions build() {
            return new CopyBlobOptions(this.userMetadata, this.ifModifiedSince, this.ifUnmodifiedSince, this.ifMatch, this.ifNoneMatch);
        }
    }
}

