/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroupProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface NetworkSecurityGroupApi {
    @Named(value="networksecuritygroup:list")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/networkSecurityGroups")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<NetworkSecurityGroup> list();

    @Named(value="networksecuritygroup:listall")
    @GET
    @Path(value="/providers/Microsoft.Network/networkSecurityGroups")
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<NetworkSecurityGroup> listAll();

    @Named(value="networksecuritygroup:delete")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/networkSecurityGroups/{networksecuritygroupname}")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="networksecuritygroupname") String var1);

    @Named(value="networksecuritygroup:createOrUpdate")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/networkSecurityGroups/{networksecuritygroupname}")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    public NetworkSecurityGroup createOrUpdate(@PathParam(value="networksecuritygroupname") String var1, @PayloadParam(value="location") String var2, @Nullable @PayloadParam(value="tags") Map<String, String> var3, @PayloadParam(value="properties") NetworkSecurityGroupProperties var4);

    @Named(value="networksecuritygroup:get")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/networkSecurityGroups/{networksecuritygroupname}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public NetworkSecurityGroup get(@PathParam(value="networksecuritygroupname") String var1);
}

