/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.drivers.downloads;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolverManager;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.drivers.downloads.BasicDownloadTargets;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadSubstituters {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadSubstituters.class);

    private DownloadSubstituters() {
    }

    public static String substitute(DownloadResolverManager.DownloadRequirement req, String basevalue) {
        return DownloadSubstituters.substitute(basevalue, DownloadSubstituters.getBasicSubstitutions(req));
    }

    public static Map<String, Object> getBasicSubstitutions(DownloadResolverManager.DownloadRequirement req) {
        EntityDriver driver = req.getEntityDriver();
        String addon = req.getAddonName();
        Map props = req.getProperties();
        if (addon == null) {
            return MutableMap.builder().putAll(DownloadSubstituters.getBasicEntitySubstitutions(driver)).putAll(props).build();
        }
        return MutableMap.builder().putAll(DownloadSubstituters.getBasicAddonSubstitutions(driver, addon)).putAll(props).build();
    }

    public static Map<String, Object> getBasicEntitySubstitutions(EntityDriver driver) {
        EntityLocal entity = driver.getEntity();
        String type = entity.getEntityType().getName();
        String simpleType = type.substring(type.lastIndexOf(".") + 1);
        String version = (String)entity.getConfig(BrooklynConfigKeys.SUGGESTED_VERSION);
        return MutableMap.builder().put((Object)"entity", (Object)entity).put((Object)"driver", (Object)driver).put((Object)"type", (Object)type).put((Object)"simpletype", (Object)simpleType).putIfNotNull((Object)"version", (Object)version).build();
    }

    public static Map<String, Object> getBasicAddonSubstitutions(EntityDriver driver, String addon) {
        return MutableMap.builder().putAll(DownloadSubstituters.getBasicEntitySubstitutions(driver)).put((Object)"addon", (Object)addon).build();
    }

    public static String substitute(String basevalue, Map<String, ?> substitutions) {
        try {
            Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            StringTemplateLoader templateLoader = new StringTemplateLoader();
            templateLoader.putTemplate("config", basevalue);
            cfg.setTemplateLoader((TemplateLoader)templateLoader);
            Template template = cfg.getTemplate("config");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(baos);
            template.process(substitutions, (Writer)out);
            ((Writer)out).flush();
            return new String(baos.toByteArray());
        }
        catch (IOException e) {
            LOG.warn("Error processing template '" + basevalue + "'", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("Failed to process driver download '" + basevalue + "'", e);
        }
    }

    public static Function<DownloadResolverManager.DownloadRequirement, DownloadResolverManager.DownloadTargets> substituter(Function<? super DownloadResolverManager.DownloadRequirement, String> basevalueProducer, Function<? super DownloadResolverManager.DownloadRequirement, ? extends Map<String, ?>> subsProducer) {
        return new Substituter(basevalueProducer, subsProducer);
    }

    static {
        try {
            LOG.debug("Configuring Freemarker logging for Brooklyn to use SLF4J");
            System.setProperty("org.freemarker.loggerLibrary", "SLF4J");
        }
        catch (Exception e) {
            LOG.warn("Error setting Freemarker logging: " + e, (Throwable)e);
        }
    }

    protected static class Substituter
    implements Function<DownloadResolverManager.DownloadRequirement, DownloadResolverManager.DownloadTargets> {
        private final Function<? super DownloadResolverManager.DownloadRequirement, String> basevalueProducer;
        private final Function<? super DownloadResolverManager.DownloadRequirement, ? extends Map<String, ?>> subsProducer;

        Substituter(Function<? super DownloadResolverManager.DownloadRequirement, String> baseValueProducer, Function<? super DownloadResolverManager.DownloadRequirement, ? extends Map<String, ?>> subsProducer) {
            this.basevalueProducer = (Function)Preconditions.checkNotNull(baseValueProducer, (Object)"basevalueProducer");
            this.subsProducer = (Function)Preconditions.checkNotNull(subsProducer, (Object)"subsProducer");
        }

        public DownloadResolverManager.DownloadTargets apply(DownloadResolverManager.DownloadRequirement input) {
            String basevalue = (String)this.basevalueProducer.apply((Object)input);
            Map subs = (Map)this.subsProducer.apply((Object)input);
            String result = basevalue != null ? DownloadSubstituters.substitute(basevalue, subs) : null;
            return result != null ? BasicDownloadTargets.builder().addPrimary(result).build() : BasicDownloadTargets.empty();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("basevalue", this.basevalueProducer).add("subs", this.subsProducer).toString();
        }
    }
}

