/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineManagementMixins;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.HasNetworkAddresses;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineLifecycleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MachineLifecycleUtils.class);
    private final MachineLocation location;
    public static ConfigKey<MachineStatus> STATUS = ConfigKeys.newConfigKey(MachineStatus.class, "status");
    Duration timeout = Duration.minutes((Number)30);

    public MachineLifecycleUtils(MachineLocation l) {
        this.location = l;
    }

    @Nullable
    public Boolean exists() {
        if (this.location.getParent() instanceof MachineManagementMixins.GivesMachineMetadata) {
            MachineManagementMixins.MachineMetadata metadata = ((MachineManagementMixins.GivesMachineMetadata)this.location.getParent()).getMachineMetadata(this.location);
            return metadata != null;
        }
        if (this.location.getParent() instanceof MachineManagementMixins.GivesMetrics) {
            ConfigBag metrics = ConfigBag.newInstance(((MachineManagementMixins.GivesMetrics)this.location.getParent()).getMachineMetrics(this.location));
            return !metrics.isEmpty();
        }
        return null;
    }

    @Nonnull
    public MachineStatus getStatus() {
        MachineManagementMixins.MachineMetadata metadata;
        ConfigBag metrics;
        MachineStatus s;
        if (this.location.getParent() instanceof MachineManagementMixins.GivesMetrics && (s = (metrics = ConfigBag.newInstance(((MachineManagementMixins.GivesMetrics)this.location.getParent()).getMachineMetrics(this.location))).get(STATUS)) != null) {
            return s;
        }
        if (this.location.getParent() instanceof MachineManagementMixins.GivesMachineMetadata && (metadata = ((MachineManagementMixins.GivesMachineMetadata)this.location.getParent()).getMachineMetadata(this.location)) != null) {
            if (metadata instanceof GivesMachineStatus) {
                return ((GivesMachineStatus)metadata).getStatus();
            }
            if (metadata.isRunning().booleanValue()) {
                return MachineStatus.RUNNING;
            }
            return MachineStatus.UNKNOWN;
        }
        return MachineStatus.UNKNOWN;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = (Duration)Preconditions.checkNotNull((Object)timeout);
    }

    public ReferenceWithError<MachineLocation> resume() {
        MachineStatus status = this.getStatus();
        if (MachineStatus.RUNNING.equals((Object)status)) {
            return ReferenceWithError.newInstanceMaskingError((Object)this.location, (Throwable)new Throwable("Already running"));
        }
        if (this.location.getParent() instanceof MachineManagementMixins.ResumesMachines) {
            try {
                return ReferenceWithError.newInstanceWithoutError((Object)((MachineManagementMixins.ResumesMachines)this.location.getParent()).resumeMachine(this.getConfigMapWithId()));
            }
            catch (Exception e) {
                return ReferenceWithError.newInstanceThrowingError((Object)this.location, (Throwable)e);
            }
        }
        return ReferenceWithError.newInstanceThrowingError((Object)this.location, (Throwable)new Throwable("Machine does not support resumption"));
    }

    public Maybe<MachineLocation> makeRunning() {
        CountdownTimer timer = CountdownTimer.newInstanceStarted((Duration)this.getTimeout());
        MachineStatus status = this.getStatus();
        Duration sleep = Duration.ONE_SECOND;
        while (MachineStatus.TRANSITIONING.equals((Object)status)) {
            if (timer.isExpired()) {
                return Maybe.absent((String)("Timeout waiting for " + this.location + " to be stable before running"));
            }
            try {
                Duration s = sleep;
                Tasks.withBlockingDetails("waiting on " + this.location + " to be stable before running", () -> {
                    Time.sleep((Duration)Duration.min((Duration)s, (Duration)timer.getDurationRemaining()));
                    return null;
                });
            }
            catch (Exception e) {
                return Maybe.absent((Throwable)new IllegalStateException("Error waiting for " + this.location + " to be stable before running", e));
            }
            status = this.getStatus();
            sleep = Duration.min((Duration)sleep.multiply(1.2), (Duration)Duration.ONE_MINUTE);
        }
        if (MachineStatus.RUNNING.equals((Object)status)) {
            return Maybe.of((Object)this.location);
        }
        if (MachineStatus.SUSPENDED.equals((Object)status) && this.location.getParent() instanceof MachineManagementMixins.ResumesMachines) {
            return Maybe.of((Object)((MachineManagementMixins.ResumesMachines)this.location.getParent()).resumeMachine(this.getConfigMapWithId()));
        }
        if (MachineStatus.SHUTDOWN.equals((Object)status) && this.location.getParent() instanceof MachineManagementMixins.ShutsdownMachines) {
            return Maybe.of((Object)((MachineManagementMixins.ShutsdownMachines)this.location.getParent()).startupMachine(this.getConfigMapWithId()));
        }
        return Maybe.absent((String)("Unable to make " + this.location + " running from status " + (Object)((Object)status) + "; no methods for doing so are available"));
    }

    public MachineLocation makeRunningOrRecreate(Map<String, ?> newConfig) throws NoMachinesAvailableException {
        Exception problemRunning = null;
        Maybe<MachineLocation> result = null;
        try {
            result = this.makeRunning();
            if (result.isPresent()) {
                return (MachineLocation)result.get();
            }
            problemRunning = Maybe.Absent.getException(result);
        }
        catch (Exception e) {
            problemRunning = e;
        }
        if (problemRunning != null) {
            LOG.warn("Unable to make existing machine running (" + this.location + "), will destroy and re-create: " + problemRunning);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Trace for: Unable to make existing machine running (" + this.location + "), will destroy and re-create: " + problemRunning, (Throwable)problemRunning);
            }
            DynamicTasks.queueIfPossible(Tasks.warning("Could not make existing machine running: " + Exceptions.collapseText((Throwable)problemRunning), problemRunning));
        }
        if (!(this.location.getParent() instanceof MachineProvisioningLocation)) {
            throw new IllegalStateException("Cannot destroy/recreate " + this.location + " because parent is not a provisioning location, and cannot resume due to: " + problemRunning);
        }
        ((MachineProvisioningLocation)this.location.getParent()).release(this.location);
        return ((MachineProvisioningLocation)this.location.getParent()).obtain(newConfig);
    }

    public ConfigBag getConfig() {
        return ((BrooklynObjectInternal.ConfigurationSupportInternal)this.location.config()).getBag();
    }

    public Map<String, ?> getConfigMapWithId() {
        MachineManagementMixins.MachineMetadata metadata;
        MutableMap result = MutableMap.copyOf(this.getConfig().getAllConfig());
        if (this.location.getParent() instanceof MachineManagementMixins.GivesMachineMetadata && (metadata = ((MachineManagementMixins.GivesMachineMetadata)this.location.getParent()).getMachineMetadata(this.location)) != null) {
            result.add((Object)"id", (Object)metadata.getId());
        }
        return result;
    }

    public static Boolean isSameInstance(MachineLocation m1, MachineLocation m2, boolean requireSameAccessDetails) {
        Boolean primarilySame = null;
        Location p1 = m1.getParent();
        Location p2 = m2.getParent();
        if (p1 instanceof MachineManagementMixins.GivesMachineMetadata || p2 instanceof MachineManagementMixins.GivesMachineMetadata) {
            if (p1 instanceof MachineManagementMixins.GivesMachineMetadata && p2 instanceof MachineManagementMixins.GivesMachineMetadata) {
                String m2id;
                String m1id = ((MachineManagementMixins.GivesMachineMetadata)p1).getMachineMetadata(m1).getId();
                if (Objects.equals(m1id, m2id = ((MachineManagementMixins.GivesMachineMetadata)p2).getMachineMetadata(m2).getId())) {
                    if (m1id != null) {
                        primarilySame = true;
                    }
                } else {
                    primarilySame = false;
                }
            } else {
                primarilySame = false;
            }
        }
        if (Boolean.FALSE.equals(primarilySame)) {
            return false;
        }
        if (requireSameAccessDetails) {
            MutableList reqs = MutableList.of();
            reqs.add(MachineLocation::getUser);
            reqs.add(HasNetworkAddresses::getHostname);
            reqs.add(MachineLocation::getAddress);
            reqs.add(HasNetworkAddresses::getPrivateAddresses);
            reqs.add(HasNetworkAddresses::getPublicAddresses);
            for (Function f : reqs) {
                Object v1 = f.apply(m1);
                if (!Objects.equals(v1, f.apply(m2))) {
                    return false;
                }
                if (!JavaGroovyEquivalents.groovyTruth(v1)) continue;
                primarilySame = true;
            }
        }
        return primarilySame;
    }

    public static interface GivesMachineStatus {
        public MachineStatus getStatus();
    }

    public static enum MachineStatus {
        UNKNOWN,
        RUNNING,
        SHUTDOWN,
        SUSPENDED,
        TRANSITIONING,
        ERROR;

    }
}

