/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.effector.AddEffectorInitializerAbstract;
import org.apache.brooklyn.core.effector.EffectorAndBody;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.WorkflowCommonConfig;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.brooklyn.util.core.config.ConfigBag;

public class WorkflowEffector
extends AddEffectorInitializerAbstract
implements WorkflowCommonConfig {
    private EntityLocal entity;

    public WorkflowEffector() {
    }

    public WorkflowEffector(ConfigBag params) {
        super(params);
    }

    public WorkflowEffector(Map<?, ?> params) {
        this(ConfigBag.newInstance(params));
    }

    protected Effectors.EffectorBuilder<Object> newEffectorBuilder() {
        WorkflowEffectorBuilder eff = new WorkflowEffectorBuilder(this.newAbstractEffectorBuilder(Object.class));
        eff.impl(new WorkflowEffectorBodyFactory((Entity)this.entity, eff.buildAbstract(), this.initParams()));
        return eff;
    }

    @Override
    public void apply(EntityLocal entity) {
        this.entity = entity;
        super.apply(entity);
    }

    public static class WorkflowEffectorBodyFactory
    extends EffectorTasks.EffectorBodyTaskFactory<Object> {
        private final Map<String, Object> definitionParams;

        protected WorkflowEffectorBodyFactory(Entity entity, Effector<?> eff, ConfigBag definitionParams) {
            super(null);
            this.definitionParams = definitionParams.getAllConfigRaw();
            WorkflowStepResolution.validateWorkflowParametersForEffector((BrooklynObject)entity, definitionParams);
        }

        public Map<String, Object> getDefinitionParams() {
            return this.definitionParams;
        }

        @Override
        public Task<Object> newTask(Entity entity, Effector<Object> effector, ConfigBag invocationParams) {
            return this.newSubWorkflowTask(entity, effector, invocationParams, null, null);
        }

        public Task<Object> newSubWorkflowTask(Entity entity, Effector<?> effector, ConfigBag invocationParams, WorkflowExecutionContext parentWorkflow, Consumer<BrooklynTaskTags.WorkflowTaskTag> parentInitializer) {
            WorkflowExecutionContext w = WorkflowExecutionContext.newInstanceUnpersistedWithParent((BrooklynObject)entity, parentWorkflow, WorkflowExecutionContext.WorkflowContextType.EFFECTOR, effector.getName() + " (workflow effector)", ConfigBag.newInstance(this.definitionParams), effector.getParameters().stream().map(Effectors::asConfigKey).collect(Collectors.toSet()), invocationParams, this.getFlagsForTaskInvocationAt(entity, effector, invocationParams), effector.getName());
            Task task = (Task)w.getTask(true).get();
            if (parentInitializer != null) {
                parentInitializer.accept(BrooklynTaskTags.getWorkflowTaskTag(task, false));
            }
            w.persist();
            return task;
        }
    }

    public static class WorkflowEffectorAndBody
    extends EffectorAndBody<Object> {
        protected WorkflowEffectorAndBody(EffectorAndBody<Object> original) {
            super(original, original.getBody());
        }

        public WorkflowEffectorBodyFactory getBody() {
            return (WorkflowEffectorBodyFactory)super.getBody();
        }
    }

    protected static class WorkflowEffectorBuilder
    extends Effectors.EffectorBuilder<Object> {
        protected WorkflowEffectorBuilder(Effectors.EffectorBuilder<Object> original) {
            super(original);
        }

        public WorkflowEffectorAndBody build() {
            return new WorkflowEffectorAndBody((EffectorAndBody)super.build());
        }
    }
}

