/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.chef;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.entity.chef.ChefServerTasks;
import org.apache.brooklyn.entity.chef.KnifeTaskFactory;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.system.ProcessTaskStub;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.StringEscapes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnifeConvergeTaskFactory<RET>
extends KnifeTaskFactory<RET> {
    private static final Logger log = LoggerFactory.getLogger(KnifeConvergeTaskFactory.class);
    protected Function<? super Entity, String> runList;
    protected Map<Object, Object> knifeAttributes = new MutableMap();
    protected List<String> extraBootstrapParameters = MutableList.of();
    protected Boolean sudo;
    protected Boolean runTwice;
    protected String nodeName;
    protected Integer port;
    protected Boolean portOmittedToUseKnifeDefault;

    public KnifeConvergeTaskFactory(String taskName) {
        super(taskName);
    }

    protected KnifeConvergeTaskFactory<RET> self() {
        return this;
    }

    @Override
    protected List<String> initialKnifeParameters() {
        MutableList result = new MutableList();
        SshMachineLocation machine = EffectorTasks.findSshMachine();
        result.add((Object)"bootstrap");
        result.addAll(this.extraBootstrapParameters);
        HostAndPort hostAndPort = machine.getSshHostAndPort();
        result.add((Object)StringEscapes.BashStringEscapes.wrapBash((String)hostAndPort.getHost()));
        Integer whichPort = this.knifeWhichPort(hostAndPort);
        if (whichPort != null) {
            result.add((Object)("-p " + whichPort));
        }
        result.add((Object)("-x " + StringEscapes.BashStringEscapes.wrapBash((String)((String)Preconditions.checkNotNull((Object)machine.getUser(), (Object)"user")))));
        File keyfile = ChefServerTasks.extractKeyFile(machine);
        if (keyfile != null) {
            result.add((Object)("-i " + keyfile.getPath()));
        } else {
            result.add((Object)("-P " + (String)Preconditions.checkNotNull((Object)machine.findPassword(), (Object)("No password or private key data for " + machine))));
        }
        result.add((Object)"--no-host-key-verify");
        if (this.sudo != Boolean.FALSE) {
            result.add((Object)"--sudo");
        }
        if (!Strings.isNullOrEmpty((String)this.nodeName)) {
            result.add((Object)"--node-name");
            result.add((Object)this.nodeName);
        }
        result.add((Object)("-r " + StringEscapes.BashStringEscapes.wrapBash((String)this.runList.apply((Entity)this.entity()))));
        if (!this.knifeAttributes.isEmpty()) {
            result.add((Object)("-j " + StringEscapes.BashStringEscapes.wrapBash((String)new GsonBuilder().create().toJson(this.knifeAttributes))));
        }
        return result;
    }

    public KnifeConvergeTaskFactory<RET> knifeRunTwice(boolean runTwice) {
        this.runTwice = runTwice;
        return this.self();
    }

    public KnifeConvergeTaskFactory<RET> knifeSudo(boolean sudo) {
        this.sudo = sudo;
        return this.self();
    }

    public KnifeConvergeTaskFactory<RET> knifeNodeName(String nodeName) {
        this.nodeName = nodeName;
        return this.self();
    }

    public KnifeConvergeTaskFactory<RET> knifePort(int port) {
        if (this.portOmittedToUseKnifeDefault != null) {
            log.warn("Port " + port + " specified to " + (Object)((Object)this) + " for when already explicitly told to use a default (overriding previous); see subsequent warning for more details");
        }
        this.port = port;
        return this.self();
    }

    public KnifeConvergeTaskFactory<RET> knifePortUseKnifeDefault() {
        if (this.port != null) {
            log.warn("knifePortUseKnifeDefault specified to " + (Object)((Object)this) + " when already told to use " + this.port + " explicitly (overriding previous); see subsequent warning for more details");
            this.port = -1;
        }
        this.portOmittedToUseKnifeDefault = true;
        return this.self();
    }

    public KnifeConvergeTaskFactory<RET> knifePortUseMachineSshPort() {
        if (this.port != null) {
            log.warn("knifePortUseMachineSshPort specified to " + (Object)((Object)this) + " when already told to use " + this.port + " explicitly (overriding previous); see subsequent warning for more details");
            this.port = -1;
        }
        this.portOmittedToUseKnifeDefault = false;
        return this.self();
    }

    protected Integer knifeWhichPort(HostAndPort hostAndPort) {
        if (this.port == null) {
            if (Boolean.TRUE.equals(this.portOmittedToUseKnifeDefault)) {
                return null;
            }
            return hostAndPort.getPort();
        }
        if (this.port == -1) {
            this.port = null;
            Integer whichPort = this.knifeWhichPort(hostAndPort);
            log.warn("knife port conflicting instructions for " + (Object)((Object)this) + " at entity " + this.entity() + " on " + hostAndPort + "; using default (" + whichPort + ")");
            return whichPort;
        }
        if (this.portOmittedToUseKnifeDefault != null) {
            log.warn("knife port conflicting instructions for " + (Object)((Object)this) + " at entity " + this.entity() + " on " + hostAndPort + "; using supplied port " + this.port);
        }
        return this.port;
    }

    public KnifeConvergeTaskFactory<RET> knifeAddExtraBootstrapParameters(String extraBootstrapParameter1, String ... extraBootstrapParameters) {
        this.extraBootstrapParameters.add(extraBootstrapParameter1);
        for (String p : extraBootstrapParameters) {
            this.extraBootstrapParameters.add(p);
        }
        return this.self();
    }

    public KnifeConvergeTaskFactory<RET> knifeRunList(Function<? super Entity, String> runList) {
        this.runList = runList;
        return this.self();
    }

    public KnifeConvergeTaskFactory<RET> knifeRunList(String runList) {
        this.runList = Functions.constant((Object)runList);
        return this.self();
    }

    public KnifeConvergeTaskFactory<RET> knifeAddAttributes(Map<? extends Object, ? extends Object> attributes) {
        if (attributes != null && !attributes.isEmpty()) {
            Jsonya.of(this.knifeAttributes).add(attributes, new Object[0]);
        }
        return this.self();
    }

    @Override
    protected String buildKnifeCommand(int knifeCommandIndex) {
        String result = super.buildKnifeCommand(knifeCommandIndex);
        if (Boolean.TRUE.equals(this.runTwice)) {
            result = BashCommands.alternatives((String[])new String[]{result, result});
        }
        return result;
    }

    @Override
    public <T2> KnifeConvergeTaskFactory<T2> returning(ProcessTaskStub.ScriptReturnType type) {
        return (KnifeConvergeTaskFactory)super.returning(type);
    }

    @Override
    public <RET2> KnifeConvergeTaskFactory<RET2> returning(Function<ProcessTaskWrapper<?>, RET2> resultTransformation) {
        return (KnifeConvergeTaskFactory)super.returning(resultTransformation);
    }

    public KnifeConvergeTaskFactory<Boolean> returningIsExitCodeZero() {
        return (KnifeConvergeTaskFactory)super.returningIsExitCodeZero();
    }

    public KnifeConvergeTaskFactory<String> requiringZeroAndReturningStdout() {
        return (KnifeConvergeTaskFactory)super.requiringZeroAndReturningStdout();
    }

    @Override
    public KnifeConvergeTaskFactory<RET> knifeAddParameters(String word1, String ... words) {
        super.knifeAddParameters(word1, words);
        return this.self();
    }
}

