/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.collections4.list.TreeList;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.collections4.map.ReferenceMap;

public final class GuavaTestlibTest
extends TestCase {
    public static Test suite() {
        TestSuite test = new TestSuite();
        test.addTest(GuavaTestlibTest.suiteMap("HashedMap", HashedMap::new));
        test.addTest(GuavaTestlibTest.suiteMap("LinkedMap", LinkedMap::new));
        test.addTest(GuavaTestlibTest.suiteMap("LRUMap", LRUMap::new));
        test.addTest(GuavaTestlibTest.suiteMap("ReferenceMap", ReferenceMap::new));
        test.addTest(GuavaTestlibTest.suiteList("TreeList", TreeList::new, new Feature[0]));
        return test;
    }

    private static Test suiteList(String name, final Supplier<List<String>> factory, Feature<?> ... features) {
        ListTestSuiteBuilder suite = (ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                List list = (List)factory.get();
                Collections.addAll(list, elements);
                return list;
            }
        }).named(name)).withFeatures(new Feature[]{CollectionSize.ANY, ListFeature.GENERAL_PURPOSE, ListFeature.REMOVE_OPERATIONS, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.DESCENDING_VIEW, CollectionFeature.SUBSET_VIEW});
        suite.withFeatures(features);
        return suite.createTestSuite();
    }

    private static Test suiteMap(String name, final Supplier<Map<String, String>> factory) {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                Map map = (Map)factory.get();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return map;
            }
        }).named(name)).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite();
    }
}

