/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.BitSet;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractIndexExtractorTest {
    private static final IntPredicate TRUE_PREDICATE = i -> true;
    private static final IntPredicate FALSE_PREDICATE = i -> false;
    protected static final int ORDERED = 1;
    protected static final int DISTINCT = 2;

    protected abstract IndexExtractor createEmptyExtractor();

    protected abstract IndexExtractor createExtractor();

    protected abstract int getAsIndexArrayBehaviour();

    protected abstract int[] getExpectedIndices();

    protected int getForEachIndexBehaviour() {
        return this.getAsIndexArrayBehaviour();
    }

    @Test
    public final void testAsIndexArrayValues() {
        BitSet bs = new BitSet();
        Arrays.stream(this.createExtractor().asIndexArray()).forEach(bs::set);
        for (int i : this.getExpectedIndices()) {
            Assertions.assertTrue((boolean)bs.get(i), () -> "Missing " + i);
        }
    }

    @Test
    public final void testBehaviourAsIndexArray() {
        int[] expected;
        int flags = this.getAsIndexArrayBehaviour();
        int[] actual = this.createExtractor().asIndexArray();
        if ((flags & 1) != 0) {
            expected = Arrays.stream(actual).sorted().toArray();
            Assertions.assertArrayEquals((int[])expected, (int[])actual);
        }
        if ((flags & 2) != 0) {
            long count = Arrays.stream(actual).distinct().count();
            Assertions.assertEquals((long)count, (long)actual.length);
        } else {
            expected = (int[])this.getExpectedIndices().clone();
            Arrays.sort(expected);
            Arrays.sort(actual);
            Assertions.assertArrayEquals((int[])expected, (int[])actual);
        }
    }

    @Test
    public final void testBehaviourForEachIndex() {
        int[] expected;
        int flags = this.getForEachIndexBehaviour();
        IntList list = new IntList();
        this.createExtractor().processIndices(list::add);
        int[] actual = list.toArray();
        if ((flags & 1) != 0) {
            expected = Arrays.stream(actual).sorted().toArray();
            Assertions.assertArrayEquals((int[])expected, (int[])actual);
        }
        if ((flags & 2) != 0) {
            long count = Arrays.stream(actual).distinct().count();
            Assertions.assertEquals((long)count, (long)actual.length);
        } else {
            expected = (int[])this.getExpectedIndices().clone();
            Arrays.sort(expected);
            Arrays.sort(actual);
            Assertions.assertArrayEquals((int[])expected, (int[])actual);
        }
    }

    @Test
    public final void testConsistency() {
        IndexExtractor extractor = this.createExtractor();
        BitSet bs1 = new BitSet();
        BitSet bs2 = new BitSet();
        Arrays.stream(extractor.asIndexArray()).forEach(bs1::set);
        extractor.processIndices(i -> {
            bs2.set(i);
            return true;
        });
        Assertions.assertEquals((Object)bs1, (Object)bs2);
    }

    @Test
    public final void testEmptyExtractor() {
        IndexExtractor empty = this.createEmptyExtractor();
        int[] ary = empty.asIndexArray();
        Assertions.assertEquals((int)0, (int)ary.length);
        Assertions.assertTrue((boolean)empty.processIndices(i -> {
            throw new AssertionError((Object)"processIndices predictate should not be called");
        }));
    }

    @Test
    public final void testForEachIndex() {
        BitSet bs1 = new BitSet();
        BitSet bs2 = new BitSet();
        Arrays.stream(this.getExpectedIndices()).forEach(bs1::set);
        this.createExtractor().processIndices(i -> {
            bs2.set(i);
            return true;
        });
        Assertions.assertEquals((Object)bs1, (Object)bs2);
    }

    @Test
    public void testForEachIndexEarlyExit() {
        int[] passes = new int[1];
        Assertions.assertFalse((boolean)this.createExtractor().processIndices(i -> {
            passes[0] = passes[0] + 1;
            return false;
        }));
        Assertions.assertEquals((int)1, (int)passes[0]);
        passes[0] = 0;
        Assertions.assertTrue((boolean)this.createEmptyExtractor().processIndices(i -> {
            passes[0] = passes[0] + 1;
            return false;
        }));
        Assertions.assertEquals((int)0, (int)passes[0]);
    }

    @Test
    public final void testForEachIndexPredicates() {
        IndexExtractor populated = this.createExtractor();
        IndexExtractor empty = this.createEmptyExtractor();
        Assertions.assertFalse((boolean)populated.processIndices(FALSE_PREDICATE), (String)"non-empty should be false");
        Assertions.assertTrue((boolean)empty.processIndices(FALSE_PREDICATE), (String)"empty should be true");
        Assertions.assertTrue((boolean)populated.processIndices(TRUE_PREDICATE), (String)"non-empty should be true");
        Assertions.assertTrue((boolean)empty.processIndices(TRUE_PREDICATE), (String)"empty should be true");
    }

    @Test
    public void testUniqueReturnsSelf() {
        IndexExtractor expected = this.createExtractor().uniqueIndices();
        Assertions.assertSame((Object)expected, (Object)expected.uniqueIndices());
    }

    protected static class IntList {
        private int size;
        private int[] data = new int[]{0};

        protected IntList() {
        }

        boolean add(int value) {
            if (this.size == this.data.length) {
                this.data = Arrays.copyOf(this.data, this.size << 1);
            }
            this.data[this.size++] = value;
            return true;
        }

        int[] toArray() {
            return Arrays.copyOf(this.data, this.size);
        }
    }
}

