/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.reloading;

import java.io.File;
import java.util.Random;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileRandomReloadingStrategy
extends FileChangedReloadingStrategy {
    Random random = new Random();
    private Log logger = LogFactory.getLog(FileRandomReloadingStrategy.class);

    public boolean reloadingRequired() {
        boolean result = this.random.nextBoolean();
        if (result && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("File change detected: " + this.getName()));
        }
        return result;
    }

    public File getMonitoredFile() {
        return this.getFile();
    }

    private String getName() {
        return this.getName(this.getFile());
    }

    private String getName(File file) {
        String name = this.configuration.getURL().toString();
        if (name == null) {
            name = file != null ? file.getAbsolutePath() : "base: " + this.configuration.getBasePath() + "file: " + this.configuration.getFileName();
        }
        return name;
    }
}

