/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * <p>
 * A package with classes related to I/O operations.
 * </p>
 * <p>
 * Most of the interfaces and classes contained in this package are related to file-based configurations. For instance,
 * the basic interfaces for reading and writing data or for managing a reference to a file are defined here. This
 * package also contains various strategy classes for locating files. They can be used to construct a location strategy
 * for the configuration sources of a specific application.
 * </p>
 */
package org.apache.commons.configuration2.io;
