/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.threed.AffineTransformMatrix3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.rotation.QuaternionRotation;
import org.apache.commons.geometry.spherical.twod.Point2S;

public final class Transform2S
implements Transform<Point2S> {
    private static final Transform2S IDENTITY = new Transform2S(AffineTransformMatrix3D.identity());
    private static final AffineTransformMatrix3D XY_PLANE_REFLECTION = AffineTransformMatrix3D.createScale((double)1.0, (double)1.0, (double)-1.0);
    private final AffineTransformMatrix3D euclideanTransform;

    private Transform2S(AffineTransformMatrix3D euclideanTransform) {
        this.euclideanTransform = euclideanTransform;
    }

    public AffineTransformMatrix3D getEuclideanTransform() {
        return this.euclideanTransform;
    }

    public Point2S apply(Point2S pt) {
        Vector3D.Unit vec = pt.getVector();
        return Point2S.from(this.euclideanTransform.apply((Vector3D)vec));
    }

    public boolean preservesOrientation() {
        return this.euclideanTransform.preservesOrientation();
    }

    public Transform2S inverse() {
        return new Transform2S(this.euclideanTransform.inverse());
    }

    public Transform2S rotate(Point2S pt, double angle) {
        return this.premultiply(Transform2S.createRotation(pt, angle));
    }

    public Transform2S rotate(Vector3D axis, double angle) {
        return this.premultiply(Transform2S.createRotation(axis, angle));
    }

    public Transform2S rotate(QuaternionRotation quaternion) {
        return this.premultiply(Transform2S.createRotation(quaternion));
    }

    public Transform2S reflect(Point2S pole) {
        return this.premultiply(Transform2S.createReflection(pole));
    }

    public Transform2S reflect(Vector3D poleVector) {
        return this.premultiply(Transform2S.createReflection(poleVector));
    }

    public Transform2S multiply(Transform2S other) {
        return Transform2S.multiply(this, other);
    }

    public Transform2S premultiply(Transform2S other) {
        return Transform2S.multiply(other, this);
    }

    public int hashCode() {
        return this.euclideanTransform.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Transform2S)) {
            return false;
        }
        Transform2S other = (Transform2S)obj;
        return this.euclideanTransform.equals((Object)other.euclideanTransform);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[euclideanTransform= ").append(this.getEuclideanTransform()).append(']');
        return sb.toString();
    }

    public static Transform2S identity() {
        return IDENTITY;
    }

    public static Transform2S createRotation(Point2S pt, double angle) {
        return Transform2S.createRotation((Vector3D)pt.getVector(), angle);
    }

    public static Transform2S createRotation(Vector3D axis, double angle) {
        return Transform2S.createRotation(QuaternionRotation.fromAxisAngle((Vector3D)axis, (double)angle));
    }

    public static Transform2S createRotation(QuaternionRotation quaternion) {
        return new Transform2S(quaternion.toMatrix());
    }

    public static Transform2S createReflection(Point2S pole) {
        return Transform2S.createReflection((Vector3D)pole.getVector());
    }

    public static Transform2S createReflection(Vector3D poleVector) {
        QuaternionRotation quat = QuaternionRotation.createVectorRotation((Vector3D)poleVector, (Vector3D)Vector3D.Unit.PLUS_Z);
        AffineTransformMatrix3D matrix = quat.toMatrix().premultiply(XY_PLANE_REFLECTION).premultiply(quat.inverse().toMatrix());
        return new Transform2S(matrix);
    }

    private static Transform2S multiply(Transform2S a, Transform2S b) {
        return new Transform2S(a.euclideanTransform.multiply(b.euclideanTransform));
    }
}

