/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod.rotation;

import org.apache.commons.geometry.euclidean.EuclideanTransform;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.geometry.euclidean.twod.AffineTransformMatrix2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

public final class Rotation2D
implements EuclideanTransform<Vector2D> {
    private static final Rotation2D IDENTITY = new Rotation2D(0.0);
    private final double angle;
    private final double cosAngle;
    private final double sinAngle;

    private Rotation2D(double angle) {
        this.angle = angle;
        this.cosAngle = Math.cos(angle);
        this.sinAngle = Math.sin(angle);
    }

    public double getAngle() {
        return this.angle;
    }

    public Rotation2D inverse() {
        return new Rotation2D(-this.angle);
    }

    public boolean preservesOrientation() {
        return true;
    }

    public Vector2D apply(Vector2D pt) {
        double x = pt.getX();
        double y = pt.getY();
        return Vector2D.of(x * this.cosAngle - y * this.sinAngle, x * this.sinAngle + y * this.cosAngle);
    }

    @Override
    public Vector2D applyVector(Vector2D vec) {
        return this.apply(vec);
    }

    public AffineTransformMatrix2D toMatrix() {
        return AffineTransformMatrix2D.of(this.cosAngle, -this.sinAngle, 0.0, this.sinAngle, this.cosAngle, 0.0);
    }

    public int hashCode() {
        return Double.hashCode(this.angle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rotation2D)) {
            return false;
        }
        Rotation2D other = (Rotation2D)obj;
        return Double.compare(this.angle, other.angle) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[angle=").append(this.angle).append(']');
        return sb.toString();
    }

    public static Rotation2D of(double angle) {
        return new Rotation2D(angle);
    }

    public static Rotation2D identity() {
        return IDENTITY;
    }

    public static Rotation2D createVectorRotation(Vector2D u, Vector2D v) {
        Vectors.checkedNorm(u);
        Vectors.checkedNorm(v);
        double uAzimuth = Math.atan2(u.getY(), u.getX());
        double vAzimuth = Math.atan2(v.getY(), v.getX());
        return Rotation2D.of(vAzimuth - uAzimuth);
    }
}

