/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.openjpa;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.apache.commons.jcs3.jcache.openjpa.OpenJPAJCacheDataCacheManager;
import org.apache.openjpa.datacache.AbstractQueryCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.QueryResult;

public class OpenJPAJCacheQueryCache
extends AbstractQueryCache {
    private static final String OPENJPA_PREFIX = "openjpa.querycache.";
    private static final String QUERY_CACHE_NAME = "query";
    private final Lock lock = new ReentrantLock();
    private OpenJPAJCacheDataCacheManager manager;

    public void initialize(DataCacheManager manager) {
        super.initialize(manager);
        this.manager = (OpenJPAJCacheDataCacheManager)((Object)OpenJPAJCacheDataCacheManager.class.cast(manager));
    }

    protected void clearInternal() {
        CacheManager cacheManager = this.manager.getCacheManager();
        for (String cacheName : cacheManager.getCacheNames()) {
            if (!cacheName.startsWith(OPENJPA_PREFIX)) continue;
            cacheManager.getCache(cacheName).clear();
        }
    }

    protected Collection keySet() {
        LinkedList<QueryKey> keys = new LinkedList<QueryKey>();
        for (Cache.Entry entry : this.queryCache()) {
            keys.add((QueryKey)QueryKey.class.cast(entry.getKey()));
        }
        return keys;
    }

    protected QueryResult getInternal(QueryKey qk) {
        return (QueryResult)QueryResult.class.cast(this.queryCache().get((Object)qk));
    }

    private Cache<Object, Object> queryCache() {
        return this.manager.getOrCreateCache(OPENJPA_PREFIX, QUERY_CACHE_NAME);
    }

    protected QueryResult putInternal(QueryKey qk, QueryResult oids) {
        this.queryCache().put((Object)qk, (Object)oids);
        return oids;
    }

    protected QueryResult removeInternal(QueryKey qk) {
        Object remove = this.queryCache().getAndRemove((Object)qk);
        if (remove == null) {
            return null;
        }
        return (QueryResult)QueryResult.class.cast(remove);
    }

    protected boolean pinInternal(QueryKey qk) {
        throw new UnsupportedOperationException();
    }

    protected boolean unpinInternal(QueryKey qk) {
        throw new UnsupportedOperationException();
    }

    public void writeLock() {
        this.lock.lock();
    }

    public void writeUnlock() {
        this.lock.unlock();
    }
}

