/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.jexl342;

import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.jexl342.ReferenceUberspect;

public class ReferenceMethodExecutor
implements JexlMethod {
    private final ReferenceUberspect.ReferenceHandler handler;
    private final JexlMethod method;

    public ReferenceMethodExecutor(ReferenceUberspect.ReferenceHandler referenceHandler, JexlMethod jexlMethod) {
        if (referenceHandler == null || jexlMethod == null) {
            throw new IllegalArgumentException("handler and method cant be null");
        }
        this.method = jexlMethod;
        this.handler = referenceHandler;
    }

    protected Object getReference(Object opt) {
        return this.handler.callGet(opt);
    }

    public Object invoke(Object ref, Object ... args) throws Exception {
        Object obj = this.getReference(ref);
        return obj == null ? null : this.method.invoke(obj, args);
    }

    public Object tryInvoke(String name, Object ref, Object ... args) throws JexlException.TryFailed {
        Object obj = this.getReference(ref);
        if (this.method == null) {
            return obj == null ? null : JexlEngine.TRY_FAILED;
        }
        if (obj == ref) {
            return JexlEngine.TRY_FAILED;
        }
        return this.method.tryInvoke(name, obj, args);
    }

    public boolean tryFailed(Object rval) {
        return this.method == null || this.method.tryFailed(rval);
    }

    public boolean isCacheable() {
        return this.method != null && this.method.isCacheable();
    }

    public Class<?> getReturnType() {
        return this.method != null ? this.method.getReturnType() : null;
    }
}

