/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.generation.GeneratedLicenseNotRequired;
import org.apache.rat.analysis.generation.JavaDocLicenseNotRequired;
import org.apache.rat.analysis.license.ApacheSoftwareLicense20;
import org.apache.rat.analysis.license.CDDL1License;
import org.apache.rat.analysis.license.DojoLicenseHeader;
import org.apache.rat.analysis.license.GPL1License;
import org.apache.rat.analysis.license.GPL2License;
import org.apache.rat.analysis.license.GPL3License;
import org.apache.rat.analysis.license.MITLicense;
import org.apache.rat.analysis.license.OASISLicense;
import org.apache.rat.analysis.license.TMF854LicenseHeader;
import org.apache.rat.analysis.license.W3CDocLicense;
import org.apache.rat.analysis.license.W3CLicense;
import org.apache.rat.analysis.util.HeaderMatcherMultiplexer;

public class Defaults {
    public static final List<IHeaderMatcher> DEFAULT_MATCHERS = Collections.unmodifiableList(Arrays.asList(new ApacheSoftwareLicense20(), new GPL1License(), new GPL2License(), new GPL3License(), new MITLicense(), new W3CLicense(), new W3CDocLicense(), new OASISLicense(), new JavaDocLicenseNotRequired(), new GeneratedLicenseNotRequired(), new DojoLicenseHeader(), new TMF854LicenseHeader(), new CDDL1License()));
    public static final List<String> DEFAULT_LICENSE_FAMILIES = Collections.unmodifiableList(Arrays.asList("Academic Free License, Version 2.1", "Apache License Version 2.0", "COMMON DEVELOPMENT AND DISTRIBUTION LICENSE Version 1.0", "GNU General Public License, version 1", "GNU General Public License, version 2", "GNU General Public License, version 3", "The MIT License", "Modified BSD License", "OASIS Open License", "W3C Document Copyright", "W3C Software Copyright"));
    public static final String PLAIN_STYLESHEET = "org/apache/rat/plain-rat.xsl";
    public static final String UNAPPROVED_LICENSES_STYLESHEET = "org/apache/rat/unapproved-licenses.xsl";

    private Defaults() {
    }

    public static InputStream getPlainStyleSheet() {
        return Defaults.class.getClassLoader().getResourceAsStream(PLAIN_STYLESHEET);
    }

    public static InputStream getUnapprovedLicensesStyleSheet() {
        return Defaults.class.getClassLoader().getResourceAsStream(UNAPPROVED_LICENSES_STYLESHEET);
    }

    public static InputStream getDefaultStyleSheet() {
        return Defaults.getPlainStyleSheet();
    }

    public static IHeaderMatcher createDefaultMatcher() {
        return new HeaderMatcherMultiplexer(DEFAULT_MATCHERS);
    }
}

