/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.attributes.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.assertion.attributes.generic.GenericAttributeClassifier;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class GenericFeaturesExtractor
implements FeatureExtractor1<IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        ConllDependencyNode node = DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg);
        if (node != null) {
            features.add(new Feature("DEPENDENCY_HEAD", (Object)node.getCoveredText()));
            features.add(new Feature("DEPENDENCY_HEAD_deprel", (Object)node.getDeprel()));
        }
        HashMap<String, Boolean> featsMap = GenericAttributeClassifier.extract(jCas, (Annotation)arg);
        features.addAll(GenericFeaturesExtractor.hashToFeatureList(featsMap));
        features.add(new Feature("GENERIC_CLASSIFIER_LOGIC", (Object)GenericAttributeClassifier.classifyWithLogic(featsMap)));
        return features;
    }

    private static Collection<? extends Feature> hashToFeatureList(HashMap<String, Boolean> featsIn) {
        HashSet<Feature> featsOut = new HashSet<Feature>();
        for (String featName : featsIn.keySet()) {
            featsOut.add(new Feature(featName, (Object)featsIn.get(featName)));
        }
        return featsOut;
    }
}

