/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class ContextWordWindowExtractor
implements FeatureExtractor1<IdentifiedAnnotation> {
    private HashMap<String, Double> termVals = new HashMap();
    private static final Pattern linePatt = Pattern.compile("^([^ ]+) : (.+)$");
    private static double[] weights = new double[50];

    public ContextWordWindowExtractor(String resourceFilename) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceFilename);
        Scanner scanner = new Scanner(is);
        Matcher m = null;
        double max = 0.0;
        double maxNeg = 0.0;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            m = linePatt.matcher(line);
            if (!m.matches()) continue;
            double val = Double.parseDouble(m.group(2));
            this.termVals.put(m.group(1), val);
            if (Math.abs(val) > max) {
                max = Math.abs(val);
            }
            if (!(val < maxNeg)) continue;
            maxNeg = val;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        max -= maxNeg;
        for (String key : this.termVals.keySet()) {
            this.termVals.put(key, (this.termVals.get(key) - maxNeg) / max);
        }
    }

    public List<Feature> extract(JCas view, IdentifiedAnnotation mention) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        List sents = JCasUtil.selectCovering((JCas)view, Sentence.class, (int)mention.getBegin(), (int)mention.getEnd());
        if (sents.size() == 0) {
            return feats;
        }
        Sentence sent = (Sentence)sents.get(0);
        List tokens = JCasUtil.selectCovered(BaseToken.class, (AnnotationFS)sent);
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            if (((BaseToken)tokens.get(i)).getBegin() == mention.getBegin()) {
                startIndex = i;
            }
            if (((BaseToken)tokens.get(i)).getEnd() != mention.getEnd()) continue;
            endIndex = i;
        }
        double score = 0.0;
        double z = 0.0;
        String key = null;
        for (int i = 0; i < tokens.size(); ++i) {
            key = ((BaseToken)tokens.get(i)).getCoveredText().toLowerCase();
            int dist = Math.min(Math.abs(startIndex - i), Math.abs(endIndex - i));
            double weight = ContextWordWindowExtractor.weightFunction(dist);
            z += weight;
            if (!this.termVals.containsKey(key)) continue;
            score += weight * this.termVals.get(key);
        }
        feats.add(new Feature("WORD_SCORE", (Object)(score /= z)));
        return feats;
    }

    private static final double weightFunction(int dist) {
        if (dist >= weights.length) {
            return 0.0;
        }
        return 1.0;
    }

    static {
        ContextWordWindowExtractor.weights[0] = 1.0;
        for (int i = 1; i < weights.length; ++i) {
            ContextWordWindowExtractor.weights[i] = 1.0 / (double)i;
        }
    }
}

