/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.ctakes.gui.component.DisablerPane;
import org.apache.ctakes.gui.component.FileChooserPanel;
import org.apache.ctakes.gui.component.LoggerPanel;
import org.apache.ctakes.gui.component.PositionedSplitPane;
import org.apache.ctakes.gui.dictionary.DictionaryBuilder;
import org.apache.ctakes.gui.dictionary.umls.MrconsoIndex;
import org.apache.ctakes.gui.dictionary.umls.SourceTableModel;
import org.apache.ctakes.gui.dictionary.umls.Tui;
import org.apache.ctakes.gui.dictionary.umls.TuiTableModel;
import org.apache.ctakes.gui.dictionary.util.FileUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

final class MainPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger((String)"MainPanel");
    private String _umlsDirPath = System.getProperty("user.dir");
    private String _ctakesPath = System.getProperty("user.dir");
    private final TuiTableModel _tuiModel = new TuiTableModel();
    private final SourceTableModel _sourceModel = new SourceTableModel();

    MainPanel() {
        super(new BorderLayout());
        JPanel sourceDirPanel = new JPanel(new GridLayout(2, 1));
        sourceDirPanel.add(new FileChooserPanel("cTAKES Installation:", this._ctakesPath, true, new CtakesDirListener()));
        sourceDirPanel.add(new FileChooserPanel("UMLS Installation:", this._umlsDirPath, true, new UmlsDirListener()));
        this.add((Component)sourceDirPanel, "North");
        this.add((Component)this.createCenterPanel(this._sourceModel, this._tuiModel), "Center");
    }

    private JComponent createCenterPanel(TableModel sourceModel, TableModel tuiModel) {
        PositionedSplitPane centerSplit = new PositionedSplitPane();
        centerSplit.setLeftComponent(MainPanel.createSourceTable(sourceModel));
        centerSplit.setRightComponent(MainPanel.createTuiTable(tuiModel));
        ((JSplitPane)centerSplit).setDividerLocation(0.5);
        JPanel umlsPanel = new JPanel(new BorderLayout());
        umlsPanel.add((Component)centerSplit, "Center");
        umlsPanel.add((Component)this.createGoPanel(), "South");
        PositionedSplitPane logSplit = new PositionedSplitPane(0);
        logSplit.setTopComponent(umlsPanel);
        logSplit.setBottomComponent(LoggerPanel.createLoggerPanel(new Level[0]));
        ((JSplitPane)logSplit).setDividerLocation(0.6);
        return logSplit;
    }

    private static JComponent createTuiTable(TableModel tuiModel) {
        JTable tuiTable = new JTable(tuiModel);
        tuiTable.setCellSelectionEnabled(false);
        tuiTable.setShowVerticalLines(false);
        tuiTable.setAutoCreateRowSorter(true);
        tuiTable.setAutoResizeMode(3);
        tuiTable.getColumnModel().getColumn(0).setMaxWidth(50);
        tuiTable.getColumnModel().getColumn(1).setMaxWidth(50);
        return new JScrollPane(tuiTable);
    }

    private static JComponent createSourceTable(TableModel sourceModel) {
        JTable tuiTable = new JTable(sourceModel);
        tuiTable.setCellSelectionEnabled(false);
        tuiTable.setShowVerticalLines(false);
        tuiTable.setAutoCreateRowSorter(true);
        tuiTable.setAutoResizeMode(3);
        tuiTable.getColumnModel().getColumn(0).setMaxWidth(50);
        tuiTable.getColumnModel().getColumn(1).setMaxWidth(50);
        return new JScrollPane(tuiTable);
    }

    private JComponent createGoPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(new EmptyBorder(2, 10, 2, 10));
        JLabel label = new JLabel("Dictionary Name:");
        label.setPreferredSize(new Dimension(100, 0));
        label.setHorizontalAlignment(11);
        JTextField textField = new JTextField("custom");
        JButton buildButton = new JButton(new BuildDictionaryAction(textField));
        panel.add((Component)label, "West");
        panel.add((Component)textField, "Center");
        panel.add((Component)buildButton, "East");
        return panel;
    }

    private String setUmlsDirPath(String umlsDirPath) {
        File mrConso = new File(umlsDirPath, "MRCONSO.RRF");
        if (mrConso.isFile()) {
            this._umlsDirPath = mrConso.getParentFile().getParent();
        } else {
            String plusMetaPath = new File(umlsDirPath, "META").getPath();
            mrConso = new File(plusMetaPath, "MRCONSO.RRF");
            if (mrConso.isFile()) {
                this._umlsDirPath = umlsDirPath;
            } else {
                this.error("Invalid UMLS Installation", umlsDirPath + " is not a valid path to a UMLS installation");
            }
        }
        return this._umlsDirPath;
    }

    private void loadSources() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new SourceLoadRunner(this._umlsDirPath));
    }

    private void buildDictionary(String dictionaryName) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new DictionaryBuildRunner(this._umlsDirPath, this._ctakesPath, dictionaryName, this._sourceModel.getWantedSources(), this._sourceModel.getWantedTargets(), this._tuiModel.getWantedTuis()));
    }

    private void error(String title, String message) {
        LOGGER.error((Object)message);
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private class BuildDictionaryAction
    extends AbstractAction {
        private final JTextComponent __textComponent;

        private BuildDictionaryAction(JTextComponent textComponent) {
            super("Build Dictionary");
            this.__textComponent = textComponent;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MainPanel.this._sourceModel.getRowCount() == 0) {
                MainPanel.this.error("UMLS not yet loaded", "Please specify a UMLS installation.");
                return;
            }
            String dictionaryName = this.__textComponent.getText();
            if (dictionaryName != null && !dictionaryName.isEmpty()) {
                MainPanel.this.buildDictionary(dictionaryName.toLowerCase());
            } else {
                MainPanel.this.error("Invalid Dictionary Name", "Please Specify a Dictionary Name");
            }
        }
    }

    private class CtakesDirListener
    implements ActionListener {
        private CtakesDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainPanel.this._ctakesPath = event.getActionCommand();
        }
    }

    private class UmlsDirListener
    implements ActionListener {
        private UmlsDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String newPath;
            String oldPath = MainPanel.this._umlsDirPath;
            if (!oldPath.equals(newPath = MainPanel.this.setUmlsDirPath(event.getActionCommand()))) {
                MainPanel.this.loadSources();
            }
        }
    }

    private class DictionaryBuildRunner
    implements Runnable {
        private final String __umlsDirPath;
        private final String __ctakesDirPath;
        private final String __dictionaryName;
        private final Collection<String> __wantedSources;
        private final Collection<String> __wantedTargets;
        private final Collection<Tui> __wantedTuis;

        private DictionaryBuildRunner(String umlsDirPath, String ctakesDirPath, String dictionaryName, Collection<String> wantedSources, Collection<String> wantedTargets, Collection<Tui> wantedTuis) {
            this.__umlsDirPath = umlsDirPath;
            this.__ctakesDirPath = ctakesDirPath;
            this.__dictionaryName = dictionaryName;
            this.__wantedSources = wantedSources;
            this.__wantedTargets = new ArrayList<String>(wantedTargets);
            this.__wantedTuis = new ArrayList<Tui>(wantedTuis);
        }

        @Override
        public void run() {
            SwingUtilities.getRoot(MainPanel.this).setCursor(Cursor.getPredefinedCursor(3));
            DisablerPane.getInstance().setVisible(true);
            if (DictionaryBuilder.buildDictionary(this.__umlsDirPath, this.__ctakesDirPath, this.__dictionaryName, Collections.singletonList("ENG"), this.__wantedSources, this.__wantedTargets, this.__wantedTuis)) {
                String message = "Dictionary " + this.__dictionaryName + " successfully built in " + this.__ctakesDirPath;
                LOGGER.info((Object)message);
                JOptionPane.showMessageDialog(MainPanel.this, message, "Dictionary Built", 1);
            } else {
                MainPanel.this.error("Build Failure", "Dictionary " + this.__dictionaryName + " could not be built in " + this.__ctakesDirPath);
            }
            DisablerPane.getInstance().setVisible(false);
            SwingUtilities.getRoot(MainPanel.this).setCursor(Cursor.getDefaultCursor());
        }
    }

    private class SourceLoadRunner
    implements Runnable {
        private final String __umlsDirPath;

        private SourceLoadRunner(String umlsDirPath) {
            this.__umlsDirPath = umlsDirPath;
        }

        @Override
        public void run() {
            JFrame frame = (JFrame)SwingUtilities.getRoot(MainPanel.this);
            frame.setCursor(Cursor.getPredefinedCursor(3));
            DisablerPane.getInstance().setVisible(true);
            File mrConso = new File(this.__umlsDirPath + "/META", "MRCONSO.RRF");
            String mrConsoPath = mrConso.getPath();
            LOGGER.info((Object)("Parsing vocabulary types from " + mrConsoPath));
            HashSet<String> sources = new HashSet<String>();
            try (BufferedReader reader = FileUtil.createReader(mrConsoPath);){
                int lineCount = 0;
                List<String> tokens = FileUtil.readBsvTokens(reader, mrConsoPath);
                while (tokens != null) {
                    ++lineCount;
                    if (tokens.size() > MrconsoIndex.SOURCE._index) {
                        sources.add(tokens.get(MrconsoIndex.SOURCE._index));
                    }
                    if (lineCount % 100000 == 0) {
                        LOGGER.info((Object)("File Line " + lineCount + "\t Vocabularies " + sources.size()));
                    }
                    tokens = FileUtil.readBsvTokens(reader, mrConsoPath);
                }
                LOGGER.info((Object)("Parsed " + sources.size() + " vocabulary types"));
                MainPanel.this._sourceModel.setSources(sources);
            }
            catch (IOException ioE) {
                MainPanel.this.error("Vocabulary Parse Error", ioE.getMessage());
            }
            DisablerPane.getInstance().setVisible(false);
            frame.setCursor(Cursor.getDefaultCursor());
        }
    }
}

