/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.umls;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ctakes.gui.dictionary.umls.Concept;
import org.apache.ctakes.gui.dictionary.umls.MrconsoParser;
import org.apache.ctakes.gui.dictionary.umls.MrstyParser;
import org.apache.ctakes.gui.dictionary.umls.Tui;
import org.apache.log4j.Logger;

public final class ConceptMapFactory {
    private static final Logger LOGGER = Logger.getLogger((String)"ConceptMapFactory");

    private ConceptMapFactory() {
    }

    public static Map<Long, Concept> createInitialConceptMap(String umlsDirPath, Collection<String> wantedSources, Collection<Tui> wantedTuis) {
        if (wantedSources.isEmpty()) {
            LOGGER.warn((Object)"No source vocabularies specified");
            return Collections.emptyMap();
        }
        if (wantedTuis.isEmpty()) {
            LOGGER.warn((Object)"No TUIs specified");
            return Collections.emptyMap();
        }
        Map<Long, Concept> concepts = MrstyParser.createConceptsForTuis(umlsDirPath, wantedTuis);
        Collection<Long> validVocabularyCuis = MrconsoParser.getValidVocabularyCuis(umlsDirPath, wantedSources);
        concepts.keySet().retainAll(validVocabularyCuis);
        LOGGER.info((Object)("Total Valid Cuis " + concepts.size() + "\t from wanted Tuis and Vocabularies"));
        return concepts;
    }
}

