/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.umls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public final class SourceTableModel
implements TableModel {
    private static final Logger LOGGER = Logger.getLogger((String)"SourceTableModel");
    private static final String[] COLUMN_NAMES = new String[]{"Source", "Target", "Vocabulary"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, Boolean.class, String.class};
    private static final String[] CTAKES_SOURCES = new String[]{"SNOMEDCT_US", "RXNORM"};
    private final EventListenerList _listenerList = new EventListenerList();
    private final Collection<String> _wantedSources = new HashSet<String>();
    private final Collection<String> _wantedTargets = new HashSet<String>();
    private final List<String> _sources = new ArrayList<String>();

    public void setSources(Collection<String> sources) {
        this._sources.clear();
        this._wantedSources.clear();
        this._wantedTargets.clear();
        this._sources.addAll(sources);
        Collections.sort(this._sources);
        this._wantedSources.addAll(Arrays.asList(CTAKES_SOURCES));
        this._wantedTargets.addAll(Arrays.asList(CTAKES_SOURCES));
        this.fireTableChanged(new TableModelEvent(this));
    }

    public Collection<String> getWantedSources() {
        return this._wantedSources;
    }

    public Collection<String> getWantedTargets() {
        return this._wantedTargets;
    }

    @Override
    public int getRowCount() {
        return this._sources.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 || columnIndex == 1 && (Boolean)this.getValueAt(rowIndex, 0) != false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String source = this._sources.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.isSourceEnabled(source);
            }
            case 1: {
                return this.isTargetEnabled(source);
            }
            case 2: {
                return source;
            }
        }
        return "ERROR";
    }

    private boolean isSourceEnabled(String source) {
        return this._wantedSources.contains(source);
    }

    private boolean isTargetEnabled(String source) {
        return this._wantedTargets.contains(source);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Boolean) {
            String source = this._sources.get(rowIndex);
            if (columnIndex == 0) {
                this.selectWantedSource(source, (Boolean)aValue);
            } else if (columnIndex == 1) {
                this.selectWantedTarget(source, (Boolean)aValue);
            }
        }
    }

    private void selectWantedSource(String source, boolean select) {
        if (select) {
            this._wantedSources.add(source);
        } else {
            this._wantedSources.remove(source);
        }
    }

    private void selectWantedTarget(String target, boolean select) {
        if (select) {
            this._wantedTargets.add(target);
        } else {
            this._wantedTargets.remove(target);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this._listenerList.add(TableModelListener.class, listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this._listenerList.remove(TableModelListener.class, listener);
    }

    private void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }
}

