/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ctakes.gui.dictionary.umls.Concept;
import org.apache.ctakes.gui.dictionary.umls.Tui;
import org.apache.ctakes.gui.dictionary.umls.VocabularyStore;
import org.apache.ctakes.gui.dictionary.util.JdbcUtil;
import org.apache.ctakes.gui.dictionary.util.RareWordUtil;
import org.apache.log4j.Logger;

public final class RareWordDbWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"RareWordDbWriter");

    private RareWordDbWriter() {
    }

    public static boolean writeConcepts(Connection connection, Map<Long, Concept> concepts) {
        Map<String, Long> tokenCounts = RareWordUtil.getTokenCounts(concepts.values());
        String mainTableSql = JdbcUtil.createRowInsertSql("CUI_TERMS", CuiTermsField.values());
        String tuiTableSql = JdbcUtil.createCodeInsertSql("TUI");
        String preftermTableSql = JdbcUtil.createCodeInsertSql("PREFTERM");
        Map<String, String> insertCodeSqls = RareWordDbWriter.createCodeInsertSqls();
        long mainTableCount = 0L;
        long tuiTableCount = 0L;
        long preftermTableCount = 0L;
        Map<String, Long> codeTableCounts = RareWordDbWriter.createCodeCounts();
        try {
            PreparedStatement mainTableStatement = connection.prepareStatement(mainTableSql);
            PreparedStatement tuiStatement = connection.prepareStatement(tuiTableSql);
            PreparedStatement preftermStatement = connection.prepareStatement(preftermTableSql);
            Map<String, PreparedStatement> codeStatements = RareWordDbWriter.createCodeStatements(connection, insertCodeSqls);
            for (Map.Entry<Long, Concept> conceptEntry : concepts.entrySet()) {
                long cui = conceptEntry.getKey();
                Concept concept = conceptEntry.getValue();
                boolean conceptOk = false;
                for (String text : conceptEntry.getValue().getTexts()) {
                    RareWordUtil.IndexedRareWord indexedRareWord;
                    if (text.length() >= 255 || RareWordUtil.NULL_RARE_WORD.equals(indexedRareWord = RareWordUtil.getIndexedRareWord(text, tokenCounts))) continue;
                    conceptOk = true;
                    mainTableStatement.setLong(CuiTermsField.CUI.__index, cui);
                    mainTableStatement.setInt(CuiTermsField.RINDEX.__index, indexedRareWord.__index);
                    mainTableStatement.setInt(CuiTermsField.TCOUNT.__index, indexedRareWord.__tokenCount);
                    mainTableStatement.setString(CuiTermsField.TEXT.__index, text);
                    mainTableStatement.setString(CuiTermsField.RWORD.__index, indexedRareWord.__word);
                    mainTableStatement.executeUpdate();
                    mainTableCount = RareWordDbWriter.incrementCount("Main", mainTableCount);
                }
                if (!conceptOk) continue;
                for (Tui tui : concept.getTuis()) {
                    tuiStatement.setLong(CuiTermsField.CUI.__index, cui);
                    tuiStatement.setInt(2, tui.getIntValue());
                    tuiStatement.executeUpdate();
                    tuiTableCount = RareWordDbWriter.incrementCount("Tui", tuiTableCount);
                }
                String preferredText = concept.getPreferredText();
                if (preferredText != null && !preferredText.isEmpty() && !preferredText.equals("Unknown Preferred Term")) {
                    preftermStatement.setLong(CuiTermsField.CUI.__index, cui);
                    if (preferredText.length() > 511) {
                        preferredText = preferredText.substring(0, 510);
                    }
                    preftermStatement.setString(2, preferredText);
                    preftermStatement.executeUpdate();
                    preftermTableCount = RareWordDbWriter.incrementCount("Preferred Term", preftermTableCount);
                }
                Collection<String> vocabularies = concept.getVocabularies();
                for (String vocabulary : vocabularies) {
                    PreparedStatement statement = codeStatements.get(vocabulary);
                    statement.setLong(CuiTermsField.CUI.__index, cui);
                    for (String code : concept.getCodes(vocabulary)) {
                        RareWordDbWriter.setCodeAppropriately(statement, code, VocabularyStore.getInstance().getVocabularyClass(vocabulary));
                        statement.executeUpdate();
                        codeTableCounts.put(vocabulary, RareWordDbWriter.incrementCount(vocabulary, codeTableCounts.get(vocabulary)));
                    }
                }
            }
            connection.commit();
            mainTableStatement.close();
            tuiStatement.close();
            preftermStatement.close();
            preftermStatement.close();
            for (PreparedStatement codeStatement : codeStatements.values()) {
                codeStatement.close();
            }
            Statement setBinaryStatement = connection.createStatement();
            setBinaryStatement.close();
            connection.commit();
            Statement shutdownStatement = connection.createStatement();
            shutdownStatement.execute("SHUTDOWN");
            shutdownStatement.close();
            connection.commit();
            connection.close();
        }
        catch (SQLException sqlE) {
            LOGGER.error((Object)sqlE.getMessage());
            return false;
        }
        LOGGER.info((Object)("Main Table Rows " + mainTableCount));
        LOGGER.info((Object)("Tui Table Rows " + tuiTableCount));
        LOGGER.info((Object)("Preferred Term Table Rows " + preftermTableCount));
        Function<String, String> vocabCount = v -> v + " Table Rows " + codeTableCounts.get(v);
        VocabularyStore.getInstance().getAllVocabularies().stream().map(vocabCount).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        return true;
    }

    private static Map<String, String> createCodeInsertSqls() {
        return VocabularyStore.getInstance().getAllVocabularies().stream().collect(Collectors.toMap(Function.identity(), JdbcUtil::createCodeInsertSql));
    }

    private static Map<String, PreparedStatement> createCodeStatements(Connection connection, Map<String, String> insertCodeSqls) throws SQLException {
        HashMap<String, PreparedStatement> codeStatements = new HashMap<String, PreparedStatement>(insertCodeSqls.size());
        for (Map.Entry<String, String> codeSql : insertCodeSqls.entrySet()) {
            codeStatements.put(codeSql.getKey(), connection.prepareStatement(codeSql.getValue()));
        }
        return codeStatements;
    }

    private static Map<String, Long> createCodeCounts() {
        return VocabularyStore.getInstance().getAllVocabularies().stream().collect(Collectors.toMap(Function.identity(), v -> 0L));
    }

    private static void setCodeAppropriately(PreparedStatement statement, String code, Class<?> type) throws SQLException {
        if (String.class.equals(type)) {
            statement.setString(2, code);
        } else if (Double.class.equals(type)) {
            statement.setDouble(2, Double.valueOf(code));
        } else if (Long.class.equals(type)) {
            statement.setLong(2, Long.valueOf(code));
        } else if (Integer.class.equals(type)) {
            statement.setInt(2, Integer.valueOf(code));
        } else {
            LOGGER.error((Object)("Could not set code for " + type.getName()));
            statement.setString(2, code);
        }
    }

    private static long incrementCount(String name, long count) {
        if (++count % 100000L == 0L) {
            LOGGER.info((Object)(name + " Table Rows " + count));
        }
        return count;
    }

    private static enum CuiTermsField {
        CUI(1, Long.class),
        RINDEX(2, Integer.class),
        TCOUNT(3, Integer.class),
        TEXT(4, String.class),
        RWORD(5, String.class);

        private final int __index;
        private final Class __classType;

        private CuiTermsField(int index, Class classType) {
            this.__index = index;
            this.__classType = classType;
        }
    }
}

