/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="Location of Annotator", description="Annotates Location Of relations.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.LOCATION_RELATION})
public class LocationOfRelationExtractorAnnotator
extends RelationExtractorAnnotator {
    @Override
    protected Class<? extends BinaryTextRelation> getRelationClass() {
        return LocationOfTextRelation.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        List events = JCasUtil.selectCovered((JCas)identifiedAnnotationView, EventMention.class, (AnnotationFS)sentence);
        List sites = JCasUtil.selectCovered((JCas)identifiedAnnotationView, AnatomicalSiteMention.class, (AnnotationFS)sentence);
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        if (RelationExtractorEvaluation.expandEvent) {
            Map coveredMap = JCasUtil.indexCovered((JCas)identifiedAnnotationView, EventMention.class, EventMention.class);
            ArrayList eventList = new ArrayList();
            for (EventMention event : events) {
                eventList.addAll((Collection)coveredMap.get(event));
                for (IdentifiedAnnotation covEvent : eventList) {
                    for (AnatomicalSiteMention site : sites) {
                        if (LocationOfRelationExtractorAnnotator.hasOverlap((Annotation)covEvent, (Annotation)site)) continue;
                        pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair(covEvent, (IdentifiedAnnotation)site));
                    }
                }
                eventList.clear();
                for (AnatomicalSiteMention site : sites) {
                    pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)event, (IdentifiedAnnotation)site));
                }
            }
        } else {
            for (EventMention event : events) {
                for (AnatomicalSiteMention site : sites) {
                    pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)event, (IdentifiedAnnotation)site));
                }
            }
        }
        return pairs;
    }

    private static boolean hasOverlap(Annotation event1, Annotation event2) {
        if (event1.getEnd() >= event2.getBegin() && event1.getEnd() <= event2.getEnd()) {
            return true;
        }
        return event2.getEnd() >= event1.getBegin() && event2.getEnd() <= event1.getEnd();
    }

    @Override
    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Argument");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Related_to");
        relArg2.addToIndexes();
        LocationOfTextRelation relation = new LocationOfTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
    }

    @Override
    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }
}

