/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.baselines;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.baselines.Utils;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

@PipeBitInfo(name="Location of Annotator 1", description="Annotates Location Of relations in sentences containing exactly two entities (where the entities are of the correct types).", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.LOCATION_RELATION})
public class Baseline1EntityMentionPairRelationExtractorAnnotator
extends RelationExtractorAnnotator {
    @Override
    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        List args = JCasUtil.selectCovered((JCas)identifiedAnnotationView, EntityMention.class, (AnnotationFS)sentence);
        if (args.size() == 2) {
            EntityMention arg1 = (EntityMention)args.get(0);
            EntityMention arg2 = (EntityMention)args.get(1);
            for (RelationExtractorAnnotator.IdentifiedAnnotationPair pair : Lists.newArrayList((Object[])new RelationExtractorAnnotator.IdentifiedAnnotationPair[]{new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)arg1, (IdentifiedAnnotation)arg2), new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)arg2, (IdentifiedAnnotation)arg1)})) {
                if (!Utils.validateLocationOfArgumentTypes(pair)) continue;
                System.out.println(sentence.getCoveredText());
                System.out.println("arg1: " + pair.getArg1().getCoveredText());
                System.out.println("arg2: " + pair.getArg2().getCoveredText());
                System.out.println();
                return Lists.newArrayList((Object[])new RelationExtractorAnnotator.IdentifiedAnnotationPair[]{pair});
            }
        }
        return new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
    }

    @Override
    public String classify(List<Feature> features) {
        return "location_of";
    }
}

