/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.CoreNormObj;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;
import java.util.Hashtable;
import java.util.Vector;

public class ToUnicodeCoreNorm
extends Transformation
implements Cloneable {
    private static final String INFO = "Unicode Core Norm";

    public static Vector<LexItem> Mutate(LexItem in, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToUnicodeCoreNorm.GetUnicodeCoreNorm(in, symbolMap, unicodeMap, ligatureMap, diacriticMap, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static String GetCoreNormStr(String inStr, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap) {
        return ToUnicodeCoreNorm.GetCoreNormObj(inStr, symbolMap, unicodeMap, ligatureMap, diacriticMap).GetCurStr();
    }

    public static void main(String[] args) {
        String testStr = ToUnicodeCoreNorm.GetTestStr(args, "\u00a9 and \u00b5");
        Configuration conf = new Configuration("data.config.lvg", true);
        Hashtable<Character, String> symbolMap = ToMapSymbolToAscii.GetSymbolMapFromFile(conf);
        Hashtable<Character, String> unicodeMap = ToMapUnicodeToAscii.GetUnicodeMapFromFile(conf);
        Hashtable<Character, String> ligatureMap = ToSplitLigatures.GetLigatureMapFromFile(conf);
        Hashtable<Character, Character> diacriticMap = ToStripDiacritics.GetDiacriticMapFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToUnicodeCoreNorm.Mutate(in, symbolMap, unicodeMap, ligatureMap, diacriticMap, true, true);
        ToUnicodeCoreNorm.PrintResults(in, outs);
    }

    private static Vector<LexItem> GetUnicodeCoreNorm(LexItem in, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = infoStr;
        }
        if (mutateFlag) {
            mutate = new String();
        }
        String inStr = in.GetSourceTerm();
        String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            String curStr = UnicodeUtil.CharToStr(curChar);
            CoreNormObj curCoreNormObj = ToUnicodeCoreNorm.GetCoreNormObj(curStr, symbolMap, unicodeMap, ligatureMap, diacriticMap);
            buffer.append(curCoreNormObj.GetCurStr());
            if (!mutateFlag) continue;
            mutate = mutate + curCoreNormObj.GetDetails() + fs;
        }
        String term = buffer.toString();
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToUnicodeCoreNorm.UpdateLexItem(in, term, 61, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    private static CoreNormObj GetCoreNormObj(String inStr, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap) {
        CoreNormObj curObj = new CoreNormObj(inStr);
        ToUnicodeCoreNorm.CoreNorm(curObj, symbolMap, unicodeMap, ligatureMap, diacriticMap);
        return curObj;
    }

    private static void CoreNorm(CoreNormObj inObj, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap) {
        String curStr = inObj.GetCurStr();
        int curPos = inObj.GetCurPos();
        inObj.UpdateRecursiveNo();
        if (!inObj.IsWithinRecursiveLimit()) {
            inObj.SetDetails(6);
            return;
        }
        if (curPos < curStr.length()) {
            char curChar = curStr.charAt(curPos);
            String slStr = ToSplitLigatures.SplitLigature(curChar, ligatureMap);
            char sdChar = ToStripDiacritics.StripDiacritic(curChar, diacriticMap);
            if (UnicodeUtil.IsAsciiChar(curChar)) {
                inObj.UpdateCurPos();
                inObj.SetDetails(0);
            } else if (symbolMap.containsKey(Character.valueOf(curChar))) {
                String mapStr = ToMapSymbolToAscii.MapUnicodeSymbolToAscii(curChar, symbolMap);
                inObj.UpdateCurStr(mapStr);
                inObj.UpdateCurPos(mapStr.length());
                inObj.SetDetails(1);
            } else if (unicodeMap.containsKey(Character.valueOf(curChar))) {
                String mapStr = ToMapUnicodeToAscii.MapUnicodeToAscii(curChar, unicodeMap);
                inObj.UpdateCurStr(mapStr);
                inObj.UpdateCurPos(mapStr.length());
                inObj.SetDetails(2);
            } else if (!slStr.equals(UnicodeUtil.CharToStr(curChar))) {
                inObj.UpdateCurStr(slStr);
                inObj.SetDetails(4);
            } else if (sdChar != curChar) {
                inObj.UpdateCurStr(String.valueOf(sdChar));
                inObj.SetDetails(3);
            } else {
                inObj.UpdateCurPos();
                inObj.SetDetails(5);
            }
            ToUnicodeCoreNorm.CoreNorm(inObj, symbolMap, unicodeMap, ligatureMap, diacriticMap);
        }
    }
}

