/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lvg.Tools.GuiTool.Global.LvgDef;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiComp.InflectionPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiComp.OkCancelResetAllButtonPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.IntTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InflectionDialog
extends JDialog
implements ActionListener {
    private static JCheckBox[] cb_ = new JCheckBox[LvgDef.INFLECTION_NUM];
    private static InflectionPanel inflP_ = null;
    private static IntTextField inflField_ = null;
    private static long inflectionValue_ = 0L;
    private static String inflection_ = null;
    private static InflectionDialog inflD_ = null;
    private static final long serialVersionUID = 5L;

    private InflectionDialog(JFrame owner, String label, String title) {
        super(owner, title, true);
        this.setLocationRelativeTo(owner);
        this.setSize(590, 480);
        JPanel textP = new JPanel();
        textP.setLayout(new BoxLayout(textP, 0));
        inflField_ = new IntTextField(0, 8);
        inflField_.setEditable(false);
        textP.add(new JLabel(label));
        textP.add(inflField_);
        inflP_ = new InflectionPanel(this, 2);
        cb_ = inflP_.GetCheckBox();
        OkCancelResetAllButtonPanel buttonP = new OkCancelResetAllButtonPanel();
        JButton okB = buttonP.GetOkButton();
        JButton cancelB = buttonP.GetCancelButton();
        JButton resetB = buttonP.GetResetButton();
        JButton allB = buttonP.GetAllButton();
        JPanel centerP = new JPanel();
        centerP.add(textP);
        centerP.add(inflP_);
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)buttonP, "South");
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                inflection_ = Long.toString(inflectionValue_);
                InflectionDialog.this.setVisible(false);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                inflection_ = null;
                InflectionDialog.this.setVisible(false);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
                    cb_[i].setSelected(false);
                }
                inflectionValue_ = 0L;
                inflField_.setText(Long.toString(inflectionValue_));
            }
        });
        allB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                inflectionValue_ = 0L;
                for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
                    cb_[i].setSelected(cb_[i].isEnabled());
                    if (!cb_[i].isSelected()) continue;
                    inflectionValue_ = inflectionValue_ | LvgDef.INFLECTION_VALUE[i];
                }
                inflField_.setText(Long.toString(inflectionValue_));
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        inflectionValue_ = 0L;
        for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
            if (!cb_[i].isSelected()) continue;
            inflectionValue_ |= LvgDef.INFLECTION_VALUE[i];
        }
        inflField_.setText(Long.toString(inflectionValue_));
    }

    public String GetValueStr() {
        return inflection_;
    }

    public long GetValue() {
        return inflectionValue_;
    }

    public void SetValueStr(String valueStr) {
        if (valueStr != null) {
            try {
                inflection_ = valueStr;
                inflectionValue_ = Long.parseLong(inflection_);
                inflField_.setText(inflection_);
                for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
                    boolean selected = (inflectionValue_ & LvgDef.INFLECTION_VALUE[i]) > 0L;
                    cb_[i].setSelected(selected);
                }
            }
            catch (Exception e) {
                inflection_ = "";
                inflField_.setText(inflection_);
                for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
                    cb_[i].setSelected(false);
                }
            }
        } else {
            inflection_ = "";
            inflField_.setText(inflection_);
            for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
                cb_[i].setSelected(false);
            }
        }
    }

    public void SetCategoryValue(String valueStr) {
        if (valueStr != null) {
            try {
                long catValue = Long.parseLong(valueStr);
                inflP_.UpdateCheckBox(catValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void ShowDialog(JFrame owner, JTextField valueT) {
        if (inflD_ == null) {
            inflD_ = new InflectionDialog(owner, "Value of selected inflection: ", "Inflection Selection");
        }
        inflP_.ResetCheckBox();
        inflD_.SetValueStr(valueT.getText());
        inflD_.setVisible(true);
        if (inflD_.GetValueStr() != null) {
            valueT.setText(inflD_.GetValueStr());
        }
    }

    public static void ShowDialog(JFrame owner, JTextField valueT, JTextField catValueT) {
        if (inflD_ == null) {
            inflD_ = new InflectionDialog(owner, "Value of selected inflection: ", "Inflection Selection");
        }
        inflD_.SetCategoryValue(catValueT.getText());
        inflD_.SetValueStr(valueT.getText());
        inflD_.setVisible(true);
        if (inflD_.GetValueStr() != null) {
            valueT.setText(inflD_.GetValueStr());
        }
    }
}

