/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Trie.InflectionRule;
import gov.nih.nlm.nls.lvg.Trie.PersistentTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import gov.nih.nlm.nls.lvg.Trie.RuleResultComparator;
import gov.nih.nlm.nls.lvg.Trie.TrieNode;
import gov.nih.nlm.nls.lvg.Trie.TrieTree;
import gov.nih.nlm.nls.lvg.Trie.WildCard;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public final class RamTrie {
    private TrieTree trie_ = new TrieTree(true);
    private int minTermLength_ = 3;
    private int matchedNodeNum_ = 0;
    private int minTrieStemLength_ = 0;
    private boolean isInflection_ = true;

    public RamTrie(boolean isInflection, int minTermLength, String dir, int minTrieStemLength) {
        this.isInflection_ = isInflection;
        this.minTermLength_ = minTermLength;
        this.minTrieStemLength_ = minTrieStemLength;
        String trieDir = dir + "/data/rules/";
        String ruleFileName = "im.rul";
        if (!isInflection) {
            ruleFileName = "dm.rul";
        }
        this.trie_.LoadRulesFromFile(trieDir, ruleFileName, false, true);
        this.trie_.LoadRulesFromFile(trieDir, ruleFileName, true, false);
    }

    private Vector<RuleResult> Mutate(String term, boolean showAll, long inCategory, long inInflection, long outCategory, long outInflection) {
        Vector<RuleResult> resultList = new Vector<RuleResult>();
        Vector<TrieNode> matchNodeList = this.trie_.FindRule(term);
        this.matchedNodeNum_ = matchNodeList.size();
        int curLevel = 0;
        for (int i = 0; i < this.matchedNodeNum_; ++i) {
            TrieNode node = matchNodeList.elementAt(i);
            Vector<InflectionRule> rules = node.GetRules();
            if (node == null || rules == null) {
                System.err.println("** Error: null in TrieNode or it's rules");
                break;
            }
            for (int j = 0; j < rules.size(); ++j) {
                RuleResult result;
                InflectionRule rule = rules.elementAt(j);
                if (!this.isInflection_ && this.minTrieStemLength_ > 0 && this.GetStemLength(term, rule) <= this.minTrieStemLength_ || this.IsException(term, rule) || (result = this.ApplyRules(term, rule, inCategory, inInflection, outCategory, outInflection)) == null) continue;
                if (showAll) {
                    resultList.add(result);
                    continue;
                }
                if (node.GetLevel() > curLevel) {
                    curLevel = node.GetLevel();
                    resultList.removeAllElements();
                    resultList.add(result);
                    continue;
                }
                if (node.GetLevel() != curLevel) continue;
                resultList.add(result);
            }
        }
        Vector<RuleResult> out = new Vector<RuleResult>();
        for (int i = 0; i < resultList.size(); ++i) {
            RuleResult temp = (RuleResult)resultList.elementAt(i);
            String tempStr = temp.GetOutTerm();
            if (tempStr.length() < this.minTermLength_ && !tempStr.equals(term)) continue;
            out.addElement(temp);
        }
        return out;
    }

    public Vector<RuleResult> GetUninflectedTermsByRules(String term, long inCat, long inInfl, boolean showAll) {
        Vector<RuleResult> resultList = this.Mutate(term, showAll, inCat, inInfl, 1155L, 1793L);
        RuleResultComparator rrc = new RuleResultComparator();
        return resultList;
    }

    public CatInfl GetCatInflByRules(String term, long inCat, long inInfl) {
        long cat = 0L;
        long infl = 0L;
        Vector<TrieNode> matchNodeList = this.trie_.FindRule(term);
        this.matchedNodeNum_ = matchNodeList.size();
        boolean curLevel = false;
        for (int i = 0; i < matchNodeList.size(); ++i) {
            TrieNode node = matchNodeList.elementAt(i);
            Vector<InflectionRule> rules = node.GetRules();
            if (node == null || rules == null) {
                System.err.println("** Error: null in TrieNode or it's rules");
                break;
            }
            for (int j = 0; j < rules.size(); ++j) {
                InflectionRule rule = rules.elementAt(j);
                if (this.IsException(term, rule)) continue;
                long curCat = rule.GetInCategory();
                long curInfl = rule.GetInInflection();
                if (!Bit.Contain(inCat, curCat) || !Bit.Contain(inInfl, curInfl)) continue;
                cat |= curCat;
                infl |= curInfl;
            }
        }
        CatInfl catInfl = new CatInfl(cat, infl);
        return catInfl;
    }

    public Vector<CatInfl> GetCatInflsByRules(String term, long inCat, long inInfl) {
        long cat = 0L;
        long infl = 0L;
        Vector<CatInfl> outs = new Vector<CatInfl>();
        Vector<TrieNode> matchNodeList = this.trie_.FindRule(term);
        this.matchedNodeNum_ = matchNodeList.size();
        boolean curLevel = false;
        for (int i = 0; i < matchNodeList.size(); ++i) {
            TrieNode node = matchNodeList.elementAt(i);
            Vector<InflectionRule> rules = node.GetRules();
            if (node == null || rules == null) {
                System.err.println("** Error: null in TrieNode or it's rules");
                break;
            }
            for (int j = 0; j < rules.size(); ++j) {
                InflectionRule rule = rules.elementAt(j);
                if (this.IsException(term, rule)) continue;
                long curCat = rule.GetInCategory();
                long curInfl = rule.GetInInflection();
                CatInfl catInfl = new CatInfl(curCat, curInfl);
                outs.addElement(catInfl);
            }
        }
        return outs;
    }

    public Vector<RuleResult> GetInflectedTermsByRules(String term, long inCat, long inInfl, boolean showAll) {
        Vector<RuleResult> uninflectedList = this.Mutate(term, showAll, inCat, inInfl, 1155L, 1793L);
        Vector<RuleResult> resultList = new Vector<RuleResult>();
        String lastTerm = null;
        long lastCat = -1L;
        for (int i = 0; i < uninflectedList.size(); ++i) {
            RuleResult temp = uninflectedList.elementAt(i);
            String tempTerm = temp.GetOutTerm();
            String ruleStr = temp.GetRuleString();
            long cat = Category.ToValue(temp.GetOutCategory());
            Vector<RuleResult> tempResult = new Vector();
            if (cat != lastCat || !tempTerm.equals(lastTerm)) {
                tempResult = this.Mutate(tempTerm, showAll, cat, 2099071L, 1155L, 2099071L);
            }
            lastTerm = tempTerm;
            lastCat = cat;
            Vector<RuleResult> newTempResult = this.RemoveIllegalTerms(tempTerm, tempResult);
            resultList = PersistentTrie.AddRusultsToInflectList(resultList, newTempResult);
        }
        RuleResultComparator rrc = new RuleResultComparator();
        Collections.sort(resultList, rrc);
        return resultList;
    }

    public Vector<RuleResult> GetDerivationsByRules(String term, long inCat, long inInfl, boolean showAll) {
        Vector<RuleResult> resultList = this.Mutate(term, showAll, inCat, inInfl, 1155L, 1793L);
        return resultList;
    }

    public void PrintResults(Vector<RuleResult> resultList) {
        System.out.println("-- matchNodeList size: " + this.GetMatchedNodeNum());
        for (int i = 0; i < resultList.size(); ++i) {
            RuleResult result = resultList.elementAt(i);
            System.out.println(result.GetInTerm() + " --> " + result.GetOutTerm() + " ... Rule: " + result.GetRuleString());
        }
    }

    public TrieTree GetTrie() {
        return this.trie_;
    }

    public int GetMatchedNodeNum() {
        return this.matchedNodeNum_;
    }

    public void SetMinTermLength(int minTermLength) {
        this.minTermLength_ = minTermLength;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: java RamTrie <term> <-i/d> <-ps>");
            System.out.println(" term: input term for testing");
            System.out.println("   -i: mutate with all branch rules applied");
            System.out.println("   -p: print details, rule, & exceptions");
            System.out.println("   -s: mutate with all branch rules applied");
        } else {
            String inStr = args[0];
            Configuration conf = new Configuration("data.config.lvg", true);
            String dir = conf.GetConfiguration("LVG_DIR") + "/data/rules/";
            boolean isInflection = true;
            if (args[1].equals("-d")) {
                isInflection = false;
            }
            boolean showAll = false;
            if (args[2].equals("-s")) {
                showAll = true;
            }
            int minTrieStemLength = Integer.parseInt(conf.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
            RamTrie trie = new RamTrie(isInflection, 3, dir, minTrieStemLength);
            if (isInflection) {
                System.out.println("-------- Uninflected Terms ----------");
                Vector<RuleResult> result = trie.GetUninflectedTermsByRules(inStr, 2047L, 0xFFFFFFL, true);
                trie.PrintResults(result);
                System.out.println("-------- Inflected Terms ------------");
                result = trie.GetInflectedTermsByRules(inStr, 2047L, 0xFFFFFFL, true);
                trie.PrintResults(result);
                System.out.println("------ Category & Inflection -----");
                CatInfl catInfl = trie.GetCatInflByRules(inStr, 2047L, 0xFFFFFFL);
                System.out.println(catInfl.GetCategory() + ", " + catInfl.GetInflection());
                System.out.println("------ Categories & Inflections -----");
                Vector<CatInfl> result2 = trie.GetCatInflsByRules(inStr, 2047L, 0xFFFFFFL);
                for (int i = 0; i < result2.size(); ++i) {
                    catInfl = result2.elementAt(i);
                    System.out.println(catInfl.GetCategory() + ", " + catInfl.GetInflection());
                }
            } else {
                System.out.println("---------- Derivations -------------");
                Vector<RuleResult> result = trie.GetDerivationsByRules(inStr, 2047L, 0xFFFFFFL, true);
                trie.PrintResults(result);
            }
        }
    }

    private Vector<RuleResult> RemoveIllegalTerms(String base, Vector<RuleResult> inflections) {
        Vector<RuleResult> out = new Vector<RuleResult>();
        for (int i = 0; i < inflections.size(); ++i) {
            RuleResult temp = inflections.elementAt(i);
            String tempTerm = temp.GetOutTerm();
            String ruleStr = temp.GetRuleString();
            long infl = Inflection.ToValue(temp.GetOutInflection());
            if (Inflection.Contains(1793L, infl) && !base.equals(tempTerm)) continue;
            out.addElement(temp);
        }
        return out;
    }

    private boolean IsException(String inStr, InflectionRule rule) {
        boolean isException = false;
        Hashtable<String, String> exceptions = rule.GetExceptions();
        if (exceptions != null) {
            isException = exceptions.containsKey(inStr);
        }
        return isException;
    }

    private int GetStemLength(String term, InflectionRule rule) {
        int stemLength = term.length() + 1 - rule.GetInSuffix().length();
        return stemLength;
    }

    private RuleResult ApplyRules(String inStr, InflectionRule rule, long inCategory, long inInflection, long outCategory, long outInflection) {
        String tempStr = inStr + '$';
        String inSuffix = rule.GetInSuffix();
        String outSuffix = rule.GetOutSuffix();
        int tempSize = tempStr.length();
        int inSize = inSuffix.length();
        long inCat = rule.GetInCategory();
        long outCat = rule.GetOutCategory();
        long inInf = rule.GetInInflection();
        long outInf = rule.GetOutInflection();
        String unchangeStr = tempStr.substring(0, tempSize - inSize);
        String changeStr = WildCard.GetSuffix(inSuffix, outSuffix, tempStr);
        String outStr = unchangeStr + changeStr;
        outStr = outStr.substring(0, outStr.length() - 1);
        RuleResult out = null;
        if (Category.Contains(inCategory, inCat) && Category.Contains(outCategory, outCat) && Inflection.Contains(inInflection, inInf) && Inflection.Contains(outInflection, outInf)) {
            out = new RuleResult(inStr, outStr, rule.GetRuleStr());
        }
        return out;
    }
}

