/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.propbank;

import java.util.ArrayList;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.corpus.propbank.util.Propbank;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.token.type.Sentence;
import org.cleartk.util.AnnotationUtil;

@SofaCapability(inputSofas={"PROPBANK_VIEW", "_InitialView"})
public class PropbankGoldAnnotator
extends JCasAnnotator_ImplBase {
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            JCas pbView = jCas.getView("PROPBANK_VIEW");
            JCas docView = jCas.getView("_InitialView");
            ArrayList sentenceList = new ArrayList(JCasUtil.select((JCas)docView, Sentence.class));
            for (String propbankDatum : pbView.getDocumentText().split("\n")) {
                if (propbankDatum.length() == 0) continue;
                Propbank propbank = Propbank.fromString(propbankDatum);
                Sentence sentence = (Sentence)sentenceList.get(propbank.getSentenceNumber());
                TopTreebankNode top = (TopTreebankNode)AnnotationUtil.selectFirstMatching((JCas)docView, TopTreebankNode.class, (Annotation)sentence);
                if (top == null) {
                    throw new IllegalArgumentException(String.format("%s missing for %s", TopTreebankNode.class.getName(), sentence));
                }
                propbank.convert(docView, top, sentence);
            }
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

