/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class EventPositionRelationFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private String name = "EventRelaionPosition";

    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList features = Lists.newArrayList();
        ArrayList events = Lists.newArrayList();
        if (arg1 instanceof EventMention) {
            events.add((EventMention)arg1);
        }
        if (arg2 instanceof EventMention) {
            events.add((EventMention)arg2);
        }
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        ArrayList sentList = Lists.newArrayList();
        sentList.addAll(sentences);
        int sentSize = sentList.size();
        Map coveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, Segment.class);
        Collection allevents = JCasUtil.select((JCas)jCas, EventMention.class);
        ArrayList eventList = Lists.newArrayList();
        for (EventMention eventa : allevents) {
            if (!eventa.getClass().equals(EventMention.class)) continue;
            eventList.add(eventa);
        }
        int eventSize = eventList.size();
        for (EventMention event : events) {
            Feature feature;
            if (sentSize >= 5) {
                if (EventPositionRelationFeaturesExtractor.containEvent((Annotation)sentList.get(0), (Annotation)sentList.get(4), (Annotation)event)) {
                    feature = new Feature(this.name, (Object)"Within_Top_5_sentences");
                    features.add(feature);
                }
                if (EventPositionRelationFeaturesExtractor.containEvent((Annotation)sentList.get(sentSize - 5), (Annotation)sentList.get(sentSize - 1), (Annotation)event)) {
                    feature = new Feature(this.name, (Object)"Within_Last_5_sentences");
                    features.add(feature);
                }
            }
            if (eventSize >= 5) {
                if (EventPositionRelationFeaturesExtractor.containEvent((Annotation)eventList.get(0), (Annotation)eventList.get(4), (Annotation)event)) {
                    feature = new Feature(this.name, (Object)"Within_Top_5_events");
                    features.add(feature);
                }
                if (EventPositionRelationFeaturesExtractor.containEvent((Annotation)eventList.get(eventSize - 5), (Annotation)eventList.get(eventSize - 1), (Annotation)event)) {
                    feature = new Feature(this.name, (Object)"Within_Last_5_events");
                    features.add(feature);
                }
            }
            Collection segList = (Collection)coveringMap.get(event);
            for (Segment seg : segList) {
                Feature feature2;
                String segname = seg.getId();
                if (segname.equals("SIMPLE_SEGMENT")) continue;
                ArrayList<EventMention> segEvents = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)seg);
                ArrayList<EventMention> realEvents = new ArrayList<EventMention>();
                for (EventMention segevent : segEvents) {
                    if (!segevent.getClass().equals(EventMention.class)) continue;
                    realEvents.add(segevent);
                }
                segEvents = realEvents;
                int segEventSize = segEvents.size();
                if (segEventSize < 3) continue;
                if (EventPositionRelationFeaturesExtractor.containEvent((Annotation)segEvents.get(0), (Annotation)segEvents.get(2), (Annotation)event)) {
                    feature2 = new Feature(this.name, (Object)("Within_Top_3_events_of" + segname));
                    features.add(feature2);
                }
                if (!EventPositionRelationFeaturesExtractor.containEvent((Annotation)segEvents.get(segEventSize - 3), (Annotation)segEvents.get(segEventSize - 1), (Annotation)event)) continue;
                feature2 = new Feature(this.name, (Object)("Within_Last_3_events_of" + segname));
                features.add(feature2);
            }
        }
        return features;
    }

    private static boolean containEvent(Annotation arg1, Annotation arg2, Annotation target) {
        return target.getBegin() >= arg1.getBegin() && target.getEnd() <= arg2.getEnd();
    }
}

