/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ctakes.temporal.ae.feature.TemporalAttributeFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.TimeWordTypeExtractor;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.DateAnnotation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class TimeXExtractor
implements FeatureExtractor1 {
    private String name = "TimeXFeature";
    private TemporalAttributeFeatureExtractor attr = new TemporalAttributeFeatureExtractor();
    private TimeWordTypeExtractor<IdentifiedAnnotation> timewd = new TimeWordTypeExtractor();

    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Map coveringMap = JCasUtil.indexCovering((JCas)view, EventMention.class, Sentence.class);
        EventMention targetTokenAnnotation = (EventMention)annotation;
        Collection sentList = (Collection)coveringMap.get(targetTokenAnnotation);
        TreeMap<Integer, TimeMention> timeDistMap = null;
        if (sentList != null && !sentList.isEmpty()) {
            timeDistMap = new TreeMap<Integer, TimeMention>();
            for (Sentence sent : sentList) {
                for (TimeMention time : JCasUtil.selectCovered((JCas)view, TimeMention.class, (AnnotationFS)sent)) {
                    timeDistMap.put(Math.abs(time.getBegin() - annotation.getBegin()), time);
                }
                for (TimeMention time : JCasUtil.selectCovered((JCas)view, TimeAnnotation.class, (AnnotationFS)sent)) {
                    timeDistMap.put(Math.abs(time.getBegin() - annotation.getBegin()), time);
                }
                for (TimeMention time : JCasUtil.selectCovered((JCas)view, DateAnnotation.class, (AnnotationFS)sent)) {
                    timeDistMap.put(Math.abs(time.getBegin() - annotation.getBegin()), time);
                }
            }
            Iterator<Object> iterator = timeDistMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Feature feature = new Feature(this.name, (Object)((IdentifiedAnnotation)entry.getValue()).getCoveredText());
                features.add(feature);
                Feature indicator = new Feature("TimeXNearby", (Object)this.name);
                features.add(indicator);
                Feature type = new Feature("TimeXType", ((IdentifiedAnnotation)entry.getValue()).getClass());
                features.add(type);
                for (TreebankNode treebankNode : JCasUtil.selectCovering((JCas)view, TreebankNode.class, (int)((IdentifiedAnnotation)entry.getValue()).getBegin(), (int)((IdentifiedAnnotation)entry.getValue()).getEnd())) {
                    if (!treebankNode.getNodeType().equals("PP")) continue;
                    Feature PPNodeType = new Feature("Timex_PPNodeType", (Object)treebankNode.getNodeType());
                    features.add(PPNodeType);
                    break;
                }
                try {
                    features.addAll(this.attr.extract(view, (IdentifiedAnnotation)targetTokenAnnotation, (IdentifiedAnnotation)entry.getValue()));
                    features.addAll(this.timewd.extract(view, (Annotation)entry.getValue()));
                }
                catch (AnalysisEngineProcessException e) {
                    throw new IllegalArgumentException(String.format("error in gererating path feature:", features));
                }
            }
        }
        return features;
    }
}

