/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.DateAnnotation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class TimeXRelationFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private String name = "TimeXRelatioinFeature";

    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList features = Lists.newArrayList();
        ArrayList events = Lists.newArrayList();
        if (arg1 instanceof EventMention) {
            events.add((EventMention)arg1);
        }
        if (arg2 instanceof EventMention) {
            events.add((EventMention)arg2);
        }
        Map coveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, Sentence.class);
        block0: for (EventMention event : events) {
            Collection sentList = (Collection)coveringMap.get(event);
            TreeMap<Integer, TimeMention> timeDistMap = new TreeMap<Integer, TimeMention>();
            for (Sentence sent : sentList) {
                for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sent)) {
                    timeDistMap.put(Math.abs(time.getBegin() - event.getBegin()), time);
                }
                for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeAnnotation.class, (AnnotationFS)sent)) {
                    timeDistMap.put(Math.abs(time.getBegin() - event.getBegin()), time);
                }
                for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, DateAnnotation.class, (AnnotationFS)sent)) {
                    timeDistMap.put(Math.abs(time.getBegin() - event.getBegin()), time);
                }
            }
            Iterator<Object> iterator = timeDistMap.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = (Map.Entry)iterator.next();
            Feature feature = new Feature(this.name, (Object)((IdentifiedAnnotation)entry.getValue()).getCoveredText());
            features.add(feature);
            Feature indicator = new Feature("TimeXNearby", (Object)this.name);
            features.add(indicator);
            Feature type = new Feature("TimeXType", ((IdentifiedAnnotation)entry.getValue()).getClass());
            features.add(type);
            for (TreebankNode treebankNode : JCasUtil.selectCovering((JCas)jCas, TreebankNode.class, (int)((IdentifiedAnnotation)entry.getValue()).getBegin(), (int)((IdentifiedAnnotation)entry.getValue()).getEnd())) {
                if (!treebankNode.getNodeType().equals("PP")) continue;
                Feature PPNodeType = new Feature("Timex_PPNodeType", (Object)treebankNode.getNodeType());
                features.add(PPNodeType);
                String value = treebankNode.getNodeValue();
                if (value != null) {
                    features.add(new Feature("Timex_PPNodeValue_", (Object)value));
                }
                features.add(new Feature("PP_Timex_", (Object)((IdentifiedAnnotation)entry.getValue()).getClass().getCanonicalName()));
                continue block0;
            }
        }
        return features;
    }
}

