/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.constituent;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.googlecode.clearnlp.constituent.CTLibEn;
import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.constituent.CTTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CTLib {
    public static final String PTAG_TOP = "TOP";
    public static final String PTAG_X = "X";
    public static final String POS_NONE = "-NONE-";
    public static final String POS_XX = "XX";

    public static void normalizeIndices(CTTree tree) {
        IntObjectOpenHashMap mOrg = new IntObjectOpenHashMap();
        CTLib.getCoIndexMap(tree.getRoot(), (IntObjectOpenHashMap<List<CTNode>>)mOrg);
        if (mOrg.isEmpty()) {
            return;
        }
        int[] keys = mOrg.keys().toArray();
        Arrays.sort(keys);
        IntIntOpenHashMap mNew = new IntIntOpenHashMap();
        int coIndex = 1;
        for (int key : keys) {
            List list = (List)mOrg.get(key);
            int last = list.size() - 1;
            boolean isAnteFound = false;
            for (int i = last; i >= 0; --i) {
                CTNode curr = (CTNode)list.get(i);
                if (curr.isEmptyCategoryRec()) {
                    CTNode ec = curr.getSubTerminals().get(0);
                    curr.coIndex = i == last || isAnteFound || CTLibEn.RE_ICH_PPA_RNR.matcher(ec.form).find() || CTLibEn.containsCoordination(curr.getLowestCommonAncestor((CTNode)list.get(i + 1))) ? -1 : coIndex++;
                    if (!isAnteFound && i <= 0) continue;
                    ec.form = ec.form + "-" + coIndex;
                    continue;
                }
                if (isAnteFound) {
                    curr.coIndex = -1;
                    continue;
                }
                curr.coIndex = coIndex;
                mNew.put(key, coIndex);
                isAnteFound = true;
            }
            ++coIndex;
        }
        int[] lastIndex = new int[]{coIndex};
        CTLib.remapGapIndices(mNew, lastIndex, tree.getRoot());
    }

    private static void getCoIndexMap(CTNode curr, IntObjectOpenHashMap<List<CTNode>> map) {
        if (curr.isPhrase()) {
            if (curr.coIndex != -1) {
                List<CTNode> list;
                int key = curr.coIndex;
                if (map.containsKey(key)) {
                    list = (List)map.get(key);
                } else {
                    list = new ArrayList();
                    map.put(key, list);
                }
                list.add(curr);
            }
            for (CTNode child : curr.ls_children) {
                CTLib.getCoIndexMap(child, map);
            }
        } else if (curr.isEmptyCategory() && curr.form.equals("*0*")) {
            curr.form = "0";
        }
    }

    private static void remapGapIndices(IntIntOpenHashMap map, int[] lastIndex, CTNode curr) {
        int gapIndex = curr.gapIndex;
        if (map.containsKey(gapIndex)) {
            curr.gapIndex = map.get(gapIndex);
        } else if (gapIndex != -1) {
            curr.gapIndex = lastIndex[0];
            int n = lastIndex[0];
            lastIndex[0] = n + 1;
            map.put(gapIndex, n);
        }
        for (CTNode child : curr.ls_children) {
            CTLib.remapGapIndices(map, lastIndex, child);
        }
    }

    public static IntArrayList[] getTokenMapList(CTTree tree1, CTTree tree2) {
        int tId1;
        List<CTNode> tokens1 = tree1.getTokens();
        List<CTNode> tokens2 = tree2.getTokens();
        int size1 = tokens1.size();
        int size2 = tokens2.size();
        IntArrayList[] map = new IntArrayList[size1];
        for (tId1 = 0; tId1 < size1; ++tId1) {
            map[tId1] = new IntArrayList();
        }
        tId1 = 0;
        int tId2 = 0;
        while (tId1 < size1) {
            int len2;
            String form1 = tokens1.get((int)tId1).form;
            String form2 = tokens2.get((int)tId2).form;
            int len1 = form1.length();
            if (len1 < (len2 = form2.length())) {
                while (form1.length() < len2 && ++tId1 < size1) {
                    form1 = form1 + tokens1.get((int)tId1).form;
                    map[tId1 - 1].add(tId2);
                }
            } else if (len1 > len2) {
                while (len1 > form2.length() && ++tId2 < size2) {
                    form2 = form2 + tokens2.get((int)tId2).form;
                    map[tId1].add(tId2 - 1);
                }
            }
            if (!form1.equals(form2)) {
                return null;
            }
            map[tId1].add(tId2);
            ++tId1;
            ++tId2;
        }
        return map;
    }
}

