/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency;

import com.googlecode.clearnlp.dependency.DEPNode;
import java.util.regex.Pattern;

public class DEPArc
implements Comparable<DEPArc> {
    protected DEPNode node;
    protected String label;

    public DEPArc() {
        this.clear();
    }

    public DEPArc(DEPNode node, String label) {
        this.set(node, label);
    }

    public void clear() {
        this.set(null, null);
    }

    public DEPNode getNode() {
        return this.node;
    }

    public void setNode(DEPNode node) {
        this.node = node;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void appendLabel(String label) {
        this.label = this.label + "," + label;
    }

    public void set(DEPNode node, String label) {
        this.node = node;
        this.label = label;
    }

    public boolean isNode(DEPNode node) {
        return this.node == node;
    }

    public boolean isLabel(String label) {
        return this.label.equals(label);
    }

    public boolean isLabel(Pattern regex) {
        return regex.matcher(this.label).find();
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.node.id);
        build.append(":");
        build.append(this.label);
        return build.toString();
    }

    public int compareTo(DEPNode node, String label) {
        if (this.isNode(node)) {
            return this.isLabel(label) ? 1 : 2;
        }
        return 0;
    }

    @Override
    public int compareTo(DEPArc arc) {
        return this.node.compareTo(arc.node);
    }
}

