/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.dependency.DEPLib;
import com.googlecode.clearnlp.dependency.DEPParser;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.feature.xml.DEPFtrXml;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.run.DEPTrain;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTXml;
import com.googlecode.clearnlp.util.pair.Pair;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class DEPDevelop
extends DEPTrain {
    @Option(name="-d", usage="the directory containing development file (input; required)", required=true, metaVar="<filename>")
    private String s_devDir;

    public DEPDevelop() {
    }

    public DEPDevelop(String[] args) {
        this.initArgs(args);
        try {
            this.run(this.s_configXml, this.s_featureXml, this.s_trainDir, this.s_devDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void run(String configXml, String featureXml, String trainDir, String devDir) throws Exception {
        double prevScore;
        Element eConfig = UTXml.getDocumentElement(new FileInputStream(configXml));
        DEPReader reader = (DEPReader)this.getReader((Element)eConfig).o1;
        DEPFtrXml xml = new DEPFtrXml(new FileInputStream(featureXml));
        String[] trainFiles = UTFile.getSortedFileListBySize(trainDir, ".*", true);
        String[] devFiles = UTFile.getSortedFileList(devDir);
        Set<String> sPunc = this.getLexica(eConfig, xml, trainFiles, -1);
        Pair<Object, Double> model = new Pair<Object, Double>(null, 0.0);
        int i = 0;
        this.develop(eConfig, reader, xml, sPunc, trainFiles, devFiles, model, i++);
        do {
            prevScore = (Double)model.o2;
            this.develop(eConfig, reader, xml, sPunc, trainFiles, devFiles, model, i++);
        } while ((Double)model.o2 > prevScore);
    }

    protected void develop(Element eConfig, DEPReader reader, DEPFtrXml xml, Set<String> sPunc, String[] trainFiles, String[] devFiles, Pair<StringModel, Double> model, int boot) throws Exception {
        long st = System.currentTimeMillis();
        int[] lCounts = new int[]{0, 0, 0, 0};
        int[] gCounts = new int[]{0, 0, 0, 0};
        DEPParser parser = this.getTrainedParser(eConfig, xml, sPunc, trainFiles, (StringModel)model.o1, -1, boot);
        model.o1 = parser.getModel();
        for (String devFile : devFiles) {
            DEPTree tree;
            reader.open(UTInput.createBufferedFileReader(devFile));
            Arrays.fill(lCounts, 0);
            System.out.println("Predicting: " + devFile);
            int i = 0;
            while ((tree = reader.next()) != null) {
                StringIntPair[] gHeads = tree.getHeads();
                parser.parse(tree);
                int[] counts = DEPLib.getScores(tree, gHeads);
                UTArray.add(lCounts, counts);
                if (i % 1000 == 0) {
                    System.out.print(".");
                }
                ++i;
            }
            System.out.println();
            reader.close();
            System.out.printf("LAS: %5.2f (%d/%d)\n", 100.0 * (double)lCounts[1] / (double)lCounts[0], lCounts[1], lCounts[0]);
            System.out.printf("UAS: %5.2f (%d/%d)\n", 100.0 * (double)lCounts[2] / (double)lCounts[0], lCounts[2], lCounts[0]);
            System.out.printf("LS : %5.2f (%d/%d)\n", 100.0 * (double)lCounts[3] / (double)lCounts[0], lCounts[3], lCounts[0]);
            for (i = 0; i < lCounts.length; ++i) {
                int n = i;
                gCounts[n] = gCounts[n] + lCounts[i];
            }
        }
        System.out.println("Total");
        System.out.printf("LAS: %5.2f (%d/%d)\n", 100.0 * (double)gCounts[1] / (double)gCounts[0], gCounts[1], gCounts[0]);
        System.out.printf("UAS: %5.2f (%d/%d)\n", 100.0 * (double)gCounts[2] / (double)gCounts[0], gCounts[2], gCounts[0]);
        System.out.printf("LS : %5.2f (%d/%d)\n", 100.0 * (double)gCounts[3] / (double)gCounts[0], gCounts[3], gCounts[0]);
        model.o2 = 100.0 * (double)gCounts[1] / (double)gCounts[0];
        long millis = System.currentTimeMillis() - st;
        String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }

    public static void main(String[] args) {
        new DEPDevelop(args);
    }
}

