/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.reader;

import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.AbstractColumnReader;
import java.util.List;

public class DAGReader
extends AbstractColumnReader<DEPTree> {
    private int i_id;
    private int i_form;
    private int i_lemma;
    private int i_pos;
    private int i_feats;
    private int i_xheads;

    public DAGReader(int iId, int iForm, int iLemma, int iPos, int iFeats, int iXheads) {
        this.init(iId, iForm, iLemma, iPos, iFeats, iXheads);
    }

    public void init(int iId, int iForm, int iLemma, int iPos, int iFeats, int iXheads) {
        this.i_id = iId;
        this.i_form = iForm;
        this.i_lemma = iLemma;
        this.i_pos = iPos;
        this.i_feats = iFeats;
        this.i_xheads = iXheads;
    }

    @Override
    public DEPTree next() {
        DEPTree tree = null;
        try {
            List<String[]> lines = this.readLines();
            if (lines == null) {
                return null;
            }
            tree = this.getDAG(lines);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tree;
    }

    protected DEPTree getDAG(List<String[]> lines) {
        int i;
        int size = lines.size();
        DEPTree tree = new DEPTree();
        for (i = 0; i < size; ++i) {
            tree.add(new DEPNode());
        }
        for (i = 0; i < size; ++i) {
            String[] tmp = lines.get(i);
            int id = Integer.parseInt(tmp[this.i_id]);
            String form = tmp[this.i_form];
            String lemma = tmp[this.i_lemma];
            String pos = tmp[this.i_pos];
            DEPFeat feats = new DEPFeat(tmp[this.i_feats]);
            DEPNode node = tree.get(id);
            node.init(id, form, lemma, pos, feats);
            if (this.i_xheads < 0 || tmp[this.i_xheads].equals("_")) continue;
            for (String head : tmp[this.i_xheads].split(";")) {
                tmp = head.split(":");
                int headId = Integer.parseInt(tmp[0]);
                String label = tmp[1];
                node.addXHead(tree.get(headId), label);
            }
        }
        return tree;
    }

    @Override
    public String getType() {
        return "dag";
    }
}

