/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.pear.merger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.util.StringUtil;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.tools.pear.merger.PMController;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.xml.sax.SAXException;

public class PMUimaAgent {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AnalysisEngineDescription createAggregateDescription(String aggCompName, File aggRootDir, InstallationDescriptor[] dlgInstDescs) {
        AnalysisEngineDescription aggDescription = null;
        int lastInputNo = 0;
        try {
            ResourceSpecifierFactory rsFactory = UIMAFramework.getResourceSpecifierFactory();
            aggDescription = rsFactory.createAnalysisEngineDescription();
            aggDescription.setPrimitive(false);
            Map delegatesMap = aggDescription.getDelegateAnalysisEngineSpecifiersWithImports();
            for (int i = 0; i < dlgInstDescs.length; ++i) {
                InstallationDescriptor dlgInsD = dlgInstDescs[i];
                String dlgName = dlgInsD.getMainComponentId();
                String dlgDescPath = dlgInsD.getMainComponentDesc();
                Import dlgImport = rsFactory.createImport();
                String dlgDescRelPath = dlgDescPath.replaceAll("\\$main_root", StringUtil.toRegExpReplacement((String)".."));
                dlgImport.setLocation(dlgDescRelPath);
                delegatesMap.put(dlgName, dlgImport);
            }
            AnalysisEngineMetaData aggMetadata = aggDescription.getAnalysisEngineMetaData();
            aggMetadata.setName(aggCompName);
            aggMetadata.setDescription("Merged aggregate component(PEAR Merger)");
            FixedFlow aggFixedFlow = rsFactory.createFixedFlow();
            String[] aggFlowSpecs = new String[dlgInstDescs.length];
            for (int i = 0; i < dlgInstDescs.length; ++i) {
                aggFlowSpecs[i] = dlgInstDescs[i].getMainComponentId();
            }
            aggFixedFlow.setFixedFlow(aggFlowSpecs);
            aggMetadata.setFlowConstraints((FlowConstraints)aggFixedFlow);
            ArrayList<Capability> allCapabilities = new ArrayList<Capability>();
            boolean isMultipleDeploymentAllowed = true;
            boolean modifiesCas = false;
            for (int i = 0; i < dlgInstDescs.length; ++i) {
                OperationalProperties dlgOperProps;
                Capability[] dlgCapabilities;
                lastInputNo = i + 1;
                ResourceSpecifier dlgSpecifier = PMUimaAgent.retrieveDelegateSpecifier(aggRootDir, dlgInstDescs[i]);
                if (dlgSpecifier instanceof AnalysisEngineDescription) {
                    AnalysisEngineMetaData dlgAeMetadata = ((AnalysisEngineDescription)dlgSpecifier).getAnalysisEngineMetaData();
                    dlgCapabilities = dlgAeMetadata.getCapabilities();
                    if (dlgCapabilities != null) {
                        for (int n = 0; n < dlgCapabilities.length; ++n) {
                            allCapabilities.add(dlgCapabilities[n]);
                        }
                    }
                    if ((dlgOperProps = dlgAeMetadata.getOperationalProperties()) != null) {
                        if (!dlgOperProps.isMultipleDeploymentAllowed()) {
                            isMultipleDeploymentAllowed = false;
                        }
                        if (!dlgOperProps.getModifiesCas()) continue;
                        modifiesCas = true;
                        continue;
                    }
                    modifiesCas = true;
                    continue;
                }
                if (dlgSpecifier instanceof CasConsumerDescription) {
                    ProcessingResourceMetaData dlgCcMetadata = ((CasConsumerDescription)dlgSpecifier).getCasConsumerMetaData();
                    dlgCapabilities = dlgCcMetadata.getCapabilities();
                    if (dlgCapabilities != null) {
                        for (int n = 0; n < dlgCapabilities.length; ++n) {
                            allCapabilities.add(dlgCapabilities[n]);
                        }
                    }
                    if ((dlgOperProps = dlgCcMetadata.getOperationalProperties()) == null || dlgOperProps.isMultipleDeploymentAllowed()) continue;
                    isMultipleDeploymentAllowed = false;
                    continue;
                }
                throw new IllegalArgumentException("unsupported input component");
            }
            Capability[] mergedCapabilities = PMUimaAgent.mergeCapabilities(allCapabilities, rsFactory);
            aggMetadata.setCapabilities(mergedCapabilities);
            OperationalProperties aggOperProps = aggMetadata.getOperationalProperties();
            if (aggOperProps != null) {
                aggOperProps.setMultipleDeploymentAllowed(isMultipleDeploymentAllowed);
                aggOperProps.setModifiesCas(modifiesCas);
            }
        }
        catch (IllegalArgumentException exc) {
            PMController.logErrorMessage("Invalid input component # " + lastInputNo);
            PMController.logErrorMessage("IllegalArgumentException: " + exc.getMessage());
            aggDescription = null;
        }
        catch (Throwable err) {
            if (lastInputNo > 0) {
                PMController.logErrorMessage("Error in input component # " + lastInputNo);
            }
            PMController.logErrorMessage(err.toString());
            aggDescription = null;
        }
        return aggDescription;
    }

    private static Capability[] mergeCapabilities(ArrayList allCapabilities, ResourceSpecifierFactory rsFactory) {
        Hashtable<String, TypeOrFeature> mergedInputs = new Hashtable<String, TypeOrFeature>();
        Hashtable<String, TypeOrFeature> mergedOutputs = new Hashtable<String, TypeOrFeature>();
        for (Capability entry : allCapabilities) {
            TypeOrFeature prevTof;
            String name;
            TypeOrFeature nextTof;
            int i;
            TypeOrFeature[] entryInps = entry.getInputs();
            TypeOrFeature[] entryOuts = entry.getOutputs();
            for (i = 0; i < entryInps.length; ++i) {
                nextTof = entryInps[i];
                name = nextTof.getName();
                prevTof = (TypeOrFeature)mergedInputs.get(name);
                if (prevTof != null) {
                    if (!prevTof.isType() || prevTof.isAllAnnotatorFeatures() || !nextTof.isAllAnnotatorFeatures()) continue;
                    mergedInputs.put(name, nextTof);
                    continue;
                }
                mergedInputs.put(name, nextTof);
            }
            for (i = 0; i < entryOuts.length; ++i) {
                nextTof = entryOuts[i];
                name = nextTof.getName();
                prevTof = (TypeOrFeature)mergedOutputs.get(name);
                if (prevTof != null) {
                    if (!prevTof.isType() || prevTof.isAllAnnotatorFeatures() || !nextTof.isAllAnnotatorFeatures()) continue;
                    mergedOutputs.put(name, nextTof);
                    continue;
                }
                mergedOutputs.put(name, nextTof);
            }
        }
        Capability mergedCapability = rsFactory.createCapability();
        Enumeration inpsList = mergedInputs.keys();
        while (inpsList.hasMoreElements()) {
            String name = (String)inpsList.nextElement();
            TypeOrFeature tof = (TypeOrFeature)mergedInputs.get(name);
            if (tof.isType()) {
                mergedCapability.addInputType(name, tof.isAllAnnotatorFeatures());
                continue;
            }
            mergedCapability.addInputFeature(name);
        }
        Enumeration outsList = mergedOutputs.keys();
        while (outsList.hasMoreElements()) {
            String name = (String)outsList.nextElement();
            TypeOrFeature tof = (TypeOrFeature)mergedOutputs.get(name);
            if (tof.isType()) {
                mergedCapability.addOutputType(name, tof.isAllAnnotatorFeatures());
                continue;
            }
            mergedCapability.addOutputFeature(name);
        }
        Capability[] mergedArray = new Capability[]{mergedCapability};
        return mergedArray;
    }

    private static ResourceSpecifier retrieveDelegateSpecifier(File aggRootDir, InstallationDescriptor dlgInstDesc) throws IOException, InvalidXMLException {
        String aggRootDirPath = aggRootDir.getAbsolutePath().replace('\\', '/');
        String dlgDescPath = dlgInstDesc.getMainComponentDesc().replaceAll("\\$main_root", StringUtil.toRegExpReplacement((String)aggRootDirPath));
        XMLInputSource xmlSource = null;
        ResourceSpecifier dlgSpecifier = null;
        try {
            xmlSource = new XMLInputSource(dlgDescPath);
            XMLParser xmlParser = UIMAFramework.getXMLParser();
            dlgSpecifier = xmlParser.parseResourceSpecifier(xmlSource);
        }
        catch (InvalidXMLException xmlExc) {
            String msgKey = xmlExc.getMessageKey();
            if ("invalid_class".equals(msgKey)) {
                throw new IllegalArgumentException(xmlExc.toString());
            }
            throw xmlExc;
        }
        catch (UIMA_IllegalStateException urtExc) {
            String msgKey = urtExc.getMessageKey();
            if ("could_not_instantiate_xmlizable".equals(msgKey)) {
                throw new IllegalArgumentException(urtExc.toString());
            }
            throw urtExc;
        }
        finally {
            if (xmlSource != null) {
                try {
                    xmlSource.getInputStream().close();
                }
                catch (Exception e) {}
            }
        }
        return dlgSpecifier;
    }

    static void saveAggregateDescription(AnalysisEngineDescription aggDescription, File aggDescFile) throws IOException {
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(aggDescFile);
            aggDescription.toXML((Writer)fWriter);
        }
        catch (SAXException exc) {
            throw new IOException(exc.toString());
        }
        finally {
            if (fWriter != null) {
                try {
                    fWriter.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String toXmlString(XMLizable content) {
        StringWriter sWriter = new StringWriter();
        PrintWriter oWriter = null;
        try {
            oWriter = new PrintWriter(sWriter);
            content.toXML((Writer)oWriter);
            oWriter.flush();
        }
        catch (Exception exc) {
        }
        finally {
            if (oWriter != null) {
                try {
                    oWriter.close();
                }
                catch (Exception e) {}
            }
        }
        return sWriter.toString();
    }
}

