/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ci;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.ci.TextModification;
import org.apache.ctakes.core.ci.TextModifier;
import org.apache.ctakes.core.nlp.tokenizer.Token;
import org.apache.ctakes.core.nlp.tokenizer.Tokenizer;
import org.apache.ctakes.core.resource.FileLocator;

public class HyphenTextModifierImpl
implements TextModifier {
    private Map<String, Integer> iv_shouldbeHyphenMap = null;
    private int iv_windowSize = 3;
    private Tokenizer iv_tokenizer = null;

    public HyphenTextModifierImpl(String hyphenfilename, int windowSize) {
        this.iv_windowSize = windowSize;
        this.iv_tokenizer = new Tokenizer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(FileLocator.getAsStream(hyphenfilename)));
            String line = "";
            this.iv_shouldbeHyphenMap = new HashMap<String, Integer>();
            while ((line = br.readLine()) != null) {
                String[] toks = line.split("\\|");
                String[] unh = toks[0].split("\\-");
                String shouldbehyphen = "";
                for (int i = 0; i < unh.length; ++i) {
                    shouldbehyphen = shouldbehyphen + " " + unh[i];
                }
                shouldbehyphen = shouldbehyphen.trim().toLowerCase();
                this.iv_shouldbeHyphenMap.put(shouldbehyphen, new Integer(1));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot find the hyphenation file:" + hyphenfilename);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IOException accessing the hyphenation file:" + hyphenfilename);
            e.printStackTrace();
        }
    }

    public HyphenTextModifierImpl(InputStream hyphenfilename, int windowSize) {
        this.iv_windowSize = windowSize;
        this.iv_tokenizer = new Tokenizer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(hyphenfilename));
            String line = "";
            this.iv_shouldbeHyphenMap = new HashMap<String, Integer>();
            while ((line = br.readLine()) != null) {
                String[] toks = line.split("\\|");
                String[] unh = toks[0].split("\\-");
                String shouldbehyphen = "";
                for (int i = 0; i < unh.length; ++i) {
                    shouldbehyphen = shouldbehyphen + " " + unh[i];
                }
                shouldbehyphen = shouldbehyphen.trim().toLowerCase();
                this.iv_shouldbeHyphenMap.put(shouldbehyphen, new Integer(1));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot find the hyphenation file:" + hyphenfilename);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IOException accessing the hyphenation file:" + hyphenfilename);
            e.printStackTrace();
        }
    }

    private void filterTokens(List<Token> tokenList) {
        ArrayList<Token> removalList = new ArrayList<Token>();
        for (Token token : tokenList) {
            if (token.getType() != 4) continue;
            removalList.add(token);
        }
        tokenList.removeAll(removalList);
    }

    @Override
    public TextModification[] modify(String in) throws Exception {
        ArrayList<TextModification> textmods = new ArrayList<TextModification>();
        List<Token> inputtoks = this.iv_tokenizer.tokenizeAndSort(in);
        this.filterTokens(inputtoks);
        int orig_startOffset = 0;
        int orig_endOffset = 0;
        int new_startOffset = 0;
        int new_endOffset = 0;
        int j = 0;
        int end_offset_adj = 0;
        int start_offset_adj = 0;
        for (int i = 0; i < inputtoks.size(); ++i) {
            for (j = inputtoks.size() - (i + 1) < this.iv_windowSize ? inputtoks.size() - 1 : i + this.iv_windowSize; j > i; --j) {
                StringBuffer candSB = new StringBuffer();
                for (int k = i; k <= j; ++k) {
                    Token currtok = inputtoks.get(k);
                    candSB.append(" ");
                    candSB.append(currtok.getText());
                }
                String cand = candSB.toString().trim();
                if (!this.iv_shouldbeHyphenMap.containsKey(cand.toLowerCase())) continue;
                orig_startOffset = inputtoks.get(i).getStartOffset();
                orig_endOffset = inputtoks.get(j).getEndOffset();
                new_startOffset = orig_startOffset;
                new_endOffset = orig_endOffset;
                String newText = "";
                for (int k = i; k <= j; ++k) {
                    Token currtok = inputtoks.get(k);
                    newText = newText + currtok.getText() + "-";
                }
                newText = newText.substring(0, newText.length() - 1);
                int new_Length = newText.length();
                int orig_Length = orig_endOffset - orig_startOffset;
                TextModification tm = new TextModification(orig_startOffset, orig_endOffset, new_startOffset - start_offset_adj, new_endOffset - (end_offset_adj += orig_Length - new_Length), newText);
                start_offset_adj += orig_Length - new_Length;
                textmods.add(tm);
                i = j;
            }
        }
        TextModification[] tma = new TextModification[textmods.size()];
        for (int y = 0; y < tma.length; ++y) {
            tma[y] = (TextModification)textmods.get(y);
        }
        return tma;
    }

    private static boolean applyTextModifier(TextModifier tm, String text, StringBuffer sb) throws Exception {
        boolean unableToModifyText = false;
        TextModification[] textModArr = tm.modify(text);
        for (int i = 0; i < textModArr.length; ++i) {
            TextModification textMod = textModArr[i];
            if (textMod.getOrigStartOffset() != textMod.getNewStartOffset() || textMod.getOrigEndOffset() != textMod.getNewEndOffset()) {
                System.err.println("UNSUPPORTED: TextModification with offset changes.");
                unableToModifyText = true;
                continue;
            }
            sb.replace(textMod.getOrigStartOffset(), textMod.getOrigEndOffset(), textMod.getNewText());
        }
        return unableToModifyText;
    }

    public static ArrayList<String> test(HyphenTextModifierImpl tm, String text) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            TextModification[] tma = tm.modify(text);
            StringBuffer sb = new StringBuffer(text);
            boolean errorModifyingText = HyphenTextModifierImpl.applyTextModifier(tm, text, sb);
            messages.add("Orig: " + text);
            if (!errorModifyingText) {
                messages.add("New:  " + sb);
            } else {
                System.err.println("New:  (new text not generated, see previous messages)");
            }
            for (int u = 0; u < tma.length; ++u) {
                TextModification tmo = tma[u];
                messages.add(tmo.getNewText() + " Orig: " + tmo.getOrigStartOffset() + "-" + tmo.getOrigEndOffset() + " New: " + tmo.getNewStartOffset() + "-" + tmo.getNewEndOffset());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return messages;
    }

    public static void main(String[] args) {
        HyphenTextModifierImpl tm = new HyphenTextModifierImpl(args[0], 7);
        String t = "Non  Hodgkin's the x  ray without any non small  cell complications.";
        ArrayList<String> messages = HyphenTextModifierImpl.test(tm, t);
        for (String s : messages) {
            System.out.println(s);
        }
        t = t.replace("  ", " ");
        messages = HyphenTextModifierImpl.test(tm, t);
        for (String s : messages) {
            System.out.println(s);
        }
    }
}

