/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.examples.ae;

import java.util.Collection;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class ExampleHelloWorldAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SAVE_ANN = "PARAM_SAVE_ANN";
    public static final String PARAM_PRINT_ANN = "PARAM_PRINT_ANN";
    private Logger LOG = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    @ConfigurationParameter(name="PARAM_SAVE_ANN", mandatory=false, description="Example of Options/Parameters Save Annotation?")
    protected boolean saveAnnotation = true;
    @ConfigurationParameter(name="PARAM_PRINT_ANN", mandatory=false, description="Example of Options/Parameters Print Annotation?")
    protected boolean printAnnotation = true;

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        Collection tokens = JCasUtil.select((JCas)jcas, BaseToken.class);
        for (BaseToken token : tokens) {
            if (!this.saveAnnotation || token.getPartOfSpeech() == null || !token.getPartOfSpeech().startsWith("N")) continue;
            IdentifiedAnnotation ann = new IdentifiedAnnotation(jcas);
            ann.setBegin(token.getBegin());
            ann.setEnd(token.getEnd());
            ann.addToIndexes();
            if (!this.printAnnotation) continue;
            this.LOG.info((Object)("Token:" + token.getCoveredText() + " POS:" + token.getPartOfSpeech()));
        }
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
    }

    public static AnalysisEngineDescription createAnnotatorDescription(boolean saveAnn, boolean printAnn) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ExampleHelloWorldAnnotator.class, (Object[])new Object[]{PARAM_SAVE_ANN, saveAnn, PARAM_PRINT_ANN, printAnn});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ExampleHelloWorldAnnotator.class, (Object[])new Object[]{PARAM_SAVE_ANN, true, PARAM_PRINT_ANN, true});
    }
}

