/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.dao;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBUtil {
    private static final Log log = LogFactory.getLog(DBUtil.class);
    private static Properties ytexProperties;
    private static boolean oracle;
    private static boolean mysql;
    private static boolean mssql;
    private static boolean hsql;
    private static String escapeBegin;
    private static String escapeEnd;

    public static String getYTEXTablePrefix() {
        if (mssql) {
            return ytexProperties.getProperty("db.schema", "dbo") + ".";
        }
        return "";
    }

    public static String getEmptyString() {
        if (oracle) {
            return " ";
        }
        return "";
    }

    public static String getEscapeBegin() {
        return escapeBegin;
    }

    public static String getEscapeEnd() {
        return escapeEnd;
    }

    public static String nullToEmptyString(String param) {
        if (param == null) {
            return DBUtil.getEmptyString();
        }
        return param;
    }

    public static String formatFieldName(String fieldName) {
        return DBUtil.getEscapeBegin() + fieldName + DBUtil.getEscapeEnd();
    }

    public static String formatTableName(String tableName) {
        return DBUtil.getEscapeBegin() + tableName.replaceAll("\\.", DBUtil.getEscapeEnd() + '.' + DBUtil.getEscapeBegin()) + DBUtil.getEscapeEnd();
    }

    static {
        InputStream ytexPropsIn = null;
        try {
            ytexPropsIn = DBUtil.class.getResourceAsStream("/org/apache/ctakes/ytex/ytex.properties");
            ytexProperties = new Properties();
            ytexProperties.load(ytexPropsIn);
            oracle = "orcl".equals(ytexProperties.getProperty("db.type"));
            mysql = "mysql".equals(ytexProperties.getProperty("db.type"));
            hsql = "hsql".equals(ytexProperties.getProperty("db.type"));
            if (mssql) {
                escapeBegin = "[";
                escapeEnd = "]";
            } else if (mysql) {
                escapeBegin = "`";
                escapeEnd = "`";
            } else {
                escapeBegin = "";
                escapeEnd = "";
            }
        }
        catch (Exception e) {
            log.error((Object)"initalizer", (Throwable)e);
        }
        finally {
            if (ytexPropsIn != null) {
                try {
                    ytexPropsIn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

