/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.ctakes.core.util.DotLogger;
import org.apache.ctakes.utils.env.EnvironmentVariable;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public enum UmlsUserApprover {
    INSTANCE;

    public static final String OLD_USER_PARAM = "ctakes.umlsuser";
    public static final String OLD_PASS_PARAM = "ctakes.umlspw";
    public static final String URL_PARAM = "umlsUrl";
    public static final String USER_PARAM = "umlsUser";
    public static final String PASS_PARAM = "umlsPass";
    public static final String KEY_PARAM = "umlsKey";
    public static final String API_KEY_LABEL = "umls_api_key";
    public static final String OLDY_KEY_PROP = "ctakes.umls_apikey";
    private static final Logger LOGGER;
    private static final String CHANGEME = "CHANGEME";
    private static final String CHANGE_ME = "CHANGE_ME";
    private static final String OLD_USER_PASS_URL = "https://uts-ws.nlm.nih.gov/restful/isValidUMLSUser";
    private static final String UTS_APIKEY_URL = "https://utslogin.nlm.nih.gov/cas/v1/api-key";
    private static final String WHERE_DEFAULT = "Default Value";
    private static final String WHERE_ENV = "User Environment or Piper Variable";
    private static final String WHERE_XML = "Property Xml";
    private static final String NEW_AUTH_MESSAGE = "\n\n\nStarting 2021 NIH is using a new method for UMLS license authentication.  \n\nTo use the UMLS dictionary you must obtain a UMLS API Key.  \nAfter obtaining a Key, there are several methods to utilize it with Apache cTAKES.  \n\nYou may specify the value of your Key with a single parameter: \nctakes.umls_apikey in your Operating System, \numlsKey in your Operating System, \numlsKey in your Piper File, \numlsKey in your Dictionary Properties XML, \n--key in your Piper Runner command line, \n--key in your Clinical Pipeline Script command line, \n-Dctakes.umls_apikey in your Java command parameters, or \n-DumlsKey in your Java command parameters.  \n\nThe single key settings above will be preferred over the pre-2021 [UserName , Password] method.  \nThe pre-2021 [UserName , Password] method may still be used if the username is set to \numls_api_key and the password is set to the value of your Key.  \n\nFor more information visit \nhttps://cwiki.apache.org/confluence/display/CTAKES/cTAKES+4.0.0.1 \nhttps://uts.nlm.nih.gov/ \n\n\n";
    private static final Collection<String> _validUsers;

    public static UmlsUserApprover getInstance() {
        return INSTANCE;
    }

    public boolean isValidUMLSUser(UimaContext uimaContext, Properties properties) {
        String apiUrl = UmlsUserApprover.getUrl(properties);
        String umlsApiKey = UmlsUserApprover.getApiKey(uimaContext, properties);
        if (umlsApiKey != null) {
            return UmlsUserApprover.isValidUMLSUser(apiUrl, umlsApiKey);
        }
        String user = UmlsUserApprover.getUser(uimaContext, properties);
        String pass = UmlsUserApprover.getPassOrKey(uimaContext, properties);
        return this.isValidUMLSUser(apiUrl, null, user, pass);
    }

    public boolean isValidUMLSUser(String umlsUrl, String vendor, String user, String apikey) {
        if (!UmlsUserApprover.isValid(USER_PARAM, user) || !user.equals(API_KEY_LABEL)) {
            LOGGER.error((Object)NEW_AUTH_MESSAGE);
            return false;
        }
        if (!UmlsUserApprover.isValid(PASS_PARAM, apikey) || apikey.length() <= 24) {
            LOGGER.error((Object)NEW_AUTH_MESSAGE);
            return false;
        }
        if (_validUsers.contains(apikey)) {
            return true;
        }
        if (!UmlsUserApprover.isValid(umlsUrl) && !UmlsUserApprover.isValid(umlsUrl = UmlsUserApprover.getUrl())) {
            umlsUrl = UTS_APIKEY_URL;
        }
        return UmlsUserApprover.isValidUMLSUser(umlsUrl, apikey);
    }

    private static boolean isValidUMLSUser(String umlsUrl, String umlsApiKey) {
        if (_validUsers.contains(umlsApiKey)) {
            return true;
        }
        return UmlsUserApprover.authenticate(umlsUrl, umlsApiKey);
    }

    private static String getUrl() {
        return UmlsUserApprover.getUrl(System.getProperties());
    }

    private static String getUrl(Properties properties) {
        String where = WHERE_ENV;
        String umlsUrl = EnvironmentVariable.getEnv((String)URL_PARAM);
        if ((!UmlsUserApprover.isValid(umlsUrl) || umlsUrl.equals(OLD_USER_PASS_URL)) && UmlsUserApprover.isValid(umlsUrl = properties.getProperty(URL_PARAM)) && !umlsUrl.equals(OLD_USER_PASS_URL)) {
            where = WHERE_XML;
        }
        if (!UmlsUserApprover.isValid(umlsUrl) || umlsUrl.equals(OLD_USER_PASS_URL)) {
            umlsUrl = UTS_APIKEY_URL;
            where = WHERE_DEFAULT;
        }
        LOGGER.debug((Object)("Using umlsURL set using: " + where));
        return umlsUrl;
    }

    private static String getParamValue(UimaContext uimaContext, Properties properties, String name, String oldParam, String param) {
        String where = "User Environment or Piper Variable " + param;
        String value = EnvironmentVariable.getEnv((String)param, (UimaContext)uimaContext);
        if (!UmlsUserApprover.isValid(value)) {
            value = properties.getProperty(param);
            if (UmlsUserApprover.isValid(param, value)) {
                where = "Property Xml " + param;
            } else {
                value = null;
            }
        }
        if (value == null && UmlsUserApprover.isValid(value = EnvironmentVariable.getEnv((String)oldParam, (UimaContext)uimaContext))) {
            where = "User Environment or Piper Variable " + oldParam;
        }
        if (value != null) {
            LOGGER.debug((Object)(name + " set using: " + where));
        }
        return value;
    }

    private static String getApiKey(UimaContext uimaContext, Properties properties) {
        return UmlsUserApprover.getParamValue(uimaContext, properties, "UMLS API Key", OLDY_KEY_PROP, KEY_PARAM);
    }

    private static String getPassOrKey(UimaContext uimaContext, Properties properties) {
        return UmlsUserApprover.getParamValue(uimaContext, properties, "UMLS API Key", OLD_PASS_PARAM, PASS_PARAM);
    }

    private static String getUser(UimaContext uimaContext, Properties properties) {
        return UmlsUserApprover.getParamValue(uimaContext, properties, "UMLS User", OLD_USER_PARAM, USER_PARAM);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean authenticate(String umlsUrl, String apiKey) {
        try (DotLogger dotter = new DotLogger();){
            String trimline;
            String line;
            apiKey = apiKey.trim();
            LOGGER.info((Object)("Checking UMLS Account at " + umlsUrl + ":"));
            String data = "apikey=" + apiKey;
            URL url = new URL(umlsUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(data);
            writer.flush();
            boolean isValidUser = false;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null && !(trimline = line.trim()).isEmpty()) {
            }
            LOGGER.debug((Object)("UTS response: " + line));
            writer.close();
            reader.close();
            boolean bl = isValidUser = connection.getResponseCode() == 201;
            if (isValidUser) {
                LOGGER.info((Object)"  UMLS Account has been validated");
                _validUsers.add(apiKey);
            } else {
                LOGGER.error((Object)("  UMLS Account at " + umlsUrl + " is not valid."));
                LOGGER.error((Object)NEW_AUTH_MESSAGE);
            }
            boolean bl2 = isValidUser;
            return bl2;
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
            return false;
        }
    }

    public void resetUserCache() {
        _validUsers.clear();
    }

    private static boolean isValid(String value) {
        return value != null && !value.trim().isEmpty() && !value.equals(EnvironmentVariable.NOT_PRESENT);
    }

    private static boolean isValid(String name, String value) {
        if (UmlsUserApprover.isValid(value)) {
            if (value.trim().equals(CHANGEME) || value.trim().equals(CHANGE_ME)) {
                LOGGER.error((Object)("  " + name + " " + value + " not allowed.  It is a placeholder reminder."));
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        LOGGER = Logger.getLogger((String)"UmlsUserApprover");
        _validUsers = new ArrayList<String>();
    }
}

